/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin.compaction;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.service.admin.ServerRenderedPageServiceBase;
import com.teamscale.service.admin.compaction.DatabaseCompactionTrigger;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Optional;
import org.conqat.engine.persistence.store.IStorageSystemProvider;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.capability.ICompactionCapability;

@Path(value="api/database-compaction")
public class DatabaseCompactionService
extends ServerRenderedPageServiceBase {
    @GET
    @Hidden
    @Operation(summary="Run database compaction", description="Provides an UI to run a full compaction on the database.", tags={"System"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"text/html"})
    public String getDatabaseCompactionPage() {
        return this.buildHttpFormPage();
    }

    @POST
    @Operation(summary="Run database compaction", description="Allows running a full compaction on the database. WARNING: This is likely a very expensive operation.", responses={@ApiResponse(responseCode="400", description="The storage system in use does not support compaction.")}, tags={"System"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public void runDatabaseCompaction() throws StorageException {
        IStorageSystemProvider rootStorageSystem = this.serviceInfo.getIndexLayer().getRawStorageSystemProvider();
        Optional capability = rootStorageSystem.getCapability(ICompactionCapability.class);
        if (capability.isEmpty()) {
            throw new BadRequestException("The storage system in use does not support compaction.");
        }
        ISchedulerCommunicator.getInstance().scheduleExternalJob(this.getIndexLayer(), new JobDescriptor(SchedulingConstants.MAINTENANCE_PROJECT_INTERNAL_ID, DatabaseCompactionTrigger.class, null, null, "Scheduled through the database compaction service by the user '" + this.getUser().getUsername() + "'."));
    }
}

