/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin.sap;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.index.repository.sap.abapsystem.AbapProjectUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.index.shared.ProjectIdBase;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/projects-by-sap-system-id")
public class SapSystemIdLookupService
extends ApiBase {
    @GET
    @Path(value="{sapSystemId}")
    @PublicApi(since=ETeamscaleVersion.VERSION_5_7_0)
    @Operation(summary="Get projects corresponding to given SAP system ID.", description="Looks up Teamscale projects by SAP System ID. Returns project aliases or project IDs if no alias available.", tags={"SAP", "Project"})
    @RequiresNoPermission(description="The service will only search among projects visible to current user.")
    public List<String> lookupProjectBySapSystemId(@Parameter(description="System ID of SAP system") @PathParam(value="sapSystemId") String systemId) throws StorageException {
        return CollectionUtils.map((Collection)AbapProjectUtils.getProjects((String)systemId, (IndexLayer)this.getIndexLayer(), (ServicePermissions)this.getPermissions()), ProjectIdBase::toString);
    }
}

