/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import com.google.common.base.Preconditions;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.testgap.treemap.TreeMapNode;
import com.teamscale.service.audit.CodeComponentsTreeMapService;
import com.teamscale.service.metrics.treemap.FilteredTreeMapWrapper;
import com.teamscale.service.metrics.treemap.TreemapQueryOptions;
import com.teamscale.service.metrics.treemap.builder.MetricTreemapBuilderBase;
import com.teamscale.service.metrics.treemap.builder.MetricTreemapBuilderParameters;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import eu.cqse.check.framework.scanner.ELanguage;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.color.ColorUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class CodeComponentsTreeMapBuilder
extends MetricTreemapBuilderBase<TreeMapNode> {
    private static final boolean GROUP_FILES_IN_ROOT_FOLDER = true;
    private final UniformPath selectedUniformPath;
    private String highlightColor;
    private final Pattern highlightPattern;
    private final CodeComponentsTreeMapService.EVisualizationContent visualizationContent;
    private final Map<String, Color> colorByComponentId = new LinkedHashMap<String, Color>();

    protected CodeComponentsTreeMapBuilder(IMetricRetrievalStrategy metricRetrievalStrategy, HistoryAccessOption historyAccessOption, UniformPath uniformPath, TreemapQueryOptions treemapRequestOptions, String highlightColor, Pattern highlightPattern, CodeComponentsTreeMapService.EVisualizationContent visualizationContent) {
        super(metricRetrievalStrategy, historyAccessOption, treemapRequestOptions.areaMetricIndex, new MetricTreemapBuilderParameters(treemapRequestOptions.includePattern, treemapRequestOptions.excludePattern, treemapRequestOptions.colorMetricIndex, treemapRequestOptions.colorMetricDefaultValue, treemapRequestOptions.baseColor));
        this.selectedUniformPath = uniformPath;
        this.highlightColor = highlightColor;
        this.highlightPattern = highlightPattern;
        this.visualizationContent = visualizationContent;
    }

    @Override
    protected TreeMapNode buildTreeMapNodes(List<MetricDirectoryEntry> entries) throws StorageException, TreeMapBuilderException {
        this.computeComponents(entries);
        return super.buildTreeMapNodes(entries);
    }

    private void computeComponents(List<MetricDirectoryEntry> entries) {
        LinkedHashSet<String> allComponentIds = new LinkedHashSet<String>();
        HashSet<String> nonEmptyComponentIds = new HashSet<String>();
        for (MetricDirectoryEntry entry : entries) {
            Double areaMetricValue = entry.getDoubleValueWithoutNullAssert(this.areaMetricIndex);
            if (areaMetricValue == null) continue;
            String componentId = this.computeComponentId(entry);
            allComponentIds.add(componentId);
            if (!(areaMetricValue > 0.0)) continue;
            nonEmptyComponentIds.add(componentId);
        }
        this.assignColorToComponents(allComponentIds, nonEmptyComponentIds);
    }

    private void assignColorToComponents(LinkedHashSet<String> allComponentIds, Set<String> nonEmptyComponentIds) {
        int neededColorCount = nonEmptyComponentIds.size();
        IColorManager colorManager = this.createColorManager(neededColorCount);
        int usedColorCount = 0;
        for (String componentId : allComponentIds) {
            if (!nonEmptyComponentIds.contains(componentId)) {
                this.colorByComponentId.put(componentId, colorManager.getNeutralColor());
                continue;
            }
            if (this.highlightPattern != null && !this.highlightPattern.matcher(componentId).find()) {
                this.colorByComponentId.put(componentId, colorManager.getNeutralColor());
                ++usedColorCount;
                continue;
            }
            this.colorByComponentId.put(componentId, colorManager.getColor(usedColorCount));
            ++usedColorCount;
        }
    }

    private String computeComponentId(MetricDirectoryEntry entry) {
        if (this.visualizationContent == CodeComponentsTreeMapService.EVisualizationContent.TOP_LEVEL_COMPONENTS) {
            String uniformPath = entry.getUniformPath();
            if (!(uniformPath = StringUtils.stripPrefix((String)uniformPath, (String)(String.valueOf(this.selectedUniformPath) + "/"))).contains("/")) {
                return "/";
            }
            return StringUtils.getFirstPart((String)uniformPath, (String)"/");
        }
        if (this.visualizationContent == CodeComponentsTreeMapService.EVisualizationContent.LANGUAGES) {
            return CodeComponentsTreeMapBuilder.getLanguage(entry).toString();
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.visualizationContent));
    }

    @Override
    protected TreeMapNode createNode(MetricDirectoryEntry entry) {
        double areaMetricValue = entry.getDoubleValue(this.areaMetricIndex);
        String componentId = this.computeComponentId(entry);
        Color componentColor = this.colorByComponentId.get(componentId);
        return new TreeMapNode(entry.getUniformPath(), areaMetricValue, "Component: " + componentId, componentColor);
    }

    @Override
    protected Pair<Double, Double> determineValueRangeForColorMetric(List<MetricDirectoryEntry> entries) {
        return new Pair((Object)0.0, (Object)1.0);
    }

    protected FilteredTreeMapWrapper getWrapper(UniformPath uniformPath) throws StorageException, TreeMapBuilderException {
        FilteredTreeMapWrapper treemapWrapper = new FilteredTreeMapWrapper(new ArrayList<String>(), null, 1, 0, 0, 0);
        Object treemap = this.buildTreeMap(uniformPath);
        treemapWrapper.setTreemap((TreeMapNode)treemap);
        return treemapWrapper;
    }

    private static ELanguage getLanguage(MetricDirectoryEntry entry) {
        return ELanguage.fromPath((String)entry.getUniformPath());
    }

    protected IColorManager createColorManager(int colorCount) {
        if (this.highlightPattern != null) {
            return new PredefinedColorManager(Color.decode(this.highlightColor));
        }
        return new GeneratedColorManager(colorCount);
    }

    public LinkedHashMap<String, String> getColorHashByLegendText() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Color> entry : this.colorByComponentId.entrySet()) {
            result.put(entry.getKey(), ColorUtils.toHexString((Color)entry.getValue()));
        }
        return result;
    }

    private static interface IColorManager {
        public Color getNeutralColor();

        public Color getColor(int var1);
    }

    protected static class PredefinedColorManager
    implements IColorManager {
        private Color colorToUse;

        public PredefinedColorManager(Color color) {
            this.colorToUse = color;
        }

        @Override
        public Color getNeutralColor() {
            return Color.WHITE;
        }

        @Override
        public Color getColor(int colorIndex) {
            return this.colorToUse;
        }
    }

    protected static class GeneratedColorManager
    implements IColorManager {
        private final int colorCount;

        public GeneratedColorManager(int colorCount) {
            this.colorCount = colorCount;
        }

        @Override
        public Color getNeutralColor() {
            return Color.WHITE;
        }

        @Override
        public Color getColor(int colorIndex) {
            Preconditions.checkElementIndex((int)colorIndex, (int)this.colorCount);
            float colorValue = (float)colorIndex / (float)this.colorCount;
            colorValue = 1.0f - colorValue;
            colorValue = (float)((double)colorValue + 0.73);
            if (colorValue > 1.0f) {
                colorValue -= 1.0f;
            }
            return Color.getHSBColor(colorValue, 1.0f, 1.0f);
        }
    }
}

