/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.authenticate;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.NewCookie;
import java.net.URI;
import java.time.Duration;
import java.util.Optional;

public class SSORequestCookieHandler {
    public static final String SSO_COOKIE_NAME = "teamscale-sso";
    private static final Duration COOKIE_MAX_AGE = Duration.ofMinutes(10L);

    public static NewCookie createNewSSOCookie(URI baseUri, String sessionId) {
        boolean secure = "https".equals(baseUri.getScheme()) && !Boolean.getBoolean("com.teamscale.ssl.disable-redirect");
        return ((NewCookie.Builder)((NewCookie.Builder)((NewCookie.Builder)((NewCookie.Builder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.AbstractNewCookieBuilder)new NewCookie.Builder(SSO_COOKIE_NAME).value(sessionId)).path("/")).version(1)).httpOnly(true)).maxAge(Math.toIntExact(COOKIE_MAX_AGE.toSeconds()))).secure(secure)).sameSite(secure ? NewCookie.SameSite.NONE : NewCookie.SameSite.LAX)).build();
    }

    public static Optional<String> getSSOCookieValue(ContainerRequestContext requestContext) {
        Cookie cookie = (Cookie)requestContext.getCookies().get(SSO_COOKIE_NAME);
        if (cookie == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(cookie.getValue());
    }
}

