/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.documentation.analysis_profile;

import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.service.documentation.DocumentationNodeBase;
import com.teamscale.service.documentation.analysis_profile.OptionDocumentation;
import com.teamscale.service.documentation.layout.Layouter;
import eu.cqse.check.framework.core.EFindingEnablement;
import java.util.Comparator;
import java.util.List;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.string.StringUtils;

public class FindingDocumentation
extends DocumentationNodeBase<OptionDocumentation> {
    protected final EFindingEnablement enablement;
    private final EAnalysisTool tool;
    protected final String ruleId;
    private final List<OptionDocumentation> options;

    public FindingDocumentation(String readableName, String description, EFindingEnablement enablement, EAnalysisTool tool, String ruleId, List<OptionDocumentation> optionDocumentations) {
        super(readableName, description);
        this.enablement = enablement;
        this.tool = tool;
        this.ruleId = ruleId;
        this.options = optionDocumentations;
    }

    @Override
    protected List<OptionDocumentation> getChildren() {
        return this.options;
    }

    @Override
    protected void layoutStart(Layouter layouter) {
        layouter.appendHeading(layouter.escape(this.readableName), 4);
        layouter.append(this.getEnablementText(true, layouter));
        layouter.appendNewParagraph();
        if (this.description != null) {
            layouter.append(this.description + " ");
        }
        if (this.ruleId != null) {
            layouter.append("Rule ID: ");
            layouter.appendEscaped(this.ruleId);
        }
        layouter.appendNewParagraph();
        if (this.hasChildren()) {
            layouter.append("Check configuration:");
            layouter.appendNewParagraph();
            layouter.appendBulletListStart();
        }
    }

    protected String getEnablementText(boolean withBrackets, Layouter layouter) {
        String enablementText = this.enablement.name();
        if (withBrackets) {
            enablementText = StringUtils.surroundWith((String)enablementText, (String)"(", (String)")");
        }
        switch (this.enablement) {
            case YELLOW: {
                return " " + layouter.colorize(enablementText, ETrafficLightColor.YELLOW);
            }
            case RED: {
                return " " + layouter.colorize(enablementText, ETrafficLightColor.RED);
            }
        }
        return "";
    }

    @Override
    protected void layoutEnd(Layouter layouter) {
        if (this.hasChildren()) {
            layouter.appendBulletListEnd();
            layouter.appendNewLine();
        } else {
            super.layoutEnd(layouter);
        }
    }

    @Override
    protected <T extends DocumentationNodeBase<?>> int compareTo(T o) {
        if (!(o instanceof FindingDocumentation)) {
            return super.compareTo(o);
        }
        FindingDocumentation other = (FindingDocumentation)o;
        return Comparator.comparing(findingDocumentation -> findingDocumentation.enablement).reversed().thenComparing(FindingDocumentation2 -> FindingDocumentation2.readableName).compare(this, other);
    }
}

