/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external.input;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.external.input.ExternalAnalysisImportService;
import com.teamscale.service.external.input.ExternalAnalysisSessionService;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceQueryOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.util.LegacyApiUtils;
import com.teamscale.service.framework.versioning.LegacyApi;
import com.teamscale.service.upload.base.LegacyExternalReportUploadServiceUtils;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.conqat.engine.persistence.store.StorageException;

@Hidden
@LegacyApi
@Path(value="p/{project}/external-analysis")
public class LegacyExternalAnalysisImportService
extends ApiBase {
    @Context
    private ResourceContext resourceContext;

    @GET
    @Operation(summary="Get session ID", description="This endpoint is used to obtain a new session ID.", tags={"External Analysis"}, responses={@ApiResponse(responseCode="400", description="Partition name not provided."), @ApiResponse(responseCode="400", description="Revision provided in the query parameter could not be found."), @ApiResponse(responseCode="400", description="Upload was rejected, because it refers to a timestamp too far back in time.")})
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    public Response obtainSessionId(@BeanParam SessionBasedExternalAnalysisServiceQueryOptions parameters) throws StorageException {
        ExternalAnalysisSessionService resource = (ExternalAnalysisSessionService)this.resourceContext.getResource(ExternalAnalysisSessionService.class);
        return LegacyApiUtils.plainText((String)resource.createSession(parameters));
    }

    @POST
    @Path(value="{sessionId}")
    @Operation(summary="Upload external metrics", description="Commits and closes the given session.The content of the request body is ignored.", tags={"External Analysis"}, responses={@ApiResponse(responseCode="404", description="No session with provided id found.")})
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    public Response commitAnalysisResults(@PathParam(value="sessionId") String sessionId) throws StorageException {
        return LegacyApiUtils.apiCallWithSuccess(ExternalAnalysisSessionService.class, (ResourceContext)this.resourceContext, resource -> resource.commitAnalysisResults(sessionId), (LegacyApiUtils.ExceptionWrapper[])new LegacyApiUtils.ExceptionWrapper[0]);
    }

    @PUT
    @Path(value="{sessionId}")
    @Operation(summary="Insert results into session", description="Adds results for one or more file to the session. For performance reasons, it is recommended to batch calls to this service, i.e. not commit all files using single calls.", tags={"External Analysis"}, responses={@ApiResponse(responseCode="400", description="Partition name not provided."), @ApiResponse(responseCode="400", description="Provided partition name is different from the one used to create the session."), @ApiResponse(responseCode="400", description="Provided upload message is different from the one used to create the session."), @ApiResponse(responseCode="400", description="Revision provided in the query parameter could not be found."), @ApiResponse(responseCode="400", description="No session with provided id found."), @ApiResponse(responseCode="400", description="Upload was rejected, because it refers to a timestamp too far back in time.")})
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    public Response insertAnalysisResults(@PathParam(value="sessionId") String sessionId, @BeanParam SessionBasedExternalAnalysisServiceQueryOptions parameters, @RequestBody(required=true) ExternalAnalysisImportInfos importInfos) throws StorageException {
        return LegacyApiUtils.apiCallWithSuccess(ExternalAnalysisImportService.class, (ResourceContext)this.resourceContext, resource -> resource.uploadExternalAnalysisResults(sessionId, parameters, importInfos), (LegacyApiUtils.ExceptionWrapper[])new LegacyApiUtils.ExceptionWrapper[]{LegacyExternalReportUploadServiceUtils.notFoundToBadRequestUnlessUnknownSession(), LegacyExternalReportUploadServiceUtils.closedSessionToInternalServerError()});
    }

    @PUT
    @Operation(summary="Insert results into session", description="Adds results for one or more file to the session. For performance reasons, it is recommended to batch calls to this service, i.e. not commit all files using single calls.", tags={"External Analysis"}, responses={@ApiResponse(responseCode="400", description="Partition name not provided."), @ApiResponse(responseCode="400", description="Provided partition name is different from the one used to create the session."), @ApiResponse(responseCode="400", description="Provided upload message is different from the one used to create the session."), @ApiResponse(responseCode="400", description="Revision provided in the query parameter could not be found."), @ApiResponse(responseCode="400", description="No session with provided id found."), @ApiResponse(responseCode="400", description="Upload was rejected, because it refers to a timestamp too far back in time.")})
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    public Response insertAnalysisResults(@BeanParam SessionBasedExternalAnalysisServiceQueryOptions parameters, @RequestBody(required=true) ExternalAnalysisImportInfos externalAnalysisImportInfos) throws StorageException {
        return this.insertAnalysisResults("auto-create", parameters, externalAnalysisImportInfos);
    }

    @DELETE
    @Path(value="{sessionId}")
    @Operation(summary="Delete session", description="This method is used to delete a session in case of abortion.", tags={"External Analysis"}, responses={@ApiResponse(responseCode="400", description="No session with provided id found.")})
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    public Response deleteAnalysisResults(@Parameter(description="If session ID is provided, the results will be appended to the given session instead of creating a new session. Use \"auto-create\" in place of session ID to create a new session, perform upload and commit session in one step.") @PathParam(value="sessionId") String sessionId) throws StorageException {
        return LegacyApiUtils.apiCallWithSuccess(ExternalAnalysisSessionService.class, (ResourceContext)this.resourceContext, resource -> resource.deleteAnalysisResults(sessionId), (LegacyApiUtils.ExceptionWrapper[])new LegacyApiUtils.ExceptionWrapper[]{LegacyApiUtils.wrapNotFoundInBadRequest()});
    }
}

