/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings.badge;

import com.teamscale.index.findings.calculation.FindingDeltaCount;
import com.teamscale.service.framework.badge.BadgeCreatorBase;
import jakarta.ws.rs.InternalServerErrorException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

public class FindingBadgeCreator
extends BadgeCreatorBase {
    private static final String FINDING_BADGE_TEMPLATE_NAME = "finding-badge-template.svg";
    private static final String GRAY_BADGE_TEMPLATE_NAME = "gray-single-value-badge-template.svg";
    public static final int INNER_MARGIN = 4;
    public static final int OUTER_MARGIN = 10;
    public static final int ICON_WIDTH = 15;
    private static final int FIRST_FINDING_VALUE_SEGMENT_OFFSET = 57;
    private final int addedFindings;
    private final int inChangedCodeFindings;
    private final int removedFindings;
    private final boolean showZeroFindings;

    public FindingBadgeCreator(int addedFindings, int inChangedCodeFindings, int removedFindings, boolean showZeroFindings) {
        this.addedFindings = addedFindings;
        this.inChangedCodeFindings = inChangedCodeFindings;
        this.removedFindings = removedFindings;
        this.showZeroFindings = showZeroFindings;
    }

    public FindingBadgeCreator(FindingDeltaCount findingDelta, boolean showZeroFindings) {
        this(findingDelta.addedFindings(), findingDelta.findingsInChangedCode(), findingDelta.removedFindings(), showZeroFindings);
    }

    public String createBadge() throws InternalServerErrorException {
        if (this.areNoFindingsToDisplay()) {
            return FindingBadgeCreator.getSvgTemplate((String)GRAY_BADGE_TEMPLATE_NAME, ((Object)((Object)this)).getClass());
        }
        return this.createBadge(FINDING_BADGE_TEMPLATE_NAME, this.getFindingsBadgeValueMap());
    }

    private Map<String, String> getFindingsBadgeValueMap() {
        HashMap<String, String> replacements = new HashMap<String, String>();
        this.putPlaceholderFindingsValue(replacements, ESvgTemplatePlaceholder.ADDED_FINDINGS, this.addedFindings);
        this.putPlaceholderFindingsValue(replacements, ESvgTemplatePlaceholder.UNMODIFIED_FINDINGS, this.inChangedCodeFindings);
        this.putPlaceholderFindingsValue(replacements, ESvgTemplatePlaceholder.REMOVED_FINDINGS, this.removedFindings);
        PairList badgePartitionValues = PairList.zip(Arrays.asList("SVG_ADDED_", "SVG_UNMODIFIED_", "SVG_REMOVED_"), Arrays.asList(this.addedFindings, this.inChangedCodeFindings, this.removedFindings));
        if (!this.showZeroFindings) {
            badgePartitionValues.stream().filter(pair -> (Integer)pair.getSecond() == 0).map(ImmutablePair::getFirst).forEach(placeholderPrefix -> {
                ESvgTemplatePlaceholder.valueOf(placeholderPrefix + "ICON_WIDTH").insertInto(replacements, "0");
                ESvgTemplatePlaceholder.valueOf(placeholderPrefix + "ICON_X").insertInto(replacements, "0");
                ESvgTemplatePlaceholder.valueOf(placeholderPrefix + "TEXT_X").insertInto(replacements, "0");
            });
            badgePartitionValues = (PairList)badgePartitionValues.stream().filter(pair -> (Integer)pair.getSecond() != 0).collect(PairList.toPairList());
        }
        int imageWidth = 60;
        for (int i = 0; i < badgePartitionValues.size(); ++i) {
            boolean isFirstSegment = i == 0;
            boolean isLastSegment = i == badgePartitionValues.size() - 1;
            String formattedValue = StringUtils.format((Number)((Number)badgePartitionValues.getSecond(i)));
            int textWidth = FindingBadgeCreator.computeTextWidth((String)formattedValue);
            String placeholderPrefix2 = (String)badgePartitionValues.getFirst(i);
            imageWidth += FindingBadgeCreator.formatBadgeSegment(imageWidth, isFirstSegment, isLastSegment, textWidth, placeholderPrefix2, replacements);
        }
        ESvgTemplatePlaceholder.SVG_RECT_WIDTH.insertInto(replacements, String.valueOf(imageWidth));
        return replacements;
    }

    private void putPlaceholderFindingsValue(Map<String, String> replacements, ESvgTemplatePlaceholder placeholder, int numberOfFindings) {
        if (numberOfFindings > 0 || this.showZeroFindings) {
            placeholder.insertInto(replacements, StringUtils.format((Number)numberOfFindings));
        }
    }

    private static int formatBadgeSegment(int xPosition, boolean isFirstSegment, boolean isLastSegment, int textWidth, String placeholderPrefix, Map<String, String> replacements) {
        ESvgTemplatePlaceholder.valueOf(placeholderPrefix + "ICON_WIDTH").insertInto(replacements, String.valueOf(15));
        int iconXPosition = xPosition + 4;
        if (isFirstSegment) {
            iconXPosition = 10;
        }
        ESvgTemplatePlaceholder.valueOf(placeholderPrefix + "ICON_X").insertInto(replacements, String.valueOf(iconXPosition + (isFirstSegment ? 57 : 0)));
        int rectangleWidth = 19 + textWidth;
        rectangleWidth = isFirstSegment ? (rectangleWidth += 10) : (rectangleWidth += 4);
        rectangleWidth = isLastSegment ? (rectangleWidth += 10) : (rectangleWidth += 4);
        ESvgTemplatePlaceholder.valueOf(placeholderPrefix + "RECT_PATH_D").insertInto(replacements, FindingBadgeCreator.svgRectanglePath((int)xPosition, (int)rectangleWidth));
        int textXPosition = iconXPosition + 15 + 4;
        ESvgTemplatePlaceholder.valueOf(placeholderPrefix + "TEXT_X").insertInto(replacements, String.valueOf(textXPosition + (isFirstSegment ? 57 : 0)));
        return rectangleWidth;
    }

    private boolean areNoFindingsToDisplay() {
        return !this.showZeroFindings && this.addedFindings == 0 && this.inChangedCodeFindings == 0 && this.removedFindings == 0;
    }

    public static enum ESvgTemplatePlaceholder {
        ADDED_FINDINGS("added_findings"),
        UNMODIFIED_FINDINGS("unmodified_findings"),
        REMOVED_FINDINGS("removed_findings"),
        COMMIT_ALERTS("commit_alerts"),
        SVG_RECT_WIDTH("rect_width"),
        SVG_ADDED_RECT_PATH_D("added_rect_path_d"),
        SVG_UNMODIFIED_RECT_PATH_D("unmodified_rect_path_d"),
        SVG_REMOVED_RECT_PATH_D("removed_rect_path_d"),
        SVG_ALERT_RECT_PATH_D("alert_rect_path_d"),
        SVG_ADDED_ICON_X("added_icon_x"),
        SVG_ADDED_ICON_WIDTH("added_icon_width"),
        SVG_ADDED_TEXT_X("added_text_x"),
        SVG_UNMODIFIED_ICON_X("unmodified_icon_x"),
        SVG_UNMODIFIED_ICON_WIDTH("unmodified_icon_width"),
        SVG_UNMODIFIED_TEXT_X("unmodified_text_x"),
        SVG_REMOVED_ICON_X("removed_icon_x"),
        SVG_REMOVED_ICON_WIDTH("removed_icon_width"),
        SVG_REMOVED_TEXT_X("removed_text_x"),
        SVG_ALERT_ICON_X("alert_icon_x"),
        SVG_ALERT_ICON_WIDTH("alert_icon_width"),
        SVG_ALERT_TEXT_X("alert_text_x"),
        SVG_GRAY_BADGE_TEXT_X("gray_badge_text_x"),
        SVG_GRAY_BADGE_TEXT("gray_badge_text"),
        SVG_GRAY_BADGE_PATH_D("gray_badge_path_d"),
        ICON_AND_TEXT_COLOR("icon_and_text_color");

        private final String svgPlaceholderName;

        private ESvgTemplatePlaceholder(String svgPlaceholderName) {
            this.svgPlaceholderName = svgPlaceholderName;
        }

        public void insertInto(Map<String, String> replacements, String value) {
            replacements.put(this.svgPlaceholderName, value);
        }
    }
}

