/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.treemap.builder;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.directory.MetricDirectoryIndexSynchronizerBase;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.testgap.treemap.TreeMapNode;
import com.teamscale.index.testgap.treemap.TreeMapNodeBase;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public abstract class TreemapBuilderBase<T extends TreeMapNode> {
    private static final double NODE_SIZE_THRESHOLD = 1.0E-5;
    protected HistoryAccessOption historyAccessOption;
    protected int areaMetricIndex;
    protected IMetricRetrievalStrategy metricRetrievalStrategy;
    protected final SupplierWithException<MetricDirectorySchema, StorageException> metricDirectorySchemaSupplier;

    protected TreemapBuilderBase(IMetricRetrievalStrategy metricRetrievalStrategy, HistoryAccessOption historyAccessOption, int areaMetricIndex) {
        this.metricRetrievalStrategy = metricRetrievalStrategy;
        this.areaMetricIndex = areaMetricIndex;
        this.historyAccessOption = historyAccessOption;
        this.metricDirectorySchemaSupplier = SupplierWithException.memoize(() -> ((IMetricRetrievalStrategy)metricRetrievalStrategy).getMetricDirectorySchema());
    }

    public T buildTreeMap(UniformPath uniformPath) throws StorageException, TreeMapBuilderException {
        List<MetricDirectoryEntry> entries = this.filterEntries(this.getEntriesFor(uniformPath), uniformPath.toString());
        if (entries.isEmpty()) {
            entries.add(this.createMetricDirectoryEntryWithDefaultValue(uniformPath));
        }
        TreemapBuilderBase.sortEntries(entries);
        this.afterEntryPreparation(entries);
        this.determineValueRange(entries);
        T rootNode = this.buildTreeMapNodes(entries);
        if (rootNode == null) {
            throw new TreeMapBuilderException("No data available!");
        }
        rootNode.recalculateAreaAggregates();
        return rootNode;
    }

    protected MetricDirectoryEntry createMetricDirectoryEntryWithDefaultValue(UniformPath uniformPath) throws StorageException {
        return MetricDirectoryIndexSynchronizerBase.createMetricDirectoryEntryWithDefaultValue((String)uniformPath.toString(), (MetricDirectorySchema)((MetricDirectorySchema)this.metricDirectorySchemaSupplier.get()));
    }

    private static void sortEntries(List<MetricDirectoryEntry> entries) {
        Collections.sort(entries);
    }

    protected void afterEntryPreparation(List<MetricDirectoryEntry> entries) throws StorageException {
    }

    protected abstract void determineValueRange(List<MetricDirectoryEntry> var1) throws TreeMapBuilderException;

    protected List<MetricDirectoryEntry> getEntriesFor(UniformPath uniformPath) throws StorageException, TreeMapBuilderException {
        return this.getEntriesFor(uniformPath, this.historyAccessOption);
    }

    protected List<MetricDirectoryEntry> getEntriesFor(UniformPath uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        return this.metricRetrievalStrategy.getMetricDirectoryEntries(Collections.singletonList(uniformPath.toString()), historyAccessOption);
    }

    protected T buildTreeMapNodes(List<MetricDirectoryEntry> entries) throws StorageException, TreeMapBuilderException {
        T root = null;
        for (MetricDirectoryEntry entry : entries) {
            if (root == null) {
                root = this.createNode(entry);
                continue;
            }
            String relativePath = StringUtils.stripPrefix((String)entry.getUniformPath(), (String)root.getUniformPath());
            this.insertEntryIntoTreeMap(entry, root, relativePath);
        }
        return root;
    }

    protected abstract T createNode(MetricDirectoryEntry var1) throws StorageException, TreeMapBuilderException;

    private void insertEntryIntoTreeMap(MetricDirectoryEntry entry, T rootNode, String localUniformPath) throws StorageException, TreeMapBuilderException {
        if (TreemapBuilderBase.isMetricBelowThreshold(entry, this.areaMetricIndex)) {
            return;
        }
        TreeMapNode node = (TreeMapNode)TreemapBuilderBase.getNodeByPath(rootNode, localUniformPath);
        if (node != null) {
            node.addChild(this.createNode(entry));
        }
    }

    protected List<MetricDirectoryEntry> filterEntries(List<MetricDirectoryEntry> entries, String rootPath) {
        return entries;
    }

    private static boolean isMetricBelowThreshold(MetricDirectoryEntry entry, int metricIndex) {
        double area = ((Number)entry.getValueOrDefault(metricIndex, (Object)0.0)).doubleValue();
        return area < 1.0E-5;
    }

    private static <T extends TreeMapNodeBase<?>> T getNodeByPath(T rootNode, String localUniformPath) {
        localUniformPath = StringUtils.stripPrefix((String)localUniformPath, (String)UniformPathUtils.SEPARATOR);
        String[] path = UniformPathUtils.splitPath((String)localUniformPath);
        Object node = rootNode;
        for (int i = 0; i < path.length - 1; ++i) {
            TreeMapNodeBase childNode = node.getChild(path[i]);
            if (childNode == null) {
                return null;
            }
            node = childNode;
        }
        return node;
    }
}

