/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.external.status.EExternalAnalysisResultType;
import com.teamscale.index.findings.calculation.AffectedFilesUtils;
import com.teamscale.index.findings.calculation.TokenElementChurnWithOriginInfo;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.RepositoryLogFileIndex;
import com.teamscale.index.repository.history.EChangeEntryOrigin;
import com.teamscale.index.repository.history.EElementHistoryChangeType;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.util.CsvServiceUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.enums.EnumUtils;
import org.jspecify.annotations.Nullable;
import org.supercsv.io.CsvListWriter;

@Path(value="api/projects/{project}/commits/affected-files")
public class AffectedFilesService
extends ApiBase {
    private static final String TYPE_PARAMETER_DESCRIPTION = "The commit type or subtype to include in the response. One of ECommitType or EExternalAnalysisResultType. For regular code commits, the type is 'CODE_COMMIT', which is also the default value.";

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get affected files by commits", description="Returns a wrapper object with repository log file entries for commits, i.e. the association between files and repository log entries. The returned typeCounts mapping will always count the entries across all types (not just the passed one)", tags={"Project", "Test Gap Analysis"})
    public AffectedFiles getAffectedFilesForCommits(@QueryParam(value="commit") List<UnresolvedCommitDescriptor> commits, @Parameter(description="The commit type or subtype to include in the response. One of ECommitType or EExternalAnalysisResultType. For regular code commits, the type is 'CODE_COMMIT', which is also the default value.") @QueryParam(value="type") @Nullable String typeOrSubType) throws StorageException {
        ECommitType type = null;
        EExternalAnalysisResultType subType = null;
        if (typeOrSubType != null) {
            type = (ECommitType)EnumUtils.valueOf(ECommitType.class, (String)typeOrSubType);
            subType = (EExternalAnalysisResultType)EnumUtils.valueOf(EExternalAnalysisResultType.class, (String)typeOrSubType);
            if (type == null && subType == null) {
                throw new BadRequestException("Unknown type, expected one of ECommitType or EExternalAnalysisResultType but was: " + typeOrSubType);
            }
        }
        List resolvedCommits = CollectionUtils.mapWithException(commits, this::resolve);
        List logFileEntries = this.openProjectIndex(RepositoryLogFileIndex.class, null).getEntriesByCommits(resolvedCommits);
        List affectedFiles = AffectedFilesUtils.getAffectedFiles((ProjectStorageSystem)this.getProjectStorageSystem(), (List)resolvedCommits, (ECommitType)type);
        CounterSet typeCounts = new CounterSet();
        SetMap typesByUniformPath = new SetMap();
        SetMap subTypesByUniformPath = new SetMap();
        logFileEntries.forEach(fileEntry -> {
            if (fileEntry.getSubType() != null) {
                typeCounts.inc((Object)fileEntry.getSubType().name());
                subTypesByUniformPath.add((Object)fileEntry.getUniformPath().toStringAsMigrationFrontier(), (Object)fileEntry.getSubType());
            } else {
                typeCounts.inc((Object)fileEntry.getCommitType().name());
                typesByUniformPath.add((Object)fileEntry.getUniformPath().toStringAsMigrationFrontier(), (Object)fileEntry.getCommitType());
            }
        });
        ArrayList<ElementChurnWithCommitTypes> entries = new ArrayList<ElementChurnWithCommitTypes>();
        for (TokenElementChurnWithOriginInfo affectedFile : affectedFiles) {
            if (typeOrSubType != null && (type == null || !((Set)typesByUniformPath.getCollectionOrEmpty((Object)affectedFile.getUniformPath())).contains(type)) && (subType == null || !((Set)subTypesByUniformPath.getCollectionOrEmpty((Object)affectedFile.getUniformPath())).contains(subType))) continue;
            entries.add(new ElementChurnWithCommitTypes(affectedFile, (Set)typesByUniformPath.getCollectionOrEmpty((Object)affectedFile.getUniformPath()), (Set)subTypesByUniformPath.getCollectionOrEmpty((Object)affectedFile.getUniformPath())));
        }
        return new AffectedFiles(entries, (CounterSet<String>)typeCounts);
    }

    @GET
    @Path(value="csv")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get affected files for the given commits as CSV", description="Returns repository log file entries for commits, i.e. the association between files and repository log entries.", tags={"Project", "Test Gap Analysis"})
    public Response getAffectedFilesCsv(@QueryParam(value="commit") List<UnresolvedCommitDescriptor> commits, @Parameter(description="The commit type or subtype to include in the response. One of ECommitType or EExternalAnalysisResultType. For regular code commits, the type is 'CODE_COMMIT', which is also the default value.") @QueryParam(value="type") @Nullable String typeOrSubType) throws StorageException {
        AffectedFiles affectedFiles = this.getAffectedFilesForCommits(commits, typeOrSubType);
        return CsvServiceUtils.createCsvResponse((String)("affected-files-" + typeOrSubType), csvListWriter -> AffectedFilesService.createCsvWriter(affectedFiles, csvListWriter));
    }

    private static void createCsvWriter(AffectedFiles affectedFiles, CsvListWriter csvListWriter) throws IOException {
        csvListWriter.writeHeader(new String[]{"Path", "Change Origin", "Change Type"});
        for (ElementChurnWithCommitTypes affectedFile : affectedFiles.affectedFiles) {
            csvListWriter.write(new String[]{affectedFile.getUniformPath(), affectedFile.getChangeEntryOrigin().getHumanReadableName(), affectedFile.getChangeType().displayName});
        }
    }

    public static class ElementChurnWithCommitTypes
    extends TokenElementChurnWithOriginInfo {
        private static final long serialVersionUID = 1L;
        private static final String COMMIT_TYPES_PROPERTY = "commitTypes";
        private static final String SUB_TYPES_PROPERTY = "subTypes";
        @JsonProperty(value="commitTypes")
        private final Set<ECommitType> commitTypes;
        @JsonProperty(value="subTypes")
        private final Set<EExternalAnalysisResultType> subTypes;

        @JsonCreator
        public ElementChurnWithCommitTypes(@JsonProperty(value="commit") CommitDescriptor commit, @JsonProperty(value="latestCommitWithFilePresent") CommitDescriptor latestCommitWithFilePresent, @JsonProperty(value="introductionCommit") CommitDescriptor introductionCommit, @JsonProperty(value="uniformPath") String uniformPath, @JsonProperty(value="changeType") EElementHistoryChangeType changeType, @JsonProperty(value="changeEntryOrigin") EChangeEntryOrigin changeEntryOrigin, @JsonProperty(value="originPath") @Nullable String originPath, @JsonProperty(value="originCommit") @Nullable CommitDescriptor originCommit, @JsonProperty(value="commitTypes") Set<ECommitType> commitTypes, @JsonProperty(value="subTypes") Set<EExternalAnalysisResultType> subTypes) {
            super(commit, latestCommitWithFilePresent, introductionCommit, uniformPath, changeType, changeEntryOrigin, originPath, originCommit);
            this.commitTypes = CollectionUtils.emptyIfNull(commitTypes);
            this.subTypes = CollectionUtils.emptyIfNull(subTypes);
        }

        public ElementChurnWithCommitTypes(TokenElementChurnWithOriginInfo element, Set<ECommitType> commitTypes, Set<EExternalAnalysisResultType> subTypes) {
            this(element.getCommit(), element.getLatestCommitWithFilePresent(), element.getIntroductionCommit(), element.getUniformPath(), element.getChangeType(), element.getChangeEntryOrigin(), element.getOriginPath(), element.getOriginCommit(), commitTypes, subTypes);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)((Object)this)).add("uniformPath", (Object)this.getUniformPath()).add("changeType", (Object)this.getChangeType()).add("commit", (Object)this.getCommit()).add("latestCommitWithFilePresent", (Object)this.getLatestCommitWithFilePresent()).add("introductionCommit", (Object)this.getIntroductionCommit()).add("originPath", (Object)this.getOriginPath()).add("originCommit", (Object)this.getOriginCommit()).add(COMMIT_TYPES_PROPERTY, this.commitTypes).toString();
        }
    }

    public record AffectedFiles(List<ElementChurnWithCommitTypes> affectedFiles, CounterSet<String> typeCounts) {
    }
}

