/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.issues.IssueHistoryIndex;
import com.teamscale.index.issues.IssueIndex;
import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.index.repository.RepositoryCommitIssueMappingIndex;
import com.teamscale.index.utils.IssueUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.wia.TeamscaleIssue;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/projects/{project}/issues/{issueId}/commits")
public class RepositoryCommitsByIssueService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get issue commits", description="Returns the list of commits associated with the issue specified after the slash.", responses={@ApiResponse(responseCode="404", description="No issue with the given ID exists!"), @ApiResponse(responseCode="409", description="Multiple issues with the given ID exist!")}, tags={"Issues"})
    public List<CommitDescriptor> getIssueCommits(@Parameter(description="ID of the issue to retrieve the commits for. The format is the connector ID of the originating issue tracker/requirements management tool (as specified in the connector settings in the project configuration), followed by the separator '|', followed by the ID of the issue, as it is provided by the external issue tracker/requirements management tool. For example, an issue with the ID \"TS-123\" is imported using an issue tracker connector with the connector ID \"issues1\". The expected ID is then \"issues1|TS-123\". For compatibility reasons, using only the issue ID (e.g. \"TS-123\") is also supported but discouraged.") @PathParam(value="issueId") String issueId) throws StorageException {
        IssueIndex issueIndex;
        IssueHistoryIndex issueHistoryIndex = this.openProjectIndex(IssueHistoryIndex.class, null);
        Optional issue = IssueUtils.getSingleIssueHistoryForId((IKeyedObjectIndex)issueHistoryIndex, (IssueIndexBase)(issueIndex = this.openProjectIndex(IssueIndex.class, null)), (String)issueId, (boolean)false);
        if (issue.isEmpty()) {
            throw new NotFoundException("Unknown issue with id '" + issueId + "'.");
        }
        RepositoryCommitIssueMappingIndex commitToIssueMappingIndex = this.openProjectIndex(RepositoryCommitIssueMappingIndex.class, null);
        return CollectionUtils.emptyIfNull((List)commitToIssueMappingIndex.getCommitsForIssue(((TeamscaleIssue)issue.get()).getId()));
    }
}

