/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.requirements_tracing;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.issue_reference.SpecItemCodeReferenceIndex;
import com.teamscale.index.issues.WorkItemHistoryIndexAggregation;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.service.base.SortAndPaginationOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.issues.IssueFilterUtils;
import com.teamscale.service.issues.QueryServiceBase;
import com.teamscale.service.issues.TeamscaleUserAliasResolver;
import com.teamscale.service.requirements_tracing.imported_links_resolution.ImportedSpecItemLinksResolver;
import com.teamscale.service.requirements_tracing.references.ReferenceResolvedSpecItem;
import com.teamscale.service.requirements_tracing.references.SpecItemCodeReferenceResolver;
import com.teamscale.wia.SpecItem;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectIndex;
import org.conqat.engine.persistence.index.keyed.query.autocomplete.AutocompletionResult;
import org.conqat.engine.persistence.index.keyed.query.lexer.EQueryTokenType;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.function.SupplierWithException;

@Path(value="api/projects/{project}/spec-item-query")
public class SpecItemQueryService
extends QueryServiceBase {
    @GET
    @Operation(summary="Perform spec item query", description="Retrieves the size and list of spec items for the query.", responses={@ApiResponse(responseCode="400", content={@Content(mediaType="application/json", schema=@Schema(implementation=QueryServiceBase.QueryParserFailure.class))}, description="Could not process query.")}, tags={"Specification Items"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public QueryServiceBase.IssueQueryResult<ReferenceResolvedSpecItem> performSpecItemQuery(@Parameter(description="Spec item query", required=true, allowEmptyValue=true) @QueryParam(value="query") String query, @BeanParam SortAndPaginationOptions parameters, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor unresolvedCommit) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(unresolvedCommit);
        SpecItemCodeReferenceIndex codeReferenceIndex = this.openProjectIndex(SpecItemCodeReferenceIndex.class, historyAccessOption);
        WorkItemHistoryIndexAggregation specItemHistoryIndexAggregation = WorkItemHistoryIndexAggregation.forSpecItems((ProjectStorageSystem)this.getProjectStorageSystem(), (HistoryAccessOption)historyAccessOption);
        List<String> specItemIds = SpecItemQueryService.performQueryWithErrorHandling(query, specItemHistoryIndexAggregation, historyAccessOption, StoredQueryIndex.EStoredQueryType.SPEC_ITEM, this.serviceInfo);
        List<SpecItem> specItems = specItemHistoryIndexAggregation.getByIds(specItemIds).stream().filter(Objects::nonNull).toList();
        specItems = IssueFilterUtils.applyFiltersAndPagination(specItems, parameters, specItemHistoryIndexAggregation.getDescriber());
        TeamscaleUserAliasResolver userAliasResolver = new TeamscaleUserAliasResolver(UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem()));
        List<ReferenceResolvedSpecItem> referenceResolvedSpecItems = ReferenceResolvedSpecItem.of(specItems, userAliasResolver.resolveIssues(specItems), userAliasResolver.resolveSpecItems(specItems), ImportedSpecItemLinksResolver.resolve(arg_0 -> ((WorkItemHistoryIndexAggregation)specItemHistoryIndexAggregation).getByIssueIds(arg_0), specItems), SpecItemCodeReferenceResolver.resolve(codeReferenceIndex, specItems));
        return QueryServiceBase.IssueQueryResult.of(specItemIds.size(), referenceResolvedSpecItems, parameters.getNextStartIndex());
    }

    @GET
    @Path(value="autocomplete")
    @Operation(summary="Get autocompletion suggestions", description="Retrieves a list of autocompletion suggestions for the given query", tags={"Specification Items"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public AutocompletionResult getSpecItemQueryAutocompletionSuggestions(@Parameter(description="Token to generate autocompletion suggestions for", required=true, allowEmptyValue=true) @QueryParam(value="token") String queryTerm, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor unresolvedCommit) throws StorageException {
        CommitDescriptor resolved = this.resolve(unresolvedCommit);
        return this.getAutocompletionSuggestions((IKeyedObjectIndex<?>)WorkItemHistoryIndexAggregation.forSpecItems((ProjectStorageSystem)this.getProjectStorageSystem(), (CommitDescriptor)resolved), queryTerm, StoredQueryIndex.EStoredQueryType.SPEC_ITEM, this.getAdditionalSuggestionsForSpecItemQueryFunctions(resolved));
    }

    private Map<Pair<EQueryTokenType, Integer>, SupplierWithException<List<String>, ?>> getAdditionalSuggestionsForSpecItemQueryFunctions(CommitDescriptor commit) {
        SupplierWithException issueQueryFunctionFirstParameterSuggestion = SupplierWithException.memoize(() -> StoredQueryIndex.openIndex((ProjectStorageSystem)this.getProjectStorageSystem(), (StoredQueryIndex.EStoredQueryType)StoredQueryIndex.EStoredQueryType.ISSUE).getAllQueryNames());
        SupplierWithException issueQueryFunctionSecondParameterSuggestion = SupplierWithException.memoize(() -> WorkItemHistoryIndexAggregation.forIssues((ProjectStorageSystem)this.getProjectStorageSystem(), (CommitDescriptor)commit).getKnownColumns().getFirstList());
        return Map.ofEntries(Map.entry(new Pair((Object)EQueryTokenType.ISSUE_QUERY, (Object)0), issueQueryFunctionFirstParameterSuggestion), Map.entry(new Pair((Object)EQueryTokenType.ISSUE_QUERY, (Object)1), issueQueryFunctionSecondParameterSuggestion));
    }

    @GET
    @Path(value="validation")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Validate spec item query", description="Decided whether an spec item query is valid", tags={"Specification Items"})
    public boolean isSpecItemQueryValid(@Parameter(description="Spec item query to validate", required=true, allowEmptyValue=true) @QueryParam(value="query") String queryTerm) throws StorageException {
        return this.validateQuery(queryTerm, StoredQueryIndex.EStoredQueryType.SPEC_ITEM);
    }

    @GET
    @Path(value="columns")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get available column names", description="Returns the names of all columns that are available for specification item entities", tags={"Issues"})
    public Map<String, EKeyedObjectType> getKnownSpecItemColumns(@QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor unresolvedCommit) throws StorageException {
        return WorkItemHistoryIndexAggregation.forSpecItems((ProjectStorageSystem)this.getProjectStorageSystem(), (CommitDescriptor)this.resolve(unresolvedCommit)).getKnownColumns().toMap();
    }
}

