/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource;

import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.abap.AbapUtils;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.engine.abap.adt.AdtResourceUrls;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

public class AdtUrlAnnotator {
    private static final int DEFAULT_LINE = 1;
    private static final int DEFAULT_COLUMN = 0;

    public static URI getAdtResourceUrl(TokenElementInfo element, String sapSystemId) throws ConQATException {
        EAbapObjectType sourceObjectType = AdtUrlAnnotator.getSourceObjectType(element);
        return switch (sourceObjectType) {
            case EAbapObjectType.CLAS -> AdtResourceUrls.createClassUrl((String)sapSystemId, (String)AdtUrlAnnotator.getSourceObjectName(element), (int)1, (int)0);
            case EAbapObjectType.INTF -> AdtResourceUrls.createInterfaceUrl((String)sapSystemId, (String)AdtUrlAnnotator.getSourceObjectName(element), (int)1, (int)0);
            case EAbapObjectType.PROG -> AdtUrlAnnotator.createProgramElementUrl(element, sapSystemId);
            case EAbapObjectType.FUGR -> AdtUrlAnnotator.createFunctinGroupElementUrl(element, sapSystemId);
            case EAbapObjectType.ENHO -> AdtResourceUrls.createEnhancementUrl((String)sapSystemId, (String)AdtUrlAnnotator.getSourceObjectName(element));
            case EAbapObjectType.DOMA -> AdtResourceUrls.createDdicDomainUrl((String)sapSystemId, (String)AdtUrlAnnotator.getSourceObjectName(element));
            case EAbapObjectType.DTEL -> AdtResourceUrls.createDdicDataElementUrl((String)sapSystemId, (String)AdtUrlAnnotator.getSourceObjectName(element));
            case EAbapObjectType.STRU -> AdtResourceUrls.createDdicStructureUrl((String)sapSystemId, (String)AdtUrlAnnotator.getSourceObjectName(element));
            case EAbapObjectType.TABL -> AdtResourceUrls.createDdicTableUrl((String)sapSystemId, (String)AdtUrlAnnotator.getSourceObjectName(element));
            case EAbapObjectType.TTYP -> AdtResourceUrls.createDdicTableTypeUrl((String)sapSystemId, (String)AdtUrlAnnotator.getSourceObjectName(element));
            case EAbapObjectType.TYPE -> AdtResourceUrls.createDdicTypeGroupUrl((String)sapSystemId, (String)AdtUrlAnnotator.getSourceObjectName(element));
            case EAbapObjectType.VIEW -> AdtResourceUrls.createDdicViewUrl((String)sapSystemId, (String)AdtUrlAnnotator.getSourceObjectName(element));
            case EAbapObjectType.BDEF -> AdtResourceUrls.createCdsBehaviorDefinitionUrl((String)sapSystemId, (String)AdtUrlAnnotator.getSourceObjectName(element));
            case EAbapObjectType.DCLS -> AdtResourceUrls.createCdsRoleDefinitionEntityUrl((String)sapSystemId, (String)AdtUrlAnnotator.getSourceObjectName(element));
            case EAbapObjectType.DDLS -> AdtResourceUrls.createCdsViewUrl((String)sapSystemId, (String)AdtUrlAnnotator.getSourceObjectName(element));
            case EAbapObjectType.SRVD -> AdtResourceUrls.createCdsServiceDefinitionUrl((String)sapSystemId, (String)AdtUrlAnnotator.getSourceObjectName(element));
            default -> throw new IllegalStateException("Unknown object type: " + String.valueOf(sourceObjectType));
        };
    }

    private static String getSourceObjectName(TokenElementInfo element) throws ConQATException {
        return AbapUtils.buildObjectNameFromUniformPath((String)element.getUniformPath());
    }

    private static URI createProgramElementUrl(TokenElementInfo element, String sapSystemId) throws ConQATException {
        String programName = AdtUrlAnnotator.getSourceObjectName(element);
        if (AdtUrlAnnotator.isExecutableProgram(element)) {
            return AdtResourceUrls.createProgramUrl((String)sapSystemId, (String)programName, (int)1, (int)0);
        }
        return AdtResourceUrls.createProgramIncludeUrl((String)sapSystemId, (String)programName, (int)1, (int)0);
    }

    private static boolean isExecutableProgram(TokenElementInfo element) {
        for (IToken token : element.getTokens()) {
            ETokenType tokenType = token.getType();
            if (tokenType.getTokenClass() != ETokenType.ETokenClass.KEYWORD) continue;
            return tokenType == ETokenType.REPORT || tokenType == ETokenType.PROGRAM;
        }
        return false;
    }

    private static URI createFunctinGroupElementUrl(TokenElementInfo element, String sapSystemId) throws ConQATException {
        String functionGroupName = AdtUrlAnnotator.getFunctionGroupName(element);
        if (StringUtils.isEmpty((String)functionGroupName)) {
            return null;
        }
        String functionModuleName = AdtUrlAnnotator.getFunctionModuleName(element);
        if (StringUtils.isEmpty((String)functionModuleName)) {
            return AdtResourceUrls.createFunctionGroupIncludeUrl((String)sapSystemId, (String)functionGroupName, (String)AdtUrlAnnotator.getSourceObjectName(element), (int)1, (int)0);
        }
        return AdtResourceUrls.createFunctionModuleUrl((String)sapSystemId, (String)functionGroupName, (String)functionModuleName, (int)1, (int)0);
    }

    private static String getFunctionGroupName(TokenElementInfo element) throws ConQATException {
        return AbapUtils.buildFunctionGroupNameFromPath((String)element.getUniformPath());
    }

    private static EAbapObjectType getSourceObjectType(TokenElementInfo element) throws ConQATException {
        return AbapUtils.buildObjectTypeFromUniformPath((String)element.getUniformPath());
    }

    public static String getFunctionModuleName(TokenElementInfo element) {
        UnmodifiableList entities = element.getShallowEntitiesWithoutPreprocessorTokens();
        List functions = ShallowEntityTraversalUtils.selectEntities((Collection)entities, m -> m.getType() == EShallowEntityType.METHOD && m.getSubtype().equals("function"));
        if (!functions.isEmpty()) {
            return ((ShallowEntity)functions.get(0)).getName();
        }
        return null;
    }
}

