/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.findings.calculation.AffectedFileDeltaCalculator;
import com.teamscale.index.findings.calculation.TokenElementChurnWithOriginInfo;
import com.teamscale.index.repository.history.EChangeEntryOrigin;
import com.teamscale.service.base.TimeRange;
import com.teamscale.service.base.TimeRangeResourceServiceBase;
import com.teamscale.service.base.TimeRangeResourceServiceQueryOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/delta/affected-files")
public class TokenElementChurnService
extends TimeRangeResourceServiceBase {
    @GET
    @PublicApi(since=ETeamscaleVersion.VERSION_5_9_10)
    @Operation(summary="Get token element churn", description="Provides a token element churn (i.e., the list of changed elements) for a given uniform path and time range.", tags={"Delta"}, responses={@ApiResponse(responseCode="400", description="Neither start timestamp nor time range provided."), @ApiResponse(responseCode="400", description="Provided end timestamp is smaller than start timestamp.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<TokenElementChurnWithOriginInfo> getDeltaAffectedFiles(@BeanParam TimeRangeResourceServiceQueryOptions timeRangeParameters) throws StorageException {
        TimeRange timeRange = this.createTimeRange(timeRangeParameters);
        CommitDescriptor start = timeRange.start();
        CommitDescriptor end = timeRange.end();
        UniformPath uniformPath = timeRangeParameters.getUniformPath();
        return AffectedFileDeltaCalculator.calculateTokenElementChurnWithOriginInfo((UniformPath)uniformPath, (CommitDescriptor)start, (CommitDescriptor)end, (EChangeEntryOrigin)EChangeEntryOrigin.REPOSITORY_COMMIT, (ProjectStorageSystem)this.getProjectStorageSystem());
    }
}

