/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap.badge;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.testgap.query.IssueTgaParameters;
import com.teamscale.index.testgap.query.TgaCoverageSourceQueryParameters;
import com.teamscale.index.testgap.query.TgaRequestAssessmentQueryOptions;
import com.teamscale.index.testgap.query.TgaRequestQueryOptions;
import com.teamscale.service.framework.authentication.Badge;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.LegacyApi;
import com.teamscale.service.testgap.badge.TgaBadgeService;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;

@Hidden
@LegacyApi
@Path(value="p/{project}/tga-badge.svg")
public class LegacyTgaBadgeService {
    @Context
    private ResourceContext resourceContext;

    @GET
    @Badge
    @Operation(summary="Get test gap badge", description="Calculates the test gap badge for the given path or the given issue ID and returns the value as an SVG badge.")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Produces(value={"*/*"})
    public Response getTestGapBadge(@Parameter(description="Issue ID to create the test badge for. The format is the connector ID of the originating issue tracker/requirements management tool (as specified in the connector settings in the project configuration), followed by the separator '|', followed by the ID of the issue, as it is provided by the external issue tracker/requirements management tool. For example, an issue with the ID \"TS-123\" is imported using an issue tracker connector with the connector ID \"issues1\". The expected ID is then \"issues1|TS-123\". For compatibility reasons, using only the issue ID (e.g. \"TS-123\") is also supported but discouraged.") @QueryParam(value="issueId") String issueId, @Parameter(description="Allows to specify badge format") @QueryParam(value="format") String format, @BeanParam TgaCoverageSourceQueryParameters coverageParameters, @BeanParam IssueTgaParameters issueTgaParameters, @BeanParam TimeIntervalBasedServiceQueryOptions timeIntervalBasedParameters, @BeanParam TgaRequestQueryOptions tgaRequestParameters, @BeanParam TgaRequestAssessmentQueryOptions assessmentOptions) throws StorageException, RepositoryException {
        TgaBadgeService tgaBadgeService = (TgaBadgeService)this.resourceContext.getResource(TgaBadgeService.class);
        tgaRequestParameters.setIssueId(issueId);
        return Response.ok((Object)tgaBadgeService.getTestGapBadge(format, coverageParameters, issueTgaParameters, timeIntervalBasedParameters, tgaRequestParameters, assessmentOptions), (String)"image/svg+xml").build();
    }
}

