/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap.upload;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.testgap.SourceLocation;
import com.teamscale.index.testgap.dotnet.DotNetMethodMappingIndex;
import com.teamscale.index.testgap.dotnet.ProfilerIdFeature;
import com.teamscale.index.testgap.dotnet.traces.DotNetTraceUtils;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.util.BodyPartWrapper;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.testgap.upload.SourceLocationBasedUploadServiceBase;
import com.teamscale.service.testgap.upload.VersionBasedExternalUploadServiceQueryOptions;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.core.stream.IStreamWithException;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CounterSet;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="api/projects/{project}/external-analysis/dotnet-ephemeral-trace")
public class DotNetTraceUploadService
extends SourceLocationBasedUploadServiceBase<ProfilerIdFeature, VersionBasedExternalUploadServiceQueryOptions> {
    private static final String SYSTEM_ASSEMBLY_NAME = "System";
    private static final String SYSTEM_ASSEMBLY_PREFIX = "System.";
    private static final String MSCORLIB_ASSEMBLY_NAME = "mscorlib";

    @POST
    @PublicApi(since=ETeamscaleVersion.VERSION_5_9_0)
    @Operation(summary="Upload .NET profiler coverage", description="Imports coverage information from the .NET profiler (profiles only on the method level).", tags={"External Analysis"}, responses={@ApiResponse(responseCode="400", description="The provided program version is not known to Teamscale."), @ApiResponse(responseCode="400", description="No reports provided via the report multi-part form data parameter")})
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    @Consumes(value={"multipart/form-data"})
    public void uploadDotNetTrace(@Parameter(description="The parameter that contains the program version to which the uploaded coverage belongs.", required=true) @QueryParam(value="version") String version, @Parameter(description="The name of the logical partition to store the results into. All existing data in this partition will be invalidated. A partition typically corresponds to one analysis run, i.e. if there are two independent builds/runs, they must use different partitions.The partition parameter is only required with an auto-create session.", required=true) @QueryParam(value="partition") String partition, @Parameter(description="A message that describes the external analysis, similar to a commit message.") @DefaultValue(value="External analysis data upload") @QueryParam(value="message") String message, @Parameter(required=true, array=@ArraySchema(schema=@Schema(type="string", format="binary"))) @FormDataParam(value="report") List<FormDataBodyPart> reports) throws StorageException, IOException {
        VersionBasedExternalUploadServiceQueryOptions parameters = this.createParameters(version, message, partition);
        this.processVersionBased(parameters, reports);
    }

    @Override
    protected ExternalAnalysisImportInfos doMappingAndCreateImportInfos(HistoryAccessOption historyAccessOption, Set<ProfilerIdFeature> features, VersionBasedExternalUploadServiceQueryOptions parameters, boolean targetsExternalStorage) throws StorageException, BadRequestException {
        DotNetMethodMappingIndex mappingIndex = this.openProjectIndex(DotNetMethodMappingIndex.class, historyAccessOption);
        return DotNetTraceUploadService.createImportInfos(new ArrayList<ProfilerIdFeature>(features), mappingIndex, historyAccessOption.getTimestamp(), targetsExternalStorage);
    }

    private static ExternalAnalysisImportInfos createImportInfos(List<ProfilerIdFeature> features, DotNetMethodMappingIndex mappingIndex, long timestamp, boolean targetsExternalStorage) throws StorageException, BadRequestException {
        List locations = mappingIndex.getSourceLocations(features);
        CounterSet unmappedFeatures = new CounterSet();
        for (int i = 0; i < features.size(); ++i) {
            if (locations.get(i) != null) continue;
            unmappedFeatures.inc((Object)features.get(i).getAssemblyName());
        }
        if (!unmappedFeatures.getKeys().isEmpty()) {
            StringWriter writer = new StringWriter();
            unmappedFeatures.printValueDistribution(new PrintWriter(writer), false);
            LOGGER.warn("Could not find methods in the following assemblies (ordered by number of misses):\n{}", (Object)writer);
        }
        Map<String, List<SourceLocation>> groupedLocations = locations.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(SourceLocation::getUniformPath));
        return new ExternalAnalysisImportInfos((List)IStreamWithException.wrap(groupedLocations.entrySet().stream()).withException(BadRequestException.class).map(entry -> DotNetTraceUploadService.createImportInfo(timestamp, (String)entry.getKey(), (List)entry.getValue(), targetsExternalStorage)).flatMapStream(Collection::stream).collect(Collectors.toList()));
    }

    private static boolean shouldAnalyzeAssembly(String assemblyName) {
        return !assemblyName.equals(MSCORLIB_ASSEMBLY_NAME) && !assemblyName.equals(SYSTEM_ASSEMBLY_NAME) && !assemblyName.startsWith(SYSTEM_ASSEMBLY_PREFIX);
    }

    @Override
    protected Set<ProfilerIdFeature> parseReport(BodyPartWrapper bodyPartWrapper) {
        return DotNetTraceUtils.readExecutedMethods((String)bodyPartWrapper.getBodyPart(), (String)bodyPartWrapper.getFileName(), DotNetTraceUploadService::shouldAnalyzeAssembly);
    }

    @Override
    protected IStore openExternalResultRawStore() throws StorageException {
        return this.openStoreInProject("dot-net-method-mappings", DotNetMethodMappingIndex.class);
    }
}

