/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.upload.base;

import com.teamscale.core.utils.UnresolvedCommitDescriptorUtils;
import com.teamscale.index.report.EReportFormat;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceQueryOptions;
import com.teamscale.service.framework.util.LegacyApiUtils;
import com.teamscale.service.upload.ExternalReportUploadServiceQueryOptions;
import com.teamscale.service.upload.base.ExternalUploadServiceQueryOptions;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;

public final class LegacyExternalReportUploadServiceUtils
extends ApiBase {
    private static final String MISSING_PARAMETER_ERROR = "Missing value for parameter ";
    public static final String MISSING_VERSION_PARAMETER_ERROR = "Missing value for parameter version.";

    public static Map<String, String> mergeParameters(UriInfo uri, FormDataMultiPart multiPart) throws IOException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        uri.getQueryParameters().forEach((key, value) -> parameters.put((String)key, (String)value.get(0)));
        for (BodyPart part : multiPart.getBodyParts()) {
            String existingParam;
            FormDataContentDisposition contentDisposition = (FormDataContentDisposition)part.getContentDisposition();
            String parameterName = contentDisposition.getName();
            if (parameterName.equals("report") || contentDisposition.getSize() > 0x100000L || (existingParam = (String)parameters.get(parameterName)) != null) continue;
            String parameterValue = LegacyExternalReportUploadServiceUtils.readBodyPart(part);
            parameters.put(parameterName, parameterValue);
        }
        return parameters;
    }

    private static ExternalUploadServiceQueryOptions toExternalUploadServiceQueryOptions(Map<String, String> parameters) {
        ExternalUploadServiceQueryOptions options = new ExternalUploadServiceQueryOptions();
        try {
            options.setCommit(UnresolvedCommitDescriptorUtils.parseCommit((String)parameters.get("t")));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException((Throwable)e);
        }
        options.setRevision(parameters.get("revision"));
        options.setRepositoryId(parameters.get("repository"));
        return options;
    }

    private static SessionBasedExternalAnalysisServiceQueryOptions toSessionBasedExternalAnalysisServiceQueryOptions(Map<String, String> parameters) {
        ExternalUploadServiceQueryOptions parentOptions = LegacyExternalReportUploadServiceUtils.toExternalUploadServiceQueryOptions(parameters);
        String uploadMessage = parameters.get("message");
        if (uploadMessage == null) {
            uploadMessage = "External analysis data upload";
        }
        return new SessionBasedExternalAnalysisServiceQueryOptions(parentOptions, uploadMessage, parameters.get("partition"));
    }

    public static ExternalReportUploadServiceQueryOptions toExternalReportUploadServiceQueryOptionsObject(Map<String, String> parameters) {
        SessionBasedExternalAnalysisServiceQueryOptions baseOptions = LegacyExternalReportUploadServiceUtils.toSessionBasedExternalAnalysisServiceQueryOptions(parameters);
        EReportFormat format = (EReportFormat)EnumUtils.valueOfIgnoreCase(EReportFormat.class, (String)parameters.get("format"));
        String pathPrefix = parameters.get("path-prefix");
        return new ExternalReportUploadServiceQueryOptions(baseOptions, format, pathPrefix);
    }

    public static <E extends Throwable> LegacyApiUtils.ExceptionWrapper<NotFoundException, E> notFoundToBadRequestUnlessUnknownSession() {
        return LegacyApiUtils.ExceptionWrapper.wrapRuntimeException(NotFoundException.class, (message, exception) -> {
            if (!message.contains("No session with ID")) {
                return new BadRequestException(message, (Throwable)exception);
            }
            return exception;
        });
    }

    public static <E extends Throwable> LegacyApiUtils.ExceptionWrapper<BadRequestException, E> closedSessionToInternalServerError() {
        return LegacyApiUtils.ExceptionWrapper.wrapRuntimeException(BadRequestException.class, (message, exception) -> {
            if (message.contains("Session") && message.contains("committed or deleted")) {
                return new InternalServerErrorException(message, (Throwable)exception);
            }
            return exception;
        });
    }

    private LegacyExternalReportUploadServiceUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

