/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb.util;

import java.nio.ByteBuffer;
import org.rocksdb.AbstractComparator;
import org.rocksdb.ComparatorOptions;
import org.rocksdb.util.BytewiseComparator;

public final class ReverseBytewiseComparator
extends AbstractComparator {
    public ReverseBytewiseComparator(ComparatorOptions copt) {
        super(copt);
    }

    @Override
    public String name() {
        return "rocksdb.java.ReverseBytewiseComparator";
    }

    @Override
    public int compare(ByteBuffer a, ByteBuffer b) {
        return -BytewiseComparator._compare(a, b);
    }

    @Override
    public void findShortestSeparator(ByteBuffer start, ByteBuffer limit) {
        int limitByte;
        int startByte;
        int diffIndex;
        int minLength = Math.min(start.remaining(), limit.remaining());
        for (diffIndex = 0; diffIndex < minLength && start.get(diffIndex) == limit.get(diffIndex); ++diffIndex) {
        }
        assert (diffIndex <= minLength);
        if (diffIndex != minLength && (startByte = start.get(diffIndex) & 0xFF) > (limitByte = limit.get(diffIndex) & 0xFF) && diffIndex < start.remaining() - 1) {
            start.limit(diffIndex + 1);
            assert (BytewiseComparator._compare(start.duplicate(), limit.duplicate()) > 0);
        }
    }
}

