/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.ControlFlowException;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtilRt;
import org.jetbrains.kotlin.com.intellij.util.JBIterableClassTraverser;
import org.jetbrains.kotlin.com.intellij.util.SmartList;

public final class ReflectionUtil {
    private static final Logger LOG;
    private static final Object unsafe;

    private ReflectionUtil() {
    }

    @NotNull
    public static List<Field> collectFields(@NotNull Class<?> clazz) {
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(14);
        }
        ArrayList<Field> result2 = new ArrayList<Field>();
        for (Class clazz2 : JBIterableClassTraverser.classTraverser(clazz)) {
            Collections.addAll(result2, clazz2.getDeclaredFields());
        }
        ArrayList<Field> arrayList = result2;
        if (arrayList == null) {
            ReflectionUtil.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    public static Field findField(@NotNull Class<?> clazz, @Nullable Class<?> type2, @NotNull @NonNls String name) throws NoSuchFieldException {
        Field result2;
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(16);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(17);
        }
        if ((result2 = ReflectionUtil.findFieldInHierarchy(clazz, field -> name.equals(field.getName()) && (type2 == null || field.getType().equals(type2)))) != null) {
            Field field2 = result2;
            if (field2 == null) {
                ReflectionUtil.$$$reportNull$$$0(18);
            }
            return field2;
        }
        throw new NoSuchFieldException("Class: " + clazz + " name: " + name + " type: " + type2);
    }

    @NotNull
    public static Field findAssignableField(@NotNull Class<?> clazz, @Nullable(value="null means any type") @Nullable(value="null means any type") Class<?> fieldType, @NotNull @NonNls String fieldName) throws NoSuchFieldException {
        Field result2;
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(19);
        }
        if (fieldName == null) {
            ReflectionUtil.$$$reportNull$$$0(20);
        }
        if ((result2 = ReflectionUtil.findFieldInHierarchy(clazz, field -> fieldName.equals(field.getName()) && (fieldType == null || fieldType.isAssignableFrom(field.getType())))) != null) {
            Field field2 = result2;
            if (field2 == null) {
                ReflectionUtil.$$$reportNull$$$0(21);
            }
            return field2;
        }
        throw new NoSuchFieldException("Class: " + clazz + " fieldName: " + fieldName + " fieldType: " + fieldType);
    }

    @Nullable
    public static Field findFieldInHierarchy(@NotNull Class<?> rootClass, @NotNull Predicate<? super Field> checker) {
        if (rootClass == null) {
            ReflectionUtil.$$$reportNull$$$0(22);
        }
        if (checker == null) {
            ReflectionUtil.$$$reportNull$$$0(23);
        }
        for (Class<?> aClass = rootClass; aClass != null; aClass = aClass.getSuperclass()) {
            for (Field field : aClass.getDeclaredFields()) {
                if (!checker.test(field)) continue;
                field.setAccessible(true);
                return field;
            }
        }
        return ReflectionUtil.processInterfaces(rootClass.getInterfaces(), new HashSet(), checker);
    }

    @Nullable
    private static Field processInterfaces(Class<?> @NotNull [] interfaces, @NotNull Set<? super Class<?>> visited2, @NotNull Predicate<? super Field> checker) {
        if (visited2 == null) {
            ReflectionUtil.$$$reportNull$$$0(24);
        }
        if (checker == null) {
            ReflectionUtil.$$$reportNull$$$0(25);
        }
        if (interfaces == null) {
            ReflectionUtil.$$$reportNull$$$0(26);
        }
        for (Class<?> anInterface : interfaces) {
            if (!visited2.add(anInterface)) continue;
            for (Field field : anInterface.getDeclaredFields()) {
                if (!checker.test(field)) continue;
                field.setAccessible(true);
                return field;
            }
            Field field = ReflectionUtil.processInterfaces(anInterface.getInterfaces(), visited2, checker);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    public static void resetField(@NotNull Class<?> clazz, @Nullable(value="null means of any type") @Nullable(value="null means of any type") Class<?> type2, @NotNull @NonNls String name) {
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(27);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(28);
        }
        try {
            ReflectionUtil.resetField(null, ReflectionUtil.findField(clazz, type2, name));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static void resetField(@Nullable Object object, @NotNull Field field) {
        if (field == null) {
            ReflectionUtil.$$$reportNull$$$0(31);
        }
        field.setAccessible(true);
        Class<?> type2 = field.getType();
        try {
            if (type2.isPrimitive()) {
                if (Boolean.TYPE.equals(type2)) {
                    field.set(object, Boolean.FALSE);
                } else if (Integer.TYPE.equals(type2)) {
                    field.set(object, 0);
                } else if (Double.TYPE.equals(type2)) {
                    field.set(object, 0.0);
                } else if (Float.TYPE.equals(type2)) {
                    field.set(object, Float.valueOf(0.0f));
                }
            } else {
                field.set(object, null);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Method makeAccessible(Method method) {
        method.setAccessible(true);
        return method;
    }

    @Nullable
    public static Method getMethod(@NotNull Class<?> aClass, @NonNls @NotNull String name, Class<?> ... parameters2) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(35);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(36);
        }
        if (parameters2 == null) {
            ReflectionUtil.$$$reportNull$$$0(37);
        }
        try {
            return ReflectionUtil.makeAccessible(aClass.getMethod(name, parameters2));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Nullable
    public static Method getDeclaredMethod(@NotNull Class<?> aClass, @NonNls @NotNull String name, Class<?> ... parameters2) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(38);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(39);
        }
        if (parameters2 == null) {
            ReflectionUtil.$$$reportNull$$$0(40);
        }
        try {
            return ReflectionUtil.makeAccessible(aClass.getDeclaredMethod(name, parameters2));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Nullable
    public static Field getDeclaredField(@NotNull Class<?> aClass, @NonNls @NotNull String name) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(41);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(42);
        }
        return ReflectionUtil.findFieldInHierarchy(aClass, field -> name.equals(field.getName()));
    }

    @Nullable
    public static Class<?> getMethodDeclaringClass(@NotNull Class<?> instanceClass, @NonNls @NotNull String methodName, Class<?> ... parameters2) {
        Method method;
        if (instanceClass == null) {
            ReflectionUtil.$$$reportNull$$$0(51);
        }
        if (methodName == null) {
            ReflectionUtil.$$$reportNull$$$0(52);
        }
        if (parameters2 == null) {
            ReflectionUtil.$$$reportNull$$$0(53);
        }
        if ((method = ReflectionUtil.getMethod(instanceClass, methodName, parameters2)) != null) {
            return method.getDeclaringClass();
        }
        while (instanceClass != null) {
            method = ReflectionUtil.getDeclaredMethod(instanceClass, methodName, parameters2);
            if (method != null) {
                return method.getDeclaringClass();
            }
            instanceClass = instanceClass.getSuperclass();
        }
        return null;
    }

    public static <T> T getField(@NotNull Class<?> objectClass, @Nullable Object object, @Nullable(value="null means any type") @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName) {
        if (objectClass == null) {
            ReflectionUtil.$$$reportNull$$$0(54);
        }
        if (fieldName == null) {
            ReflectionUtil.$$$reportNull$$$0(55);
        }
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            return ReflectionUtil.getFieldValue(field, object);
        }
        catch (NoSuchFieldException e) {
            LOG.debug(e);
            return null;
        }
    }

    public static <T> T getStaticFieldValue(@NotNull Class<?> objectClass, @Nullable(value="null means any type") @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName) {
        if (objectClass == null) {
            ReflectionUtil.$$$reportNull$$$0(56);
        }
        if (fieldName == null) {
            ReflectionUtil.$$$reportNull$$$0(57);
        }
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            if (ReflectionUtil.isInstanceField(field)) {
                throw new IllegalArgumentException("Field " + objectClass + "." + fieldName + " is not static");
            }
            return ReflectionUtil.getFieldValue(field, null);
        }
        catch (NoSuchFieldException e) {
            LOG.debug(e);
            return null;
        }
    }

    @Nullable
    public static <T> T getFieldValue(@NotNull Field field, @Nullable Object object) {
        if (field == null) {
            ReflectionUtil.$$$reportNull$$$0(58);
        }
        try {
            return (T)field.get(object);
        }
        catch (IllegalAccessException e) {
            LOG.debug(e);
            return null;
        }
    }

    public static boolean isInstanceField(@NotNull Field field) {
        if (field == null) {
            ReflectionUtil.$$$reportNull$$$0(59);
        }
        return !Modifier.isStatic(field.getModifiers());
    }

    @NotNull
    public static <T> T newInstance(@NotNull Class<T> aClass) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(66);
        }
        return ReflectionUtil.newInstance(aClass, true);
    }

    @NotNull
    public static <T> T newInstance(@NotNull Class<T> aClass, boolean isKotlinDataClassesSupported) {
        T t;
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(67);
        }
        try {
            Constructor<T> constructor = aClass.getDeclaredConstructor(new Class[0]);
            try {
                constructor.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            t = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            T t2;
            Throwable targetException;
            if (e instanceof InvocationTargetException && (targetException = ((InvocationTargetException)e).getTargetException()) instanceof ControlFlowException && targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (isKotlinDataClassesSupported && (t2 = ReflectionUtil.createAsDataClass(aClass)) != null) {
                T t3 = t2;
                if (t3 == null) {
                    ReflectionUtil.$$$reportNull$$$0(69);
                }
                return t3;
            }
            ExceptionUtilRt.rethrowUnchecked(e);
            throw new RuntimeException(e);
        }
        if (t == null) {
            ReflectionUtil.$$$reportNull$$$0(68);
        }
        return t;
    }

    @Nullable
    private static <T> T createAsDataClass(@NotNull Class<T> aClass) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(70);
        }
        for (Annotation annotation2 : aClass.getAnnotations()) {
            String name = annotation2.annotationType().getName();
            if (!name.equals("kotlin.Metadata") && !name.equals("kotlin.jvm.internal.KotlinClass")) continue;
            Constructor<?>[] constructors2 = aClass.getDeclaredConstructors();
            Exception exception = null;
            SmartList defaultCtors = new SmartList();
            for (Constructor<?> constructor : constructors2) {
                try {
                    block15: {
                        Class<?>[] parameterTypes;
                        try {
                            constructor.setAccessible(true);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (constructor.getParameterCount() == 0) {
                            return (T)constructor.newInstance(new Object[0]);
                        }
                        for (Class<?> type2 : parameterTypes = constructor.getParameterTypes()) {
                            if (!type2.getName().equals("kotlin.jvm.internal.DefaultConstructorMarker")) {
                                continue;
                            }
                            break block15;
                        }
                        return (T)constructor.newInstance(new Object[parameterTypes.length]);
                    }
                    defaultCtors.add(constructor);
                }
                catch (Exception e) {
                    exception = e;
                }
            }
            for (Constructor constructor : defaultCtors) {
                try {
                    try {
                        constructor.setAccessible(true);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    exception = e;
                }
            }
            if (exception == null) continue;
            ExceptionUtil.rethrow(exception);
        }
        return null;
    }

    @NotNull
    public static <T> T createInstance(@NotNull Constructor<T> constructor, Object ... args2) {
        T t;
        if (constructor == null) {
            ReflectionUtil.$$$reportNull$$$0(71);
        }
        if (args2 == null) {
            ReflectionUtil.$$$reportNull$$$0(72);
        }
        try {
            t = constructor.newInstance(args2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (t == null) {
            ReflectionUtil.$$$reportNull$$$0(73);
        }
        return t;
    }

    @Deprecated
    @ApiStatus.Internal
    @NotNull
    public static Object getUnsafe() {
        Object object = unsafe;
        if (object == null) {
            ReflectionUtil.$$$reportNull$$$0(95);
        }
        return object;
    }

    public static boolean isAssignable(@NotNull Class<?> ancestor, @NotNull Class<?> descendant) {
        if (ancestor == null) {
            ReflectionUtil.$$$reportNull$$$0(96);
        }
        if (descendant == null) {
            ReflectionUtil.$$$reportNull$$$0(97);
        }
        return ancestor == descendant || ancestor.isAssignableFrom(descendant);
    }

    static {
        Class<?> unsafeClass;
        LOG = Logger.getInstance(ReflectionUtil.class);
        try {
            unsafeClass = Class.forName("sun.misc.Unsafe");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        unsafe = ReflectionUtil.getStaticFieldValue(unsafeClass, unsafeClass, "theUnsafe");
        if (unsafe == null) {
            throw new RuntimeException("Could not find 'theUnsafe' field in the Unsafe class");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 48: 
            case 50: 
            case 65: 
            case 68: 
            case 69: 
            case 73: 
            case 88: 
            case 90: 
            case 91: 
            case 94: 
            case 95: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 48: 
            case 50: 
            case 65: 
            case 68: 
            case 69: 
            case 73: 
            case 88: 
            case 90: 
            case 91: 
            case 94: 
            case 95: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: 
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anInterface";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 48: 
            case 50: 
            case 65: 
            case 68: 
            case 69: 
            case 73: 
            case 88: 
            case 90: 
            case 91: 
            case 94: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil";
                break;
            }
            case 6: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterizedType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericType";
                break;
            }
            case 14: 
            case 16: 
            case 19: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 17: 
            case 28: 
            case 30: 
            case 33: 
            case 36: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: 
            case 55: 
            case 57: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootClass";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaces";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 31: 
            case 58: 
            case 59: 
            case 84: 
            case 85: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 32: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 34: 
            case 37: 
            case 40: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 35: 
            case 38: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceClass";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 54: 
            case 56: 
            case 60: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectClass";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 74: 
            case 77: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 75: 
            case 78: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 76: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerClass";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldType";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descendant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "declarationToString";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualTypeArguments";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFields";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findField";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findAssignableField";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDeclaredFields";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "filterRealMethods";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConstructor";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "newInstance";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstance";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "forName";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "boxType";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getTheOnlyVolatileInstanceFieldOfClass";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsafe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveVariable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "declarationToString";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 48: 
            case 50: 
            case 65: 
            case 68: 
            case 69: 
            case 73: 
            case 88: 
            case 90: 
            case 91: 
            case 94: 
            case 95: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRawType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getActualTypeArguments";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "substituteGenericType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectFields";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findField";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findAssignableField";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findFieldInHierarchy";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processInterfaces";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "resetField";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findMethod";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getMethod";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredMethod";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredField";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getClassPublicMethods";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getClassDeclaredMethods";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getClassDeclaredFields";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "filterRealMethods";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getMethodDeclaringClass";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getField";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getStaticFieldValue";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getFieldValue";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceField";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "setField";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "resolveVariableInHierarchy";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConstructor";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "createAsDataClass";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "copyFields";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "comparePublicNonFinalFields";
                break;
            }
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "copyFieldValue";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "isPublic";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "isFinal";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "forName";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "boxType";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getTheOnlyVolatileInstanceFieldOfClass";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "isAssignable";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "dumpFields";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 48: 
            case 50: 
            case 65: 
            case 68: 
            case 69: 
            case 73: 
            case 88: 
            case 90: 
            case 91: 
            case 94: 
            case 95: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

