/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaStaticClassScope;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DescriptorWithContainerSource;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a0\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u001a\f\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000b\u001a\f\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000e\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\u000b\u00a8\u0006\u0011"}, d2={"copyValueParameters", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "newValueParameterTypes", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "oldValueParameters", "newOwner", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getImplClassNameForDeserialized", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DescriptorWithContainerSource;", "getParentJavaStaticClassScope", "Lorg/jetbrains/kotlin/load/java/lazy/descriptors/LazyJavaStaticClassScope;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isFromJvmPackagePart", "", "descriptors.jvm"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\norg/jetbrains/kotlin/load/java/descriptors/UtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1549#2:69\n1620#2,3:70\n*S KotlinDebug\n*F\n+ 1 util.kt\norg/jetbrains/kotlin/load/java/descriptors/UtilKt\n*L\n40#1:69\n40#1:70,3\n*E\n"})
public final class UtilKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ValueParameterDescriptor> copyValueParameters(@NotNull Collection<? extends KotlinType> newValueParameterTypes, @NotNull Collection<? extends ValueParameterDescriptor> oldValueParameters, @NotNull CallableDescriptor newOwner) {
        void $this$mapTo$iv$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter(newValueParameterTypes, "newValueParameterTypes");
        Intrinsics.checkNotNullParameter(oldValueParameters, "oldValueParameters");
        Intrinsics.checkNotNullParameter(newOwner, "newOwner");
        boolean bl2 = bl = newValueParameterTypes.size() == oldValueParameters.size();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-UtilKt$copyValueParameters$22 = false;
            String $i$a$-assert-UtilKt$copyValueParameters$22 = "Different value parameters sizes: Enhanced = " + newValueParameterTypes.size() + ", Old = " + oldValueParameters.size();
            throw new AssertionError((Object)$i$a$-assert-UtilKt$copyValueParameters$22);
        }
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)newValueParameterTypes, (Iterable)oldValueParameters);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            KotlinType newParameterType = (KotlinType)pair.component1();
            ValueParameterDescriptor oldParameter = (ValueParameterDescriptor)pair.component2();
            int n = oldParameter.getIndex();
            Annotations annotations2 = oldParameter.getAnnotations();
            Name name = oldParameter.getName();
            Intrinsics.checkNotNullExpressionValue(name, "getName(...)");
            boolean bl4 = oldParameter.declaresDefaultValue();
            boolean bl5 = oldParameter.isCrossinline();
            boolean bl6 = oldParameter.isNoinline();
            KotlinType kotlinType = oldParameter.getVarargElementType() != null ? DescriptorUtilsKt.getModule(newOwner).getBuiltIns().getArrayElementType(newParameterType) : null;
            SourceElement sourceElement = oldParameter.getSource();
            Intrinsics.checkNotNullExpressionValue(sourceElement, "getSource(...)");
            collection.add(new ValueParameterDescriptorImpl(newOwner, null, n, annotations2, name, newParameterType, bl4, bl5, bl6, kotlinType, sourceElement));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final LazyJavaStaticClassScope getParentJavaStaticClassScope(@NotNull ClassDescriptor $this$getParentJavaStaticClassScope) {
        Intrinsics.checkNotNullParameter($this$getParentJavaStaticClassScope, "<this>");
        ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getSuperClassNotAny($this$getParentJavaStaticClassScope);
        if (classDescriptor2 == null) {
            return null;
        }
        ClassDescriptor superClassDescriptor = classDescriptor2;
        MemberScope memberScope2 = superClassDescriptor.getStaticScope();
        LazyJavaStaticClassScope lazyJavaStaticClassScope = memberScope2 instanceof LazyJavaStaticClassScope ? (LazyJavaStaticClassScope)memberScope2 : null;
        if (lazyJavaStaticClassScope == null) {
            lazyJavaStaticClassScope = UtilKt.getParentJavaStaticClassScope(superClassDescriptor);
        }
        return lazyJavaStaticClassScope;
    }

    @Nullable
    public static final JvmClassName getImplClassNameForDeserialized(@NotNull DescriptorWithContainerSource $this$getImplClassNameForDeserialized) {
        Intrinsics.checkNotNullParameter($this$getImplClassNameForDeserialized, "<this>");
        DeserializedContainerSource deserializedContainerSource = $this$getImplClassNameForDeserialized.getContainerSource();
        JvmPackagePartSource jvmPackagePartSource = deserializedContainerSource instanceof JvmPackagePartSource ? (JvmPackagePartSource)deserializedContainerSource : null;
        return jvmPackagePartSource != null ? jvmPackagePartSource.getClassName() : null;
    }

    public static final boolean isFromJvmPackagePart(@NotNull DescriptorWithContainerSource $this$isFromJvmPackagePart) {
        Intrinsics.checkNotNullParameter($this$isFromJvmPackagePart, "<this>");
        return $this$isFromJvmPackagePart.getContainerSource() instanceof JvmPackagePartSource;
    }
}

