/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.ast;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.sonarsource.analyzer.commons.regex.RegexSource;
import org.sonarsource.analyzer.commons.regex.ast.AbstractRegexSyntaxElement;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassElementTree;
import org.sonarsource.analyzer.commons.regex.ast.FlagSet;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;
import org.sonarsource.analyzer.commons.regex.ast.RegexToken;
import org.sonarsource.analyzer.commons.regex.ast.RegexVisitor;

public class CharacterClassIntersectionTree
extends AbstractRegexSyntaxElement
implements CharacterClassElementTree {
    private final List<CharacterClassElementTree> characterClasses;
    private final List<RegexToken> andOperators;
    private final FlagSet activeFlags;

    public CharacterClassIntersectionTree(RegexSource source, IndexRange range, List<CharacterClassElementTree> characterClasses, List<RegexToken> andOperators, FlagSet activeFlags) {
        super(source, range);
        this.characterClasses = Collections.unmodifiableList(characterClasses);
        this.andOperators = Collections.unmodifiableList(andOperators);
        this.activeFlags = activeFlags;
    }

    public List<CharacterClassElementTree> getCharacterClasses() {
        return this.characterClasses;
    }

    public List<RegexToken> getAndOperators() {
        return this.andOperators;
    }

    @Override
    public void accept(RegexVisitor visitor2) {
        visitor2.visitCharacterClassIntersection(this);
    }

    @Override
    @Nonnull
    public CharacterClassElementTree.Kind characterClassElementKind() {
        return CharacterClassElementTree.Kind.INTERSECTION;
    }

    @Override
    @Nonnull
    public FlagSet activeFlags() {
        return this.activeFlags;
    }
}

