/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;

@Rule(key="S1067")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/sonarsource/kotlin/checks/TooComplexExpressionCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "()V", "max", "", "getMax", "()I", "setMax", "(I)V", "computeExpressionComplexity", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isParentExpression", "", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitBinaryExpression", "", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "Companion", "sonar-kotlin-checks"})
public final class TooComplexExpressionCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RuleProperty(key="max", description="Maximum number of allowed conditional operators in an expression", defaultValue="3")
    private int max = 3;
    private static final int DEFAULT_MAX_COMPLEXITY = 3;

    public final int getMax() {
        return this.max;
    }

    public final void setMax(int n) {
        this.max = n;
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (!this.isParentExpression(expression2)) {
            return;
        }
        int complexity = this.computeExpressionComplexity(expression2);
        if (complexity > this.max) {
            AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)expression2, "Reduce the number of conditional operators (" + complexity + ") used in the expression (maximum allowed " + this.max + ").", null, (Double)((double)complexity - (double)this.max), 4, null);
        }
    }

    private final boolean isParentExpression(KtBinaryExpression expression2) {
        Iterator<PsiElement> iterator2 = PsiUtilsKt.getParents(expression2).iterator();
        while (iterator2.hasNext()) {
            PsiElement parent2 = iterator2.next();
            if (parent2 instanceof KtBinaryExpression) {
                return false;
            }
            if (parent2 instanceof KtUnaryExpression && parent2 instanceof KtParenthesizedExpression) continue;
            return true;
        }
        return true;
    }

    private final int computeExpressionComplexity(KtExpression expression2) {
        int n;
        KtExpression e = this.skipParentheses(expression2);
        if (e instanceof KtBinaryExpression) {
            KtSingleValueToken operator = ((KtBinaryExpression)e).getOperationReference().getOperationSignTokenType();
            int complexity = Intrinsics.areEqual(operator, KtTokens.OROR) || Intrinsics.areEqual(operator, KtTokens.ANDAND) ? 1 : 0;
            KtExpression ktExpression = ((KtBinaryExpression)e).getLeft();
            Intrinsics.checkNotNull(ktExpression);
            int n2 = complexity + this.computeExpressionComplexity(ktExpression);
            KtExpression ktExpression2 = ((KtBinaryExpression)e).getRight();
            Intrinsics.checkNotNull(ktExpression2);
            n = n2 + this.computeExpressionComplexity(ktExpression2);
        } else if (e instanceof KtUnaryExpression) {
            KtExpression ktExpression = ((KtUnaryExpression)e).getBaseExpression();
            Intrinsics.checkNotNull(ktExpression);
            n = this.computeExpressionComplexity(ktExpression);
        } else {
            n = 0;
        }
        return n;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/sonarsource/kotlin/checks/TooComplexExpressionCheck$Companion;", "", "()V", "DEFAULT_MAX_COMPLEXITY", "", "sonar-kotlin-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

