/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.container.global;

import java.time.Clock;
import org.sonar.api.SonarQubeVersion;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.UriReader;
import org.sonar.api.utils.Version;
import org.sonarsource.sonarlint.core.analysis.api.AnalysisEngineConfiguration;
import org.sonarsource.sonarlint.core.analysis.container.global.AnalysisExtensionInstaller;
import org.sonarsource.sonarlint.core.analysis.container.global.GlobalConfigurationProvider;
import org.sonarsource.sonarlint.core.analysis.container.global.GlobalExtensionContainer;
import org.sonarsource.sonarlint.core.analysis.container.global.GlobalSettings;
import org.sonarsource.sonarlint.core.analysis.container.global.GlobalTempFolderProvider;
import org.sonarsource.sonarlint.core.analysis.container.global.ModuleRegistry;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.plugin.commons.ApiVersions;
import org.sonarsource.sonarlint.core.plugin.commons.LoadedPlugins;
import org.sonarsource.sonarlint.core.plugin.commons.container.SpringComponentContainer;
import org.sonarsource.sonarlint.core.plugin.commons.sonarapi.SonarLintRuntimeImpl;

public class GlobalAnalysisContainer
extends SpringComponentContainer {
    protected static final SonarLintLogger LOG = SonarLintLogger.get();
    private GlobalExtensionContainer globalExtensionContainer;
    private ModuleRegistry moduleRegistry;
    private final AnalysisEngineConfiguration analysisGlobalConfig;
    private final LoadedPlugins loadedPlugins;

    public GlobalAnalysisContainer(AnalysisEngineConfiguration analysisGlobalConfig, LoadedPlugins loadedPlugins) {
        this.analysisGlobalConfig = analysisGlobalConfig;
        this.loadedPlugins = loadedPlugins;
    }

    @Override
    protected void doBeforeStart() {
        Version sonarPluginApiVersion = ApiVersions.loadSonarPluginApiVersion();
        Version sonarlintPluginApiVersion = ApiVersions.loadSonarLintPluginApiVersion();
        this.add(this.analysisGlobalConfig, this.loadedPlugins, GlobalSettings.class, new GlobalConfigurationProvider(), AnalysisExtensionInstaller.class, new SonarQubeVersion(sonarPluginApiVersion), new SonarLintRuntimeImpl(sonarPluginApiVersion, sonarlintPluginApiVersion, this.analysisGlobalConfig.getClientPid()), new GlobalTempFolderProvider(), UriReader.class, Clock.systemDefaultZone(), System2.INSTANCE);
    }

    @Override
    protected void doAfterStart() {
        this.declarePluginProperties();
        this.globalExtensionContainer = new GlobalExtensionContainer(this);
        this.globalExtensionContainer.startComponents();
        this.moduleRegistry = new ModuleRegistry(this.globalExtensionContainer, this.analysisGlobalConfig.getModulesProvider());
    }

    @Override
    public SpringComponentContainer stopComponents() {
        try {
            if (this.moduleRegistry != null) {
                this.moduleRegistry.stopAll();
            }
            if (this.globalExtensionContainer != null) {
                this.globalExtensionContainer.stopComponents();
            }
        }
        catch (Exception e) {
            LOG.error("Cannot close analysis engine", e);
        }
        finally {
            super.stopComponents();
        }
        return this;
    }

    private void declarePluginProperties() {
        this.loadedPlugins.getPluginInstancesByKeys().values().forEach(this::declareProperties);
    }

    public ModuleRegistry getModuleRegistry() {
        return this.moduleRegistry;
    }
}

