/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.commons;

import java.util.Arrays;

public class Version
implements Comparable<Version> {
    private final String name;
    private final String nameWithoutQualifier;
    private final int[] numbers;
    private final String qualifier;

    private Version(String version) {
        this.name = version.trim();
        int qualifierPosition = this.name.indexOf("-");
        if (qualifierPosition != -1) {
            this.qualifier = this.name.substring(qualifierPosition + 1);
            this.nameWithoutQualifier = this.name.substring(0, qualifierPosition);
        } else {
            this.qualifier = "";
            this.nameWithoutQualifier = this.name;
        }
        String[] split = this.nameWithoutQualifier.split("\\.");
        this.numbers = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            this.numbers[i] = Integer.parseInt(split[i]);
        }
    }

    private Version(String name, String nameWithoutQualifier, int[] numbers, String qualifier) {
        this.name = name;
        this.nameWithoutQualifier = nameWithoutQualifier;
        this.numbers = Arrays.copyOf(numbers, numbers.length);
        this.qualifier = qualifier;
    }

    public int getMajor() {
        return this.numbers.length > 0 ? this.numbers[0] : 0;
    }

    public int getMinor() {
        return this.numbers.length > 1 ? this.numbers[1] : 0;
    }

    public int getPatch() {
        return this.numbers.length > 2 ? this.numbers[2] : 0;
    }

    public int getBuild() {
        return this.numbers.length > 3 ? this.numbers[3] : 0;
    }

    public String getName() {
        return this.name;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version other = (Version)o;
        return this.getMajor() == other.getMajor() && this.getMinor() == other.getMinor() && this.getPatch() == other.getPatch() && this.getBuild() == other.getBuild() && this.qualifier.equals(other.qualifier);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.getMajor());
        result = 31 * result + Integer.hashCode(this.getMinor());
        result = 31 * result + Integer.hashCode(this.getPatch());
        result = 31 * result + Integer.hashCode(this.getBuild());
        result = 31 * result + this.qualifier.hashCode();
        return result;
    }

    @Override
    public int compareTo(Version other) {
        int c = this.compareToIgnoreQualifier(other);
        if (c == 0) {
            c = "".equals(this.qualifier) ? ("".equals(other.qualifier) ? 0 : 1) : ("".equals(other.qualifier) ? -1 : this.qualifier.compareTo(other.qualifier));
        }
        return c;
    }

    public int compareToIgnoreQualifier(Version other) {
        int maxNumbers = Math.max(this.numbers.length, other.numbers.length);
        int[] myNumbers = Arrays.copyOf(this.numbers, maxNumbers);
        int[] otherNumbers = Arrays.copyOf(other.numbers, maxNumbers);
        for (int i = 0; i < maxNumbers; ++i) {
            int compare = Integer.compare(myNumbers[i], otherNumbers[i]);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    public String toString() {
        return this.name;
    }

    public static Version create(String version) {
        return new Version(version);
    }

    public Version removeQualifier() {
        return new Version(this.nameWithoutQualifier, this.nameWithoutQualifier, this.numbers, "");
    }

    public boolean satisfiesMinRequirement(Version minRequirement) {
        return this.compareToIgnoreQualifier(minRequirement) >= 0;
    }
}

