/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.commons.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadFactories {
    private ThreadFactories() {
    }

    public static ThreadFactory threadWithNamePrefix(String namePrefix) {
        return new ThreadFactoryWithNamePrefix(namePrefix);
    }

    private static final class ThreadFactoryWithNamePrefix
    implements ThreadFactory {
        private final String namePrefix;
        private final AtomicInteger nextId = new AtomicInteger();

        ThreadFactoryWithNamePrefix(String prefix) {
            this.namePrefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            String name = this.namePrefix + this.nextId.getAndIncrement();
            return new Thread(null, r, name, 0L, false);
        }
    }
}

