/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.embedded.server;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIBuilder;
import org.sonarsource.sonarlint.core.BindingSuggestionProviderImpl;
import org.sonarsource.sonarlint.core.ConfigurationServiceImpl;
import org.sonarsource.sonarlint.core.ServerApiProvider;
import org.sonarsource.sonarlint.core.clientapi.SonarLintClient;
import org.sonarsource.sonarlint.core.clientapi.backend.usertoken.RevokeTokenParams;
import org.sonarsource.sonarlint.core.clientapi.client.issue.ShowIssueParams;
import org.sonarsource.sonarlint.core.clientapi.client.message.MessageType;
import org.sonarsource.sonarlint.core.clientapi.client.message.ShowMessageParams;
import org.sonarsource.sonarlint.core.clientapi.common.FlowDto;
import org.sonarsource.sonarlint.core.clientapi.common.LocationDto;
import org.sonarsource.sonarlint.core.clientapi.common.TextRangeDto;
import org.sonarsource.sonarlint.core.embedded.server.ShowHotspotOrIssueRequestHandler;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationRepository;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationScope;
import org.sonarsource.sonarlint.core.repository.connection.AbstractConnectionConfiguration;
import org.sonarsource.sonarlint.core.repository.connection.ConnectionConfigurationRepository;
import org.sonarsource.sonarlint.core.serverapi.ServerApi;
import org.sonarsource.sonarlint.core.serverapi.issue.IssueApi;
import org.sonarsource.sonarlint.core.serverapi.proto.sonarqube.ws.Common;
import org.sonarsource.sonarlint.core.serverapi.proto.sonarqube.ws.Issues;
import org.sonarsource.sonarlint.core.serverapi.rules.RulesApi;
import org.sonarsource.sonarlint.core.telemetry.TelemetryServiceImpl;
import org.sonarsource.sonarlint.core.usertoken.UserTokenServiceImpl;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.StringUtils;

@Named
@Singleton
public class ShowIssueRequestHandler
extends ShowHotspotOrIssueRequestHandler
implements HttpRequestHandler {
    private final SonarLintClient client;
    private final ConnectionConfigurationRepository connectionConfigurationRepository;
    private final ConfigurationServiceImpl configurationService;
    private final ServerApiProvider serverApiProvider;
    private final TelemetryServiceImpl telemetryService;
    private final ConfigurationRepository configurationRepository;
    private final UserTokenServiceImpl userTokenService;

    public ShowIssueRequestHandler(SonarLintClient client, ConnectionConfigurationRepository connectionConfigurationRepository, ConfigurationServiceImpl configurationService, BindingSuggestionProviderImpl bindingSuggestionProvider, ServerApiProvider serverApiProvider, TelemetryServiceImpl telemetryService, ConfigurationRepository configurationRepository, UserTokenServiceImpl userTokenService) {
        super(bindingSuggestionProvider, client);
        this.client = client;
        this.connectionConfigurationRepository = connectionConfigurationRepository;
        this.configurationService = configurationService;
        this.serverApiProvider = serverApiProvider;
        this.telemetryService = telemetryService;
        this.configurationRepository = configurationRepository;
        this.userTokenService = userTokenService;
    }

    public void handle(ClassicHttpRequest request, ClassicHttpResponse response, HttpContext context) throws HttpException, IOException {
        ShowIssueQuery showIssueQuery = ShowIssueRequestHandler.extractQuery(request);
        if (!Method.GET.isSame(request.getMethod()) || !showIssueQuery.isValid()) {
            response.setCode(400);
            return;
        }
        CompletableFuture.runAsync(() -> this.showIssue(showIssueQuery));
        response.setCode(200);
        response.setEntity((HttpEntity)new StringEntity("OK"));
    }

    private void showIssue(ShowIssueQuery query) {
        this.telemetryService.showIssueRequestReceived();
        List<AbstractConnectionConfiguration> connectionsMatchingOrigin = this.connectionConfigurationRepository.findByUrl(query.serverUrl);
        if (connectionsMatchingOrigin.isEmpty()) {
            this.startFullBindingProcess();
            ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.assistCreatingConnection(query.serverUrl, query.tokenName, query.tokenValue).exceptionally(error -> {
                if (query.tokenName != null && query.tokenValue != null) {
                    this.userTokenService.revokeToken(new RevokeTokenParams(query.serverUrl, query.tokenName, query.tokenValue));
                }
                return null;
            })).thenCompose(response -> this.assistBinding(response.getConfigScopeIds(), response.getNewConnectionId(), query.projectKey))).thenAccept(response -> {
                if (response.getConfigurationScopeId() != null) {
                    this.showIssueForScope(response.getConnectionId(), response.getConfigurationScopeId(), query.issueKey, query.projectKey, query.branch, query.pullRequest);
                }
            })).whenComplete((v, e) -> this.endFullBindingProcess());
        } else {
            Set<String> configScopeIds = this.configurationRepository.getConfigScopeIds();
            this.showIssueForConnection(configScopeIds, connectionsMatchingOrigin.get(0).getConnectionId(), query.projectKey, query.issueKey, query.branch, query.pullRequest);
        }
    }

    private void showIssueForConnection(Set<String> configScopeIds, String connectionId, String projectKey, String issueKey, String branch, @Nullable String pullRequest) {
        List<ConfigurationScope> scopes = this.configurationService.getConfigScopesWithBindingConfiguredTo(connectionId, projectKey);
        if (scopes.isEmpty()) {
            this.assistBinding(configScopeIds, connectionId, projectKey).thenAccept(newBinding -> {
                if (newBinding.getConfigurationScopeId() != null) {
                    this.showIssueForScope(connectionId, newBinding.getConfigurationScopeId(), issueKey, projectKey, branch, pullRequest);
                }
            });
        } else {
            this.showIssueForScope(connectionId, scopes.get(0).getId(), issueKey, projectKey, branch, pullRequest);
        }
    }

    private void showIssueForScope(String connectionId, String configScopeId, String issueKey, String projectKey, String branch, @Nullable String pullRequest) {
        this.tryFetchIssue(connectionId, issueKey, projectKey, branch, pullRequest).ifPresentOrElse(issueDetails -> this.client.showIssue(this.getShowIssueParams((IssueApi.ServerIssueDetails)issueDetails, connectionId, configScopeId, branch, pullRequest)), () -> this.client.showMessage(new ShowMessageParams(MessageType.ERROR, "Could not show the issue. See logs for more details")));
    }

    @VisibleForTesting
    ShowIssueParams getShowIssueParams(IssueApi.ServerIssueDetails issueDetails, String connectionId, String configScopeId, String branch, @Nullable String pullRequest) {
        List<FlowDto> flowLocations = issueDetails.flowList.stream().map(flow -> {
            List<LocationDto> locations = flow.getLocationsList().stream().map(location -> {
                Optional<Issues.Component> locationComponent = issueDetails.componentsList.stream().filter(component -> component.getKey().equals(location.getComponent())).findFirst();
                String filePath = locationComponent.map(Issues.Component::getPath).orElse("");
                Common.TextRange locationTextRange = location.getTextRange();
                Optional<String> codeSnippet = this.tryFetchCodeSnippet(connectionId, locationComponent.map(Issues.Component::getKey).orElse(""), locationTextRange, branch, pullRequest);
                TextRangeDto locationTextRangeDto = new TextRangeDto(locationTextRange.getStartLine(), locationTextRange.getStartOffset(), locationTextRange.getEndLine(), locationTextRange.getEndOffset());
                return new LocationDto(locationTextRangeDto, location.getMsg(), filePath, codeSnippet.orElse(""));
            }).collect(Collectors.toList());
            return new FlowDto(locations);
        }).collect(Collectors.toList());
        Common.TextRange textRange = issueDetails.textRange;
        TextRangeDto textRangeDto = new TextRangeDto(textRange.getStartLine(), textRange.getStartOffset(), textRange.getEndLine(), textRange.getEndOffset());
        boolean isTaint = ShowIssueRequestHandler.isIssueTaint(issueDetails.ruleKey);
        return new ShowIssueParams(textRangeDto, configScopeId, issueDetails.ruleKey, issueDetails.key, issueDetails.path, branch, pullRequest, issueDetails.message, issueDetails.creationDate, issueDetails.codeSnippet, isTaint, flowLocations);
    }

    static boolean isIssueTaint(String ruleKey) {
        return RulesApi.TAINT_REPOS.stream().anyMatch(ruleKey::startsWith);
    }

    private Optional<IssueApi.ServerIssueDetails> tryFetchIssue(String connectionId, String issueKey, String projectKey, String branch, String pullRequest) {
        Optional<ServerApi> serverApi = this.serverApiProvider.getServerApi(connectionId);
        if (serverApi.isEmpty()) {
            return Optional.empty();
        }
        return serverApi.get().issue().fetchServerIssue(issueKey, projectKey, branch, pullRequest);
    }

    private Optional<String> tryFetchCodeSnippet(String connectionId, String fileKey, Common.TextRange textRange, String branch, String pullRequest) {
        Optional<ServerApi> serverApi = this.serverApiProvider.getServerApi(connectionId);
        if (serverApi.isEmpty() || fileKey.isEmpty()) {
            return Optional.empty();
        }
        return serverApi.get().issue().getCodeSnippet(fileKey, textRange, branch, pullRequest);
    }

    @VisibleForTesting
    static ShowIssueQuery extractQuery(ClassicHttpRequest request) {
        HashMap params = new HashMap();
        try {
            new URIBuilder(request.getUri(), StandardCharsets.UTF_8).getQueryParams().forEach(p -> params.put(p.getName(), p.getValue()));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return new ShowIssueQuery((String)params.get("server"), (String)params.get("project"), (String)params.get("issue"), (String)params.get("branch"), (String)params.get("pullRequest"), (String)params.get("tokenName"), (String)params.get("tokenValue"));
    }

    @VisibleForTesting
    public static class ShowIssueQuery {
        private final String serverUrl;
        private final String projectKey;
        private final String issueKey;
        private final String branch;
        @Nullable
        private final String pullRequest;
        @Nullable
        private final String tokenName;
        @Nullable
        private final String tokenValue;

        public ShowIssueQuery(String serverUrl, String projectKey, String issueKey, String branch, @Nullable String pullRequest, @Nullable String tokenName, @Nullable String tokenValue) {
            this.serverUrl = serverUrl;
            this.projectKey = projectKey;
            this.issueKey = issueKey;
            this.branch = branch;
            this.pullRequest = pullRequest;
            this.tokenName = tokenName;
            this.tokenValue = tokenValue;
        }

        public boolean isValid() {
            return StringUtils.isNotBlank(this.serverUrl) && StringUtils.isNotBlank(this.projectKey) && StringUtils.isNotBlank(this.issueKey) && StringUtils.isNotBlank(this.branch) && this.isPullRequestParamValid() && this.isTokenValid();
        }

        public boolean isPullRequestParamValid() {
            if (this.pullRequest != null) {
                return StringUtils.isNotEmpty(this.pullRequest);
            }
            return true;
        }

        public boolean isTokenValid() {
            if (this.tokenName != null && this.tokenValue != null) {
                return StringUtils.isNotEmpty(this.tokenName) && StringUtils.isNotEmpty(this.tokenValue);
            }
            return this.tokenName == null && this.tokenValue == null;
        }

        public String getServerUrl() {
            return this.serverUrl;
        }

        public String getProjectKey() {
            return this.projectKey;
        }

        public String getIssueKey() {
            return this.issueKey;
        }

        public String getBranch() {
            return this.branch;
        }

        @Nullable
        public String getPullRequest() {
            return this.pullRequest;
        }

        @Nullable
        public String getTokenName() {
            return this.tokenName;
        }

        @Nullable
        public String getTokenValue() {
            return this.tokenValue;
        }
    }
}

