/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.issuetracking;

import java.util.Collection;
import java.util.Collections;
import org.sonarsource.sonarlint.core.issuetracking.IssueTracker;
import org.sonarsource.sonarlint.core.issuetracking.IssueTrackerCache;
import org.sonarsource.sonarlint.core.issuetracking.Trackable;

public class CachingIssueTracker
extends IssueTracker {
    private final IssueTrackerCache cache;

    public CachingIssueTracker(IssueTrackerCache cache) {
        this.cache = cache;
    }

    public synchronized Collection<Trackable> matchAndTrackAsNew(String file, Collection<Trackable> trackables) {
        Collection<Trackable> tracked = this.cache.isFirstAnalysis(file) ? trackables : this.apply(this.cache.getCurrentTrackables(file), trackables, false);
        this.cache.put(file, tracked);
        return tracked;
    }

    public synchronized Collection<Trackable> matchAndTrackAsBase(String file, Collection<Trackable> trackables) {
        Collection<Trackable> current = this.cache.getLiveOrFail(file);
        if (current.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<Trackable> tracked = this.apply(trackables, current, true);
        this.cache.put(file, tracked);
        return tracked;
    }

    public void clear() {
        this.cache.clear();
    }

    public void shutdown() {
        this.cache.shutdown();
    }
}

