/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.repository.connection;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.sonarsource.sonarlint.core.commons.ConnectionKind;
import org.sonarsource.sonarlint.core.serverapi.EndpointParams;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang.StringUtils;

public abstract class AbstractConnectionConfiguration {
    private final String connectionId;
    private final boolean disableNotifications;
    private final ConnectionKind kind;
    private final String url;

    protected AbstractConnectionConfiguration(String connectionId, ConnectionKind kind, boolean disableNotifications, String url) {
        Objects.requireNonNull(connectionId, "Connection id is mandatory");
        this.connectionId = connectionId;
        this.kind = kind;
        this.disableNotifications = disableNotifications;
        this.url = url;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public ConnectionKind getKind() {
        return this.kind;
    }

    public boolean isDisableNotifications() {
        return this.disableNotifications;
    }

    public String getUrl() {
        return this.url;
    }

    public abstract EndpointParams getEndpointParams();

    public boolean isSameServerUrl(String otherUrl) {
        URI otherUri;
        URI myUri;
        try {
            myUri = new URI(StringUtils.removeEnd(this.url, "/"));
            otherUri = new URI(StringUtils.removeEnd(otherUrl, "/"));
        }
        catch (URISyntaxException e) {
            return false;
        }
        return Objects.equals(myUri, otherUri);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractConnectionConfiguration that = (AbstractConnectionConfiguration)o;
        return Objects.equals(this.connectionId, that.connectionId) && Objects.equals(this.disableNotifications, that.disableNotifications) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.connectionId, this.url);
    }
}

