/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.tracking;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.client.api.common.analysis.Issue;
import org.sonarsource.sonarlint.core.commons.HotspotReviewStatus;
import org.sonarsource.sonarlint.core.commons.IssueSeverity;
import org.sonarsource.sonarlint.core.commons.RuleType;
import org.sonarsource.sonarlint.core.commons.TextRange;
import org.sonarsource.sonarlint.core.commons.TextRangeWithHash;
import org.sonarsource.sonarlint.core.issuetracking.Trackable;
import org.sonarsource.sonarlint.core.tracking.DigestUtils;

public class IssueTrackable
implements Trackable<Issue> {
    private final Issue issue;
    private final TextRangeWithHash textRange;
    private final String lineHash;

    public IssueTrackable(Issue issue) {
        this(issue, null, null);
    }

    public IssueTrackable(Issue issue, @Nullable String textRangeContent, @Nullable String lineContent) {
        this.issue = issue;
        TextRange fromAnalysis = issue.getTextRange();
        this.textRange = fromAnalysis != null ? IssueTrackable.convertToTrackingTextRange(fromAnalysis, IssueTrackable.hashOrNull(textRangeContent)) : null;
        this.lineHash = IssueTrackable.hashOrNull(lineContent);
    }

    private static TextRangeWithHash convertToTrackingTextRange(TextRange fromAnalysis, @Nullable String hash) {
        return new TextRangeWithHash(fromAnalysis.getStartLine(), fromAnalysis.getStartLineOffset(), fromAnalysis.getEndLine(), fromAnalysis.getEndLineOffset(), hash != null ? hash : "");
    }

    @CheckForNull
    private static String hashOrNull(@Nullable String content) {
        return content != null ? DigestUtils.digest(content) : null;
    }

    @Override
    public Issue getClientObject() {
        return this.issue;
    }

    @Override
    public String getRuleKey() {
        return this.issue.getRuleKey();
    }

    @Override
    public IssueSeverity getSeverity() {
        return this.issue.getSeverity();
    }

    @Override
    public RuleType getType() {
        return this.issue.getType();
    }

    @Override
    public String getMessage() {
        return this.issue.getMessage();
    }

    @Override
    public Integer getLine() {
        return this.issue.getStartLine();
    }

    @Override
    public String getLineHash() {
        return this.lineHash;
    }

    @Override
    public TextRangeWithHash getTextRange() {
        return this.textRange;
    }

    @Override
    public Long getCreationDate() {
        return null;
    }

    @Override
    public String getServerIssueKey() {
        return null;
    }

    @Override
    public boolean isResolved() {
        return false;
    }

    @Override
    public HotspotReviewStatus getReviewStatus() {
        return null;
    }
}

