/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.api;

import com.sonar.sslr.api.AstNodeSkippingPolicy;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.matcher.RuleDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.sslr.ast.AstSelect;
import org.sonar.sslr.internal.ast.select.AstSelectFactory;
import org.sonar.sslr.internal.grammar.MutableParsingRule;

public class AstNode {
    protected AstNodeType type;
    private final String name;
    private final Token token;
    private List<AstNode> children = Collections.emptyList();
    private int childIndex = -1;
    private AstNode parent;
    private int fromIndex;
    private int toIndex;

    public AstNode(Token token) {
        this(token.getType(), token.getType().getName(), token);
    }

    public AstNode(AstNodeType type, String name, @Nullable Token token) {
        this.type = type;
        this.token = token;
        this.name = name;
    }

    public AstNode getParent() {
        return this.parent;
    }

    public void addChild(AstNode child) {
        if (child != null) {
            if (this.children.isEmpty()) {
                this.children = new ArrayList<AstNode>();
            }
            if (child.hasToBeSkippedFromAst()) {
                if (child.hasChildren()) {
                    for (AstNode subChild : child.children) {
                        this.addChildToList(subChild);
                    }
                }
            } else {
                this.addChildToList(child);
            }
        }
    }

    private void addChildToList(AstNode child) {
        this.children.add(child);
        child.childIndex = this.children.size() - 1;
        child.parent = this;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public List<AstNode> getChildren() {
        return this.children;
    }

    public int getNumberOfChildren() {
        return this.children.size();
    }

    @Deprecated
    public AstNode getChild(int index) {
        if (index >= this.getNumberOfChildren()) {
            throw new IllegalStateException("The AstNode '" + this + "' has only " + this.getNumberOfChildren() + " children. Requested child index is wrong : " + index);
        }
        return this.children.get(index);
    }

    @Deprecated
    public AstNode nextAstNode() {
        return this.getNextAstNode();
    }

    public AstNode getNextAstNode() {
        AstNode nextSibling = this.getNextSibling();
        if (nextSibling != null) {
            return nextSibling;
        }
        if (this.parent != null) {
            return this.parent.getNextAstNode();
        }
        return null;
    }

    @Deprecated
    public AstNode previousAstNode() {
        return this.getPreviousAstNode();
    }

    public AstNode getPreviousAstNode() {
        AstNode previousSibling = this.getPreviousSibling();
        if (previousSibling != null) {
            return previousSibling;
        }
        if (this.parent != null) {
            return this.parent.getPreviousAstNode();
        }
        return null;
    }

    @Deprecated
    public AstNode nextSibling() {
        return this.getNextSibling();
    }

    public AstNode getNextSibling() {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.getNumberOfChildren() > this.childIndex + 1) {
            return this.parent.children.get(this.childIndex + 1);
        }
        return null;
    }

    @Deprecated
    public AstNode previousSibling() {
        return this.getPreviousSibling();
    }

    public AstNode getPreviousSibling() {
        if (this.parent == null) {
            return null;
        }
        if (this.childIndex > 0) {
            return this.parent.children.get(this.childIndex - 1);
        }
        return null;
    }

    public String getTokenValue() {
        if (this.token == null) {
            return null;
        }
        return this.token.getValue();
    }

    public String getTokenOriginalValue() {
        if (this.token == null) {
            return null;
        }
        return this.token.getOriginalValue();
    }

    public Token getToken() {
        return this.token;
    }

    public int getTokenLine() {
        return this.token.getLine();
    }

    public boolean hasToken() {
        return this.token != null;
    }

    public String getName() {
        return this.name;
    }

    public int getFromIndex() {
        return this.fromIndex;
    }

    public void setFromIndex(int fromIndex) {
        this.fromIndex = fromIndex;
    }

    public int getToIndex() {
        return this.toIndex;
    }

    public boolean hasToBeSkippedFromAst() {
        if (this.type == null) {
            return true;
        }
        boolean result = AstNodeSkippingPolicy.class.isAssignableFrom(this.type.getClass()) ? ((AstNodeSkippingPolicy)this.type).hasToBeSkippedFromAst(this) : false;
        if (this.type instanceof MutableParsingRule) {
            this.type = ((MutableParsingRule)this.type).getRealAstNodeType();
        } else if (this.type instanceof RuleDefinition) {
            this.type = ((RuleDefinition)this.type).getRealAstNodeType();
        }
        return result;
    }

    public void setToIndex(int toIndex) {
        this.toIndex = toIndex;
    }

    public boolean is(AstNodeType ... types) {
        for (AstNodeType expectedType : types) {
            if (this.type != expectedType) continue;
            return true;
        }
        return false;
    }

    public boolean isNot(AstNodeType ... types) {
        return !this.is(types);
    }

    @Deprecated
    public AstNode findFirstDirectChild(AstNodeType ... nodeTypes) {
        return this.getFirstChild(nodeTypes);
    }

    public AstNode getFirstChild(AstNodeType ... nodeTypes) {
        for (AstNode child : this.children) {
            for (AstNodeType nodeType : nodeTypes) {
                if (child.type != nodeType) continue;
                return child;
            }
        }
        return null;
    }

    @Deprecated
    public AstNode findFirstChild(AstNodeType ... nodeTypes) {
        return this.getFirstDescendant(nodeTypes);
    }

    public AstNode getFirstDescendant(AstNodeType ... nodeTypes) {
        for (AstNode child : this.children) {
            if (child.is(nodeTypes)) {
                return child;
            }
            AstNode node = child.getFirstDescendant(nodeTypes);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public AstNode getFirstChild() {
        return this.children.isEmpty() ? null : this.children.get(0);
    }

    @Deprecated
    public List<AstNode> findDirectChildren(AstNodeType ... nodeTypes) {
        return this.getChildren(nodeTypes);
    }

    public List<AstNode> getChildren(AstNodeType ... nodeTypes) {
        ArrayList<AstNode> result = new ArrayList<AstNode>();
        for (AstNode child : this.children) {
            for (AstNodeType nodeType : nodeTypes) {
                if (child.type != nodeType) continue;
                result.add(child);
            }
        }
        return result;
    }

    @Deprecated
    public List<AstNode> findChildren(AstNodeType ... nodeTypes) {
        ArrayList<AstNode> result = new ArrayList<AstNode>();
        this.getDescendants(result, nodeTypes);
        return result;
    }

    public List<AstNode> getDescendants(AstNodeType ... nodeTypes) {
        ArrayList<AstNode> result = new ArrayList<AstNode>();
        if (this.hasChildren()) {
            for (AstNode child : this.children) {
                child.getDescendants(result, nodeTypes);
            }
        }
        return result;
    }

    private void getDescendants(List<AstNode> result, AstNodeType ... nodeTypes) {
        for (AstNodeType nodeType : nodeTypes) {
            if (!this.is(nodeType)) continue;
            result.add(this);
        }
        if (this.hasChildren()) {
            for (AstNode child : this.children) {
                child.getDescendants(result, nodeTypes);
            }
        }
    }

    public AstNode getLastChild() {
        return this.children.isEmpty() ? null : this.children.get(this.children.size() - 1);
    }

    @Nullable
    public AstNode getLastChild(AstNodeType ... nodeTypes) {
        for (int i = this.children.size() - 1; i >= 0; --i) {
            AstNode child = this.children.get(i);
            for (AstNodeType nodeType : nodeTypes) {
                if (child.type != nodeType) continue;
                return child;
            }
        }
        return null;
    }

    public boolean hasDirectChildren(AstNodeType ... nodeTypes) {
        return this.getFirstChild(nodeTypes) != null;
    }

    @Deprecated
    public boolean hasChildren(AstNodeType ... nodeTypes) {
        return this.hasDescendant(nodeTypes);
    }

    public boolean hasDescendant(AstNodeType ... nodeTypes) {
        return this.getFirstDescendant(nodeTypes) != null;
    }

    @Deprecated
    public boolean hasParents(AstNodeType nodeType) {
        return this.hasAncestor(nodeType);
    }

    public boolean hasParent(AstNodeType ... nodeTypes) {
        return this.parent != null && this.parent.is(nodeTypes);
    }

    public boolean hasAncestor(AstNodeType nodeType) {
        return this.getFirstAncestor(nodeType) != null;
    }

    public boolean hasAncestor(AstNodeType ... nodeTypes) {
        return this.getFirstAncestor(nodeTypes) != null;
    }

    @Deprecated
    public AstNode findFirstParent(AstNodeType nodeType) {
        return this.getFirstAncestor(nodeType);
    }

    public AstNode getFirstAncestor(AstNodeType nodeType) {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.is(nodeType)) {
            return this.parent;
        }
        return this.parent.getFirstAncestor(nodeType);
    }

    public AstNode getFirstAncestor(AstNodeType ... nodeTypes) {
        AstNode result = this.parent;
        while (result != null) {
            if (result.is(nodeTypes)) {
                return result;
            }
            result = result.parent;
        }
        return null;
    }

    public boolean isCopyBookOrGeneratedNode() {
        return this.getToken().isCopyBook() || this.getToken().isGeneratedCode();
    }

    public AstNodeType getType() {
        return this.type;
    }

    public List<Token> getTokens() {
        ArrayList<Token> tokens = new ArrayList<Token>();
        this.getTokens(tokens);
        return tokens;
    }

    private void getTokens(List<Token> tokens) {
        if (!this.hasChildren()) {
            if (this.token != null) {
                tokens.add(this.token);
            }
        } else {
            for (int i = 0; i < this.children.size(); ++i) {
                this.children.get(i).getTokens(tokens);
            }
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.name);
        if (this.token != null) {
            result.append(" tokenValue='").append(this.token.getValue()).append("'");
            result.append(" tokenLine=").append(this.token.getLine());
            result.append(" tokenColumn=").append(this.token.getColumn());
        }
        return result.toString();
    }

    public Token getLastToken() {
        if (!this.hasToken()) {
            return null;
        }
        AstNode currentNode = this;
        block0: while (currentNode.hasChildren()) {
            for (int i = currentNode.children.size() - 1; i >= 0; --i) {
                AstNode child = currentNode.children.get(i);
                if (!child.hasToken()) continue;
                currentNode = child;
                continue block0;
            }
        }
        return currentNode.getToken();
    }

    @Deprecated
    public AstSelect select() {
        return AstSelectFactory.select(this);
    }
}

