/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.utils.SyntacticEquivalence;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.php.api.tree.statement.ForStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2251")
public class ForLoopIncrementSignCheck
extends PHPVisitorCheck {
    @Override
    public void visitForStatement(ForStatementTree tree) {
        List<ExpressionTree> updates = tree.update().stream().filter(expression -> ForLoopIncrementSignCheck.updateKind(expression) != UpdateKind.UNKNOWN).toList();
        ExpressionTree forCondition = CheckUtils.getForCondition(tree);
        if (forCondition != null && !updates.isEmpty()) {
            this.checkCondition(forCondition, updates);
        }
        super.visitForStatement(tree);
    }

    private void checkCondition(ExpressionTree tree, List<ExpressionTree> updates) {
        ExpressionTree condition = CheckUtils.skipParenthesis(tree);
        if (condition.is(Tree.Kind.CONDITIONAL_OR)) {
            BinaryExpressionTree conditionalOr = (BinaryExpressionTree)condition;
            this.checkCondition(conditionalOr.leftOperand(), updates);
            this.checkCondition(conditionalOr.rightOperand(), updates);
        } else if (condition.is(Tree.Kind.LESS_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO, Tree.Kind.GREATER_THAN, Tree.Kind.GREATER_THAN_OR_EQUAL_TO)) {
            BinaryExpressionTree comparison = (BinaryExpressionTree)condition;
            boolean isLessThan = condition.is(Tree.Kind.LESS_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO);
            updates.stream().filter(update -> ForLoopIncrementSignCheck.updateKind(update) == UpdateKind.PLUS).forEach(update -> this.checkOperand((ExpressionTree)update, comparison, isLessThan ? comparison.rightOperand() : comparison.leftOperand()));
            updates.stream().filter(update -> ForLoopIncrementSignCheck.updateKind(update) == UpdateKind.MINUS).forEach(update -> this.checkOperand((ExpressionTree)update, comparison, isLessThan ? comparison.leftOperand() : comparison.rightOperand()));
        }
    }

    private void checkOperand(ExpressionTree update, BinaryExpressionTree binaryExpression, ExpressionTree operandToCheck) {
        ExpressionTree operand = CheckUtils.skipParenthesis(operandToCheck);
        if (SyntacticEquivalence.areSyntacticallyEquivalent(ForLoopIncrementSignCheck.variable(update), operand)) {
            String type = ForLoopIncrementSignCheck.updateKind(update) == UpdateKind.PLUS ? "incremented" : "decremented";
            this.context().newIssue(this, update, "\"" + operand.toString() + "\" is " + type + " and will never reach \"stop condition\".").secondary(binaryExpression, "Stop condition");
        }
    }

    private static ExpressionTree variable(ExpressionTree expression) {
        if (expression.is(Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT)) {
            return ((AssignmentExpressionTree)expression).variable();
        }
        return ((UnaryExpressionTree)expression).expression();
    }

    private static UpdateKind updateKind(ExpressionTree expression) {
        if (expression.is(Tree.Kind.PREFIX_INCREMENT, Tree.Kind.POSTFIX_INCREMENT)) {
            return UpdateKind.PLUS;
        }
        if (expression.is(Tree.Kind.PREFIX_DECREMENT, Tree.Kind.POSTFIX_DECREMENT)) {
            return UpdateKind.MINUS;
        }
        if (expression.is(Tree.Kind.PLUS_ASSIGNMENT)) {
            return ForLoopIncrementSignCheck.valueKind(((AssignmentExpressionTree)expression).value());
        }
        if (expression.is(Tree.Kind.MINUS_ASSIGNMENT)) {
            return ForLoopIncrementSignCheck.minus(ForLoopIncrementSignCheck.valueKind(((AssignmentExpressionTree)expression).value()));
        }
        return UpdateKind.UNKNOWN;
    }

    private static UpdateKind valueKind(ExpressionTree value) {
        if (value.is(Tree.Kind.NUMERIC_LITERAL)) {
            return UpdateKind.PLUS;
        }
        if (value.is(Tree.Kind.UNARY_MINUS)) {
            return ForLoopIncrementSignCheck.minus(ForLoopIncrementSignCheck.valueKind(((UnaryExpressionTree)value).expression()));
        }
        if (value.is(Tree.Kind.UNARY_PLUS)) {
            return ForLoopIncrementSignCheck.valueKind(((UnaryExpressionTree)value).expression());
        }
        return UpdateKind.UNKNOWN;
    }

    private static UpdateKind minus(UpdateKind kind) {
        if (kind == UpdateKind.PLUS) {
            return UpdateKind.MINUS;
        }
        if (kind == UpdateKind.MINUS) {
            return UpdateKind.PLUS;
        }
        return UpdateKind.UNKNOWN;
    }

    private static enum UpdateKind {
        PLUS,
        MINUS,
        UNKNOWN;

    }
}

