/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.metrics;

import java.util.HashSet;
import java.util.Set;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

public class LineVisitor
extends PHPVisitorCheck {
    private Set<Integer> lines = new HashSet<Integer>();

    private LineVisitor(Tree tree) {
        tree.accept(this);
    }

    public LineVisitor(CompilationUnitTree tree) {
        this.visitCompilationUnit(tree);
    }

    public static int linesOfCode(Tree tree) {
        return new LineVisitor(tree).getLinesOfCodeNumber();
    }

    @Override
    public void visitScript(ScriptTree tree) {
        this.scan(tree.statements());
    }

    @Override
    public void visitToken(SyntaxToken token) {
        boolean isEOF = ((InternalSyntaxToken)token).isEOF();
        if (token.is(Tree.Kind.TOKEN) && !isEOF) {
            String[] tokenLines = token.text().split("\n", -1);
            for (int i = token.line(); i < token.line() + tokenLines.length; ++i) {
                this.lines.add(i);
            }
        }
    }

    public int getLinesOfCodeNumber() {
        return this.lines.size();
    }

    public Set<Integer> getLinesOfCode() {
        return this.lines;
    }
}

