/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.checks.verifier.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonarsource.analyzer.commons.checks.verifier.internal.Comment;
import org.sonarsource.analyzer.commons.checks.verifier.internal.FlowLocation;
import org.sonarsource.analyzer.commons.checks.verifier.internal.LineIssues;
import org.sonarsource.analyzer.commons.checks.verifier.internal.NoncompliantCommentParser;
import org.sonarsource.analyzer.commons.checks.verifier.internal.PreciseLocation;
import org.sonarsource.analyzer.commons.checks.verifier.internal.PreciseLocationParser;
import org.sonarsource.analyzer.commons.checks.verifier.internal.PrimaryLocation;
import org.sonarsource.analyzer.commons.checks.verifier.internal.QuickFixParser;
import org.sonarsource.analyzer.commons.checks.verifier.internal.Report;
import org.sonarsource.analyzer.commons.checks.verifier.internal.ReportDiff;
import org.sonarsource.analyzer.commons.checks.verifier.internal.SecondaryLocation;
import org.sonarsource.analyzer.commons.checks.verifier.internal.TestFile;
import org.sonarsource.analyzer.commons.checks.verifier.quickfix.QuickFix;

public class FileIssues {
    private static final Pattern LINE_NUMBER = Pattern.compile("\n(\\d{3}):");
    public final TestFile testFile;
    private final Map<Integer, LineIssues> expectedIssueMap = new TreeMap<Integer, LineIssues>();
    private final Map<Integer, LineIssues> actualIssueMap = new TreeMap<Integer, LineIssues>();
    private final Map<String, QuickFix> expectedQuickFixes;
    private final Map<Integer, List<QuickFix>> actualQuickFixes = new TreeMap<Integer, List<QuickFix>>();
    @Nullable
    private PrimaryLocation currentPrimary = null;
    private final List<SecondaryLocation> orphanSecondaryOrFlowLocations = new ArrayList<SecondaryLocation>();

    public FileIssues(TestFile testFile, List<Comment> comments) {
        this.testFile = testFile;
        for (Comment comment : comments) {
            LineIssues lineIssues = NoncompliantCommentParser.parse(testFile, comment.line, comment.content);
            if (lineIssues != null) {
                testFile.addNoncompliantComment(comment);
                LineIssues existingLineIssues = this.expectedIssueMap.get(lineIssues.line);
                if (existingLineIssues != null) {
                    existingLineIssues.merge(lineIssues);
                    continue;
                }
                this.expectedIssueMap.put(lineIssues.line, lineIssues);
                continue;
            }
            List<PreciseLocation> locations = PreciseLocationParser.parse(comment.line, comment.contentColumn, comment.content);
            if (locations.isEmpty()) continue;
            testFile.addNoncompliantComment(comment);
            locations.forEach(this::addLocation);
        }
        this.expectedQuickFixes = new QuickFixParser(comments, this.expectedIssueMap).getExpectedQuickFixes();
    }

    private void addLocation(PreciseLocation location) {
        if (location instanceof PrimaryLocation) {
            this.addPrimary((PrimaryLocation)location);
        } else {
            this.addSecondary((SecondaryLocation)location);
        }
    }

    private void addPrimary(PrimaryLocation primary) {
        LineIssues lineIssues = this.expectedIssueMap.get(primary.range.line);
        if (lineIssues == null) {
            throw new IllegalStateException("Primary location does not have a related issue at " + primary.range.toString());
        }
        if (lineIssues.primaryLocation != null) {
            throw new IllegalStateException("Primary location conflicts with another primary location at " + primary.range.toString());
        }
        this.orphanSecondaryOrFlowLocations.forEach(secondary -> FileIssues.addSecondaryTo(secondary, primary));
        this.orphanSecondaryOrFlowLocations.clear();
        lineIssues.primaryLocation = primary;
        this.currentPrimary = primary;
    }

    private void addSecondary(SecondaryLocation secondary) {
        if (secondary.primaryIsBefore) {
            if (this.currentPrimary == null) {
                throw new IllegalStateException("Secondary location '<' without previous primary location at " + secondary.range.toString());
            }
            FileIssues.addSecondaryTo(secondary, this.currentPrimary);
        } else {
            this.orphanSecondaryOrFlowLocations.add(secondary);
        }
    }

    private static void addSecondaryTo(SecondaryLocation secondary, PrimaryLocation primary) {
        if (secondary instanceof FlowLocation) {
            FlowLocation flow = (FlowLocation)secondary;
            for (int flowId = primary.flowLocations.size(); flowId <= flow.flowIndex; ++flowId) {
                primary.flowLocations.add(new ArrayList());
            }
            List<FlowLocation> flowList = primary.flowLocations.get(flow.flowIndex);
            for (int indexInTheFlow = flowList.size(); indexInTheFlow < flow.indexInTheFlow; ++indexInTheFlow) {
                flowList.add(null);
            }
            flowList.set(flow.indexInTheFlow - 1, flow);
        } else {
            primary.secondaryLocations.add(secondary);
        }
    }

    public void addActualIssue(int line, String message, @Nullable PrimaryLocation preciseLocation) {
        this.addActualIssue(line, message, preciseLocation, null, List.of());
    }

    public void addActualIssue(int line, String message, @Nullable PrimaryLocation preciseLocation, @Nullable Double effortToFix) {
        this.addActualIssue(line, message, preciseLocation, effortToFix, List.of());
    }

    public void addActualIssue(int line, String message, @Nullable PrimaryLocation preciseLocation, @Nullable Double effortToFix, List<QuickFix> quickfixes) {
        LineIssues lineIssues = this.actualIssueMap.computeIfAbsent(line, key -> LineIssues.at(this.testFile, line, preciseLocation));
        lineIssues.add(message, effortToFix);
        lineIssues.setQuickfixes(quickfixes);
    }

    public Report report() {
        if (!this.orphanSecondaryOrFlowLocations.isEmpty()) {
            SecondaryLocation orphanSecondary = this.orphanSecondaryOrFlowLocations.get(0);
            throw new IllegalStateException("Secondary location '>' without next primary location at " + orphanSecondary.range.toString());
        }
        Report report = new Report();
        report.setExpectedIssueCount(this.expectedIssueMap.values().stream().mapToInt(issues -> issues.messages.size()).sum());
        report.setExpectedQuickfixCount(this.expectedQuickFixes.size());
        String testFileName = "<" + this.testFile.getName() + ">";
        report.appendExpected(testFileName + "\n" + this.expectedIssueMap.values().stream().map(LineIssues::validateExpected).map(LineIssues::toString).collect(Collectors.joining("\n")));
        report.setActualIssueCount(this.actualIssueMap.values().stream().mapToInt(issues -> issues.messages.size()).sum());
        report.setActualQuickfixCount(this.actualQuickFixes.values().stream().mapToInt(List::size).sum());
        report.appendActual(testFileName + "\n" + this.actualIssueMap.values().stream().map(lineIssues -> lineIssues.dropUntestedAttributes(this.expectedIssueMap.get(lineIssues.line))).map(LineIssues::toString).collect(Collectors.joining("\n")));
        int line = FileIssues.firstDiffLine(report.getExpected(), report.getActual());
        String diff = "[----------------------------------------------------------------------]\n[ '-' means expected but not raised, '+' means raised but not expected ]\n" + ReportDiff.diff(report.getExpected(), report.getActual()) + "[----------------------------------------------------------------------]\n";
        report.appendContext("In file (" + this.testFile.getName() + ":" + line + ")\n" + diff);
        this.buildQuickfixReport(report);
        return report;
    }

    private static int firstDiffLine(String expected, String actual) {
        int offset;
        for (offset = 0; offset < expected.length() && offset < actual.length() && expected.charAt(offset) == actual.charAt(offset); ++offset) {
        }
        int line = 1;
        Matcher matcher = LINE_NUMBER.matcher(expected);
        while (matcher.find() && matcher.start() <= offset) {
            line = Integer.parseInt(matcher.group(1));
        }
        return line;
    }

    private void buildQuickfixReport(Report report) {
        for (LineIssues expectedIssue : this.expectedIssueMap.values()) {
            LineIssues actualIssue = this.actualIssueMap.get(expectedIssue.line);
            if (actualIssue == null) continue;
            String[] expectedQfs = FileIssues.getQfIdsFromIssue(expectedIssue);
            if (expectedQfs.length == 1 && "!".equals(expectedQfs[0])) {
                if (actualIssue.getQuickfixes().isEmpty()) continue;
                report.appendQuickfixContext(String.format("Issue at line %d was expecting to have no quickfixes but had %d", actualIssue.line, actualIssue.getQuickfixes().size()));
                continue;
            }
            for (String qfId : expectedQfs) {
                this.appendQuickfixReport(qfId, actualIssue, expectedIssue, report);
            }
        }
    }

    private void appendQuickfixReport(String qfId, LineIssues actualIssue, LineIssues expectedIssue, Report report) {
        QuickFix qf = this.expectedQuickFixes.get(qfId);
        if (!FileIssues.isExpectedQuickfixProvided(qf, actualIssue.getQuickfixes())) {
            report.appendQuickfixContext(String.format("Expected quickfix %s at line %d was not matched by any provided quickfixes %n", qfId, expectedIssue.line));
            report.appendQuickfixContext(String.format("Expected description: {{%s}} %n", qf.getDescription()));
            String textEditsString = String.format(qf.getTextEdits().stream().map(edit -> edit.getTextSpan() + " -> " + edit.getReplacement()).collect(Collectors.joining("%n")), new Object[0]);
            report.appendQuickfixContext(String.format("Expected edits: %n%s", textEditsString));
        }
    }

    private static boolean isExpectedQuickfixProvided(QuickFix expected, List<QuickFix> actuallyProvided) {
        return actuallyProvided.stream().anyMatch(qf -> qf.getDescription().equals(expected.getDescription()) && qf.getTextEdits().equals(expected.getTextEdits()));
    }

    private static String[] getQfIdsFromIssue(LineIssues issue) {
        String qfs = issue.params.get("quickfixes");
        if (qfs == null) {
            return new String[0];
        }
        return qfs.split(",");
    }
}

