/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.helpers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.sonarsource.analyzer.commons.regex.ast.AutomatonState;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassElementTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassIntersectionTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterRangeTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterTree;
import org.sonarsource.analyzer.commons.regex.ast.DotTree;
import org.sonarsource.analyzer.commons.regex.ast.EscapedCharacterClassTree;
import org.sonarsource.analyzer.commons.regex.ast.MiscEscapeSequenceTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;

public class SimplifiedRegexCharacterClass {
    private TreeMap<Integer, RegexSyntaxElement> contents = new TreeMap();
    private boolean containsUnknownCharacters = false;

    public SimplifiedRegexCharacterClass() {
    }

    public SimplifiedRegexCharacterClass(CharacterClassElementTree tree) {
        this.add(tree);
    }

    public SimplifiedRegexCharacterClass(DotTree tree) {
        this.add(tree);
    }

    @Nullable
    public static SimplifiedRegexCharacterClass of(AutomatonState tree) {
        if (tree instanceof CharacterClassElementTree) {
            return new SimplifiedRegexCharacterClass((CharacterClassElementTree)((Object)tree));
        }
        if (tree instanceof DotTree) {
            return new SimplifiedRegexCharacterClass((DotTree)tree);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.contents.isEmpty() && !this.containsUnknownCharacters;
    }

    public void add(CharacterClassElementTree tree) {
        new Builder(this).visitInCharClass(tree);
    }

    public void add(DotTree tree) {
        char[] orderedExcludedCharacters = tree.activeFlags().contains(32) ? new char[]{} : (tree.activeFlags().contains(1) ? new char[]{'\n'} : new char[]{'\n', '\r', '\u0085', '\u2028', '\u2029'});
        int from = 0;
        for (char excludedCharacter : orderedExcludedCharacters) {
            int to = excludedCharacter - '\u0001';
            if (to > from) {
                this.addRange(from, to, tree);
            }
            from = excludedCharacter + '\u0001';
        }
        this.addRange(from, 0x10FFFF, tree);
    }

    public boolean matchesAnyCharacter() {
        return this.contents.containsKey(0) && !this.contents.containsValue(null);
    }

    public boolean intersects(SimplifiedRegexCharacterClass that, boolean defaultAnswer) {
        if (defaultAnswer && (this.containsUnknownCharacters && !that.isEmpty() || !this.isEmpty() && that.containsUnknownCharacters)) {
            return true;
        }
        return !this.findIntersections(that, true).isEmpty();
    }

    public List<RegexSyntaxElement> findIntersections(SimplifiedRegexCharacterClass that) {
        return this.findIntersections(that, false);
    }

    private List<RegexSyntaxElement> findIntersections(SimplifiedRegexCharacterClass that, boolean stopAtFirst) {
        Iterator<Map.Entry<Integer, RegexSyntaxElement>> iter = that.contents.entrySet().iterator();
        ArrayList<RegexSyntaxElement> intersections = new ArrayList<RegexSyntaxElement>();
        if (!iter.hasNext()) {
            return intersections;
        }
        Map.Entry<Integer, RegexSyntaxElement> entry = iter.next();
        while (iter.hasNext()) {
            Map.Entry<Integer, RegexSyntaxElement> nextEntry = iter.next();
            int to = nextEntry.getValue() == null ? nextEntry.getKey() - 1 : nextEntry.getKey();
            RegexSyntaxElement value = entry.getValue();
            if (value != null && this.hasEntryBetween(entry.getKey(), to)) {
                intersections.add(value);
                if (stopAtFirst) {
                    return intersections;
                }
            }
            entry = nextEntry;
        }
        RegexSyntaxElement value = entry.getValue();
        if (value != null && this.hasEntryBetween(entry.getKey(), 0x10FFFF)) {
            intersections.add(value);
        }
        return intersections;
    }

    private boolean hasEntryBetween(int from, int to) {
        Map.Entry<Integer, RegexSyntaxElement> before = this.contents.floorEntry(from);
        return before != null && before.getValue() != null || !this.contents.subMap(from, false, to, true).isEmpty();
    }

    public boolean supersetOf(SimplifiedRegexCharacterClass that, boolean defaultAnswer) {
        if (this.isEmpty() && !that.isEmpty() || that.containsUnknownCharacters && !defaultAnswer) {
            return false;
        }
        Iterator<Map.Entry<Integer, RegexSyntaxElement>> thatIter = that.contents.entrySet().iterator();
        if (!thatIter.hasNext()) {
            return true;
        }
        Map.Entry<Integer, RegexSyntaxElement> thatEntry = thatIter.next();
        while (thatIter.hasNext()) {
            Map.Entry<Integer, RegexSyntaxElement> thatNextEntry = thatIter.next();
            if (this.notSupersetOfEntries(thatEntry, thatNextEntry)) {
                return false;
            }
            thatEntry = thatNextEntry;
        }
        if (thatEntry.getValue() == null) {
            return true;
        }
        Map.Entry<Integer, RegexSyntaxElement> lastEntry = this.contents.lastEntry();
        return lastEntry.getValue() != null && lastEntry.getKey() <= thatEntry.getKey();
    }

    private boolean notSupersetOfEntries(Map.Entry<Integer, RegexSyntaxElement> thatEntry, Map.Entry<Integer, RegexSyntaxElement> thatNextEntry) {
        if (thatEntry.getValue() != null) {
            Map.Entry<Integer, RegexSyntaxElement> thisBefore = this.contents.floorEntry(thatEntry.getKey());
            if (thisBefore == null || thisBefore.getValue() == null) {
                return true;
            }
            int to = thatNextEntry.getValue() == null ? thatNextEntry.getKey() - 1 : thatNextEntry.getKey();
            return this.contents.subMap(thatEntry.getKey(), false, to, true).values().stream().anyMatch(Objects::isNull);
        }
        return false;
    }

    public void addRange(int from, int to, RegexSyntaxElement tree) {
        Map.Entry<Integer, RegexSyntaxElement> oldEntry = this.contents.floorEntry(to);
        Integer oldEnd = oldEntry == null ? null : this.contents.higherKey(oldEntry.getKey());
        this.contents.put(from, tree);
        for (Map.Entry entry : this.contents.subMap(from, false, to, true).entrySet()) {
            if (entry.getValue() != null) continue;
            entry.setValue(tree);
        }
        int next = to + 1;
        if (next <= 0x10FFFF) {
            if (oldEntry != null && oldEntry.getValue() != null && (oldEnd == null || oldEnd > next)) {
                this.contents.put(next, oldEntry.getValue());
            } else if (!this.contents.containsKey(next)) {
                this.contents.put(next, null);
            }
        }
    }

    private static class Builder
    extends RegexBaseVisitor {
        private SimplifiedRegexCharacterClass characters;

        public Builder(SimplifiedRegexCharacterClass characters) {
            this.characters = characters;
        }

        @Override
        public void visitCharacter(CharacterTree tree) {
            this.addRange(tree.codePointOrUnit(), tree.codePointOrUnit(), tree);
        }

        @Override
        public void visitCharacterRange(CharacterRangeTree tree) {
            this.addRange(tree.getLowerBound().codePointOrUnit(), tree.getUpperBound().codePointOrUnit(), tree);
        }

        @Override
        public void visitMiscEscapeSequence(MiscEscapeSequenceTree tree) {
            this.characters.containsUnknownCharacters = true;
        }

        @Override
        public void visitCharacterClass(CharacterClassTree tree) {
            if (tree.isNegated()) {
                SimplifiedRegexCharacterClass inner;
                SimplifiedRegexCharacterClass old = this.characters;
                this.characters = inner = new SimplifiedRegexCharacterClass();
                super.visitCharacterClass(tree);
                this.characters = old;
                if (inner.containsUnknownCharacters) {
                    this.characters.containsUnknownCharacters = true;
                    this.characters.contents = new TreeMap();
                    return;
                }
                boolean lastInsertedIsNotNull = false;
                if (inner.contents.get(0) == null) {
                    this.characters.contents.put(0, tree);
                    lastInsertedIsNotNull = true;
                }
                for (Map.Entry<Integer, RegexSyntaxElement> entry : inner.contents.entrySet()) {
                    if (entry.getValue() == null) {
                        this.characters.contents.put(entry.getKey(), tree);
                        lastInsertedIsNotNull = true;
                        continue;
                    }
                    if (!lastInsertedIsNotNull) continue;
                    this.characters.contents.put(entry.getKey(), null);
                    lastInsertedIsNotNull = false;
                }
            } else {
                super.visitCharacterClass(tree);
            }
        }

        @Override
        public void visitCharacterClassIntersection(CharacterClassIntersectionTree tree) {
            this.characters.containsUnknownCharacters = true;
        }

        @Override
        public void visitEscapedCharacterClass(EscapedCharacterClassTree tree) {
            switch (tree.getType()) {
                case 'd': {
                    this.characters.addRange(48, 57, tree);
                    if (!tree.activeFlags().contains(256)) break;
                    this.characters.containsUnknownCharacters = true;
                    break;
                }
                case 'D': {
                    this.characters.addRange(0, 47, tree);
                    if (tree.activeFlags().contains(256)) {
                        this.characters.addRange(58, 255, tree);
                        this.characters.containsUnknownCharacters = true;
                        break;
                    }
                    this.characters.addRange(58, 0x10FFFF, tree);
                    break;
                }
                case 'w': {
                    this.characters.addRange(48, 57, tree);
                    this.characters.addRange(65, 90, tree);
                    this.characters.addRange(95, 95, tree);
                    this.characters.addRange(97, 122, tree);
                    if (!tree.activeFlags().contains(256)) break;
                    this.characters.containsUnknownCharacters = true;
                    break;
                }
                case 'W': {
                    this.characters.addRange(0, 47, tree);
                    this.characters.addRange(58, 64, tree);
                    this.characters.addRange(91, 94, tree);
                    this.characters.addRange(96, 96, tree);
                    if (tree.activeFlags().contains(256)) {
                        this.characters.addRange(123, 180, tree);
                        this.characters.containsUnknownCharacters = true;
                        break;
                    }
                    this.characters.addRange(123, 0x10FFFF, tree);
                    break;
                }
                case 's': {
                    this.characters.addRange(9, 13, tree);
                    this.characters.addRange(32, 32, tree);
                    if (!tree.activeFlags().contains(256)) break;
                    this.characters.addRange(133, 133, tree);
                    this.characters.addRange(160, 160, tree);
                    this.characters.addRange(5760, 5760, tree);
                    this.characters.addRange(8192, 8202, tree);
                    this.characters.addRange(8232, 8233, tree);
                    this.characters.addRange(8239, 8239, tree);
                    this.characters.addRange(8287, 8287, tree);
                    this.characters.addRange(12288, 12288, tree);
                    break;
                }
                case 'S': {
                    this.characters.addRange(0, 8, tree);
                    this.characters.addRange(14, 31, tree);
                    if (tree.activeFlags().contains(256)) {
                        this.characters.addRange(33, 132, tree);
                        this.characters.addRange(134, 159, tree);
                        this.characters.addRange(161, 5759, tree);
                        this.characters.addRange(5761, 8191, tree);
                        this.characters.addRange(8203, 8231, tree);
                        this.characters.addRange(8234, 8238, tree);
                        this.characters.addRange(8240, 8286, tree);
                        this.characters.addRange(8288, 12287, tree);
                        this.characters.addRange(12289, 0x10FFFF, tree);
                        break;
                    }
                    this.characters.addRange(33, 0x10FFFF, tree);
                    break;
                }
                default: {
                    this.characters.containsUnknownCharacters = true;
                }
            }
        }

        private void addRange(int from, int to, CharacterClassElementTree tree) {
            this.characters.addRange(from, to, tree);
            if (tree.activeFlags().contains(2)) {
                this.addCaseInsensitiveRangeFor(from, to, tree, 'A', 'Z', 'a', 'z');
                if (tree.activeFlags().contains(64)) {
                    this.addCaseInsensitiveRangeFor(from, to, tree, '\u00c0', '\u00de', '\u00e0', '\u00fe');
                }
            }
        }

        private void addCaseInsensitiveRangeFor(int from, int to, CharacterClassElementTree tree, char upperStart, char upperEnd, char lowerStart, char lowerEnd) {
            int lowerCaseShift = lowerStart - upperStart;
            if (from <= upperEnd && to >= upperStart) {
                this.characters.addRange(Math.max(from, upperStart) + lowerCaseShift, Math.min(to, upperEnd) + lowerCaseShift, tree);
            }
            if (from <= lowerEnd && to >= lowerStart) {
                this.characters.addRange(Math.max(from, lowerStart) - lowerCaseShift, Math.min(to, lowerEnd) - lowerCaseShift, tree);
            }
        }
    }
}

