/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.format;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.format.MatOpaque;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Cell;
import us.hebi.matlab.mat.types.JavaObject;
import us.hebi.matlab.mat.types.Matrix;
import us.hebi.matlab.mat.types.Struct;

class MatJavaObject
extends MatOpaque
implements JavaObject {
    MatJavaObject(String className, Array content) {
        super("java", className, content);
    }

    private Matrix getSerializedData() {
        Array content = this.getContent();
        if (content instanceof Matrix) {
            return (Matrix)content;
        }
        if (content instanceof Struct) {
            return (Matrix)((Struct)content).get("Values");
        }
        if (content instanceof Cell) {
            Cell cells = (Cell)content;
            for (int i = 0; i < cells.getNumElements(); ++i) {
                Object array = cells.get(i);
                if (!(array instanceof Matrix)) continue;
                return (Matrix)array;
            }
        }
        String msg = String.format("Unexpected byte storage. Found: %s", content);
        throw new IllegalStateException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object instantiateObject() throws Exception {
        ByteBuffer buffer = Mat5.exportBytes(this.getSerializedData());
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
        try {
            Object object = ois.readObject();
            return object;
        }
        finally {
            ois.close();
        }
    }
}

