/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.index.shared;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.io.SerializationUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@IndexValueClass(containedInBackup=true)
public class TrackedFinding
extends IndexFinding
implements Comparable<TrackedFinding> {
    private static final long serialVersionUID = 1L;
    protected static final String ID_PROPERTY = "id";
    protected static final String BIRTH_PROPERTY = "birth";
    protected static final String DEATH_PROPERTY = "death";
    @JsonIgnore
    private final String findingIndexPartition;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="birth")
    private final CommitDescriptor birth;
    @JsonProperty(value="death")
    private @Nullable CommitDescriptor death;

    public TrackedFinding(IndexFinding finding, String id, CommitDescriptor birth, String findingIndexPartition, CodeScopeName codeScopeNameFallback) {
        this(finding, id, birth, findingIndexPartition, null, codeScopeNameFallback);
    }

    public TrackedFinding(IndexFinding finding, String id, CommitDescriptor birth, String findingIndexPartition, CommitDescriptor death, CodeScopeName codeScopeNameFallback) {
        super(finding);
        this.id = id;
        this.birth = birth;
        this.findingIndexPartition = findingIndexPartition;
        this.death = death;
        if (this.codeScopeName == null) {
            this.codeScopeName = Objects.requireNonNull(codeScopeNameFallback, "Original finding did not have a code scope name configured, and no fallback value provided.");
        }
    }

    public TrackedFinding(TrackedFinding other) {
        super(other);
        this.id = other.id;
        this.birth = other.birth;
        this.death = other.death;
        this.findingIndexPartition = other.findingIndexPartition;
    }

    @JsonCreator
    public TrackedFinding(@JsonProperty(value="groupName") String groupName, @JsonProperty(value="categoryName") String categoryName, @JsonProperty(value="message") String message, @JsonProperty(value="location") ElementLocation location, @JsonProperty(value="id") String id, @JsonProperty(value="birth") CommitDescriptor birth, @JsonProperty(value="death") CommitDescriptor death, @JsonProperty(value="codeScopeName") CodeScopeName codeScopeName) {
        super(groupName, categoryName, message, location);
        this.id = id;
        this.birth = birth;
        this.death = death;
        this.findingIndexPartition = null;
        this.codeScopeName = Objects.requireNonNull(codeScopeName, "codeScopeName");
    }

    public String getId() {
        return this.id;
    }

    @Override
    @Deprecated
    public void setCodeScopeName(CodeScopeName codeScopeName) {
        throw new UnsupportedOperationException("Overwriting the code scope is not supported");
    }

    @Override
    @JsonGetter(value="codeScopeName")
    public @NonNull CodeScopeName getCodeScopeName() {
        return Objects.requireNonNull(super.getCodeScopeName());
    }

    public String toStringWithId() {
        return super.toString() + " (" + this.id + ")";
    }

    public CommitDescriptor getBirthCommit() {
        return this.birth;
    }

    public String getFindingIndexPartition() {
        return this.findingIndexPartition;
    }

    public CommitDescriptor getDeathCommit() {
        return this.death;
    }

    public void setDeathCommit(CommitDescriptor death) {
        this.death = death;
    }

    public boolean isAlive() {
        return this.death == null;
    }

    @Override
    public int compareTo(TrackedFinding other) {
        return this.id.compareTo(other.id);
    }

    public String getQualifiedGroupName() {
        return this.getCategoryName() + "/" + this.getGroupName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrackedFinding that = (TrackedFinding)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        SerializationUtils.unsupportedWriteObject((ObjectOutputStream)out, (String)"TrackedFinding should not be serialized via default serialization");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        SerializationUtils.unsupportedReadObject((ObjectInputStream)in, (String)"TrackedFinding should not be deserialized via default serialization");
    }

    public static class Builder {
        private IndexFinding originalIndexFinding;
        private TrackedFinding originalTrackedFinding;
        private String id;
        private String findingIndexPartition;
        private CommitDescriptor birthCommit;
        private CommitDescriptor deathCommit;
        private CodeScopeName codeScopeNameFallback;

        private Builder() {
        }

        public static Builder from(IndexFinding indexFinding) {
            Builder builder = new Builder();
            builder.originalIndexFinding = indexFinding;
            return builder;
        }

        public static Builder from(TrackedFinding trackedFinding) {
            Builder builder = new Builder();
            builder.originalTrackedFinding = trackedFinding;
            builder.id = trackedFinding.id;
            builder.findingIndexPartition = trackedFinding.findingIndexPartition;
            builder.birthCommit = trackedFinding.birth;
            builder.deathCommit = trackedFinding.death;
            return builder;
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withFindingIndexPartition(String findingIndexPartition) {
            this.findingIndexPartition = findingIndexPartition;
            return this;
        }

        public Builder withBirthCommit(CommitDescriptor birthCommit) {
            this.birthCommit = birthCommit;
            return this;
        }

        public Builder withDeathCommit(CommitDescriptor deathCommit) {
            this.deathCommit = deathCommit;
            return this;
        }

        public Builder withCodeScopeNameFallback(CodeScopeName codeScopeNameFallback) {
            this.codeScopeNameFallback = codeScopeNameFallback;
            return this;
        }

        public TrackedFinding build() {
            IndexFinding originalFinding = Optional.ofNullable(this.originalIndexFinding).orElse(this.originalTrackedFinding);
            Preconditions.checkNotNull((Object)this.id);
            Preconditions.checkNotNull((Object)this.birthCommit);
            Preconditions.checkNotNull((Object)this.findingIndexPartition);
            return new TrackedFinding(originalFinding, this.id, this.birthCommit, this.findingIndexPartition, this.deathCommit, this.codeScopeNameFallback);
        }
    }

    public static class TrackedFindingComparator
    implements Comparator<TrackedFinding> {
        @Override
        public int compare(TrackedFinding f1, TrackedFinding f2) {
            int pathComparison;
            String p1 = f1.getLocation().getUniformPath();
            String p2 = f2.getLocation().getUniformPath();
            if (f1.getLocation() instanceof QualifiedNameLocation) {
                p1 = f1.getLocation().toString();
            }
            if (f2.getLocation() instanceof QualifiedNameLocation) {
                p2 = f2.getLocation().toString();
            }
            if ((pathComparison = p1.compareTo(p2)) != 0) {
                return pathComparison;
            }
            if (f1.getLocation() instanceof TextRegionLocation && f2.getLocation() instanceof TextRegionLocation) {
                TextRegionLocation l1 = (TextRegionLocation)f1.getLocation();
                TextRegionLocation l2 = (TextRegionLocation)f2.getLocation();
                int startDiff = l1.getRawStartLine() - l2.getRawStartLine();
                if (startDiff == 0) {
                    return l1.getRawEndLine() - l2.getRawEndLine();
                }
                return startDiff;
            }
            if (f1.getLocation() instanceof TextRegionLocation) {
                return -1;
            }
            if (f2.getLocation() instanceof TextRegionLocation) {
                return 1;
            }
            return 0;
        }
    }
}

