/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.reportparser.parser;

import com.teamscale.reportparser.CoverageReportParserBase;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;

public class GolangCoverageReportParser
extends CoverageReportParserBase {
    private static final Pattern PATTERN = Pattern.compile("(.*\\.go):(\\d+)\\.\\d+,(\\d+)\\.\\d+ \\d+ (\\d+)");

    @Override
    public void parseCoverageReport(String report, CoverageInfoRetriever retriever) {
        AtomicInteger index = new AtomicInteger();
        report.lines().skip(1L).forEach(line -> GolangCoverageReportParser.parseLine(line, index.incrementAndGet(), retriever));
    }

    private static void parseLine(String line, int index, CoverageInfoRetriever retriever) {
        Matcher matcher = PATTERN.matcher(line);
        if (!matcher.matches()) {
            LOGGER.warn("Could not parse line {} which is not in expected format!", (Object)(index + 1));
            return;
        }
        String path = matcher.group(1);
        int startLine = Integer.parseInt(matcher.group(2));
        int endLine = Integer.parseInt(matcher.group(3));
        ELineCoverage coverageType = ELineCoverage.NOT_COVERED;
        if (Integer.parseInt(matcher.group(4)) > 0) {
            coverageType = ELineCoverage.FULLY_COVERED;
        }
        retriever.getOrCreateLineCoverageInfo(path).addRangeCoverage(startLine, endLine, coverageType);
    }
}

