/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage.volume.condition;

import eu.cqse.check.framework.scanner.ETokenType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.sourcecode.coverage.volume.condition.Condition;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionInnerTreeNode;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionTreeNodeFalse;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionTreeNodeLeaf;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionTreeNodeTrue;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionTreeUtils;
import org.conqat.engine.sourcecode.coverage.volume.condition.ExpressionTreeBuilder;
import org.conqat.engine.sourcecode.coverage.volume.condition.ExpressionTreeNode;
import org.conqat.engine.sourcecode.coverage.volume.condition.IConditionTreeNode;
import org.conqat.engine.sourcecode.coverage.volume.condition.IOperatorInformation;
import org.conqat.engine.sourcecode.coverage.volume.condition.SubConditionParserBase;

public abstract class ConditionEvaluatorBase {
    protected Map<ETokenType, ETokenType> negationsForRelational = new HashMap<ETokenType, ETokenType>();
    protected Map<ETokenType, ETokenType> oppositeOperators = new HashMap<ETokenType, ETokenType>();
    protected Map<ETokenType, ETokenType> relationalSuperSets = new HashMap<ETokenType, ETokenType>();
    private static final short MAX_LITERALS = 10;

    protected ConditionEvaluatorBase() {
        this.initializeNegationsForRelational();
        this.initializeRelationalSuperSets();
        this.initializeOppositeOperators();
    }

    public boolean conditionEqual(Condition condition1, Condition condition2) {
        if (condition1 == condition2) {
            return true;
        }
        if (condition1 == null || condition2 == null) {
            return false;
        }
        return this.getCanonicalRepresentation(condition1).equals(this.getCanonicalRepresentation(condition2));
    }

    public IConditionTreeNode getCanonicalRepresentation(Condition condition) {
        IConditionTreeNode tree = this.getConditionTree(condition);
        if (ConditionTreeUtils.countLiterals(tree, 10) >= 10) {
            return tree.simplify().castToBoolean();
        }
        return ConditionEvaluatorBase.toCnf(tree).castToBoolean();
    }

    private IConditionTreeNode getConditionTree(Condition condition) {
        ExpressionTreeNode expression = ExpressionTreeBuilder.buildExpressionTree(condition.getTokens(), this.getOperatorInformation(), false, false, true);
        return ConditionEvaluatorBase.expandTree(new ConditionTreeNodeLeaf(expression, this));
    }

    protected abstract ETokenType getOpeningBracketType();

    protected abstract ETokenType getClosingBracketType();

    private void initializeNegationsForRelational() {
        this.negationsForRelational.put(ETokenType.EQEQ, ETokenType.NOTEQ);
        this.negationsForRelational.put(ETokenType.NOTEQ, ETokenType.EQEQ);
        this.negationsForRelational.put(ETokenType.LT, ETokenType.GTEQ);
        this.negationsForRelational.put(ETokenType.GT, ETokenType.LTEQ);
        this.negationsForRelational.put(ETokenType.LTEQ, ETokenType.GT);
        this.negationsForRelational.put(ETokenType.GTEQ, ETokenType.LT);
    }

    private void initializeOppositeOperators() {
        this.oppositeOperators.put(ETokenType.EQEQ, ETokenType.NOTEQ);
        this.oppositeOperators.put(ETokenType.NOTEQ, ETokenType.EQEQ);
        this.oppositeOperators.put(ETokenType.LT, ETokenType.GT);
        this.oppositeOperators.put(ETokenType.GT, ETokenType.LT);
        this.oppositeOperators.put(ETokenType.IS, ETokenType.IS_NOT);
        this.oppositeOperators.put(ETokenType.IN, ETokenType.NOT_IN);
    }

    private void initializeRelationalSuperSets() {
        this.relationalSuperSets.put(ETokenType.LT, ETokenType.LTEQ);
        this.relationalSuperSets.put(ETokenType.LTEQ, ETokenType.LTEQ);
        this.relationalSuperSets.put(ETokenType.GT, ETokenType.GTEQ);
        this.relationalSuperSets.put(ETokenType.GTEQ, ETokenType.GTEQ);
    }

    public static ETokenType getNegationOperator() {
        return ETokenType.NOT;
    }

    protected abstract ETokenType getAndOperator();

    protected abstract ETokenType getOrOperator();

    protected abstract boolean isEqualOperator(ETokenType var1);

    protected abstract boolean isNotEqualOperator(ETokenType var1);

    public abstract Set<ETokenType> getBooleanOperators();

    private static IConditionTreeNode expandTree(IConditionTreeNode node) {
        return node.expand();
    }

    private static IConditionTreeNode toCnf(IConditionTreeNode node) {
        return node.toCnf();
    }

    public IConditionTreeNode addNegation(IConditionTreeNode node) {
        return new ConditionInnerTreeNode(ConditionEvaluatorBase.getNegationOperator(), node, this);
    }

    public static boolean childrenContainFalse(Collection<IConditionTreeNode> children) {
        return children.stream().anyMatch(ConditionTreeNodeFalse.class::isInstance);
    }

    public static boolean childrenContainTrue(Collection<IConditionTreeNode> children) {
        return children.stream().anyMatch(ConditionTreeNodeTrue.class::isInstance);
    }

    Set<IConditionTreeNode> childrenOfConvertOr(Set<IConditionTreeNode> currentChildren) {
        List<IConditionTreeNode> list = currentChildren.stream().toList();
        LinkedHashSet<IConditionTreeNode> newChildren = new LinkedHashSet<IConditionTreeNode>();
        this.childrenOfConvertOr(newChildren, list, 0, null);
        return newChildren;
    }

    private void childrenOfConvertOr(Set<IConditionTreeNode> newChildren, List<IConditionTreeNode> currentChildren, int position, ConditionInnerTreeNode orSubClause) {
        IConditionTreeNode child = currentChildren.get(position);
        if (child instanceof ConditionInnerTreeNode && child.getOperator() == this.getAndOperator()) {
            for (IConditionTreeNode grandChild : child.getChildren()) {
                this.expandAndBy(newChildren, currentChildren, position, orSubClause, grandChild);
            }
        } else {
            this.expandAndBy(newChildren, currentChildren, position, orSubClause, child);
        }
    }

    private void expandAndBy(Set<IConditionTreeNode> newChildren, List<IConditionTreeNode> currentChildren, int position, ConditionInnerTreeNode orSubClause, IConditionTreeNode expandBy) {
        if (orSubClause == null) {
            orSubClause = new ConditionInnerTreeNode(this.getOrOperator(), this);
        }
        ConditionInnerTreeNode finalOrSubClause = new ConditionInnerTreeNode(this.getOrOperator(), orSubClause.getChildren(), this);
        finalOrSubClause.getChildren().add(expandBy);
        if (position >= currentChildren.size() - 1) {
            newChildren.add(finalOrSubClause);
        } else {
            this.childrenOfConvertOr(newChildren, currentChildren, position + 1, finalOrSubClause);
        }
    }

    public List<IConditionTreeNode> simplifyAndChildrenSet(Set<IConditionTreeNode> children) {
        List<IConditionTreeNode> result = new ArrayList<IConditionTreeNode>();
        for (IConditionTreeNode child : children) {
            if (child instanceof ConditionInnerTreeNode) {
                result.add(this.simplifyOrNode((ConditionInnerTreeNode)child));
                continue;
            }
            result.add(child);
        }
        if (ConditionEvaluatorBase.childrenContainFalse(result = new ArrayList(new LinkedHashSet(result)))) {
            return List.of(new ConditionTreeNodeFalse());
        }
        ArrayList<IConditionTreeNode> finalChildren = result;
        if (children.stream().anyMatch(c1 -> finalChildren.stream().anyMatch(c2 -> c1 != c2 && c2.isOpposite((IConditionTreeNode)c1)))) {
            return List.of(new ConditionTreeNodeFalse());
        }
        if ((result = result.stream().filter(c1 -> {
            if (c1.getOperator() != this.getOrOperator()) return true;
            if (!finalChildren.stream().noneMatch(c1::contains)) return false;
            return true;
        }).toList()).size() > 1) {
            result = result.stream().filter(c1 -> !(c1 instanceof ConditionTreeNodeTrue)).toList();
        }
        return result;
    }

    public IConditionTreeNode simplifyOrNode(ConditionInnerTreeNode node) {
        if (node.getOperator() != this.getOrOperator()) {
            return node;
        }
        List<IConditionTreeNode> children = new ArrayList<IConditionTreeNode>(new LinkedHashSet<IConditionTreeNode>(node.getChildren()));
        if (ConditionEvaluatorBase.childrenContainTrue(children)) {
            return new ConditionTreeNodeTrue();
        }
        List<IConditionTreeNode> finalChildren = children = children.stream().filter(child -> !(child instanceof ConditionTreeNodeFalse)).toList();
        if (children.stream().anyMatch(c1 -> finalChildren.stream().anyMatch(c2 -> c2.isOpposite((IConditionTreeNode)c1)))) {
            return new ConditionTreeNodeTrue();
        }
        if (children.size() == 1) {
            return (IConditionTreeNode)children.stream().findFirst().get();
        }
        node.setChildren(children);
        return node;
    }

    public List<Condition> splitConditionWithOperatorPrecedence(Condition condition) {
        if (condition == null) {
            return Collections.emptyList();
        }
        List<Condition> split = SubConditionParserBase.splitCondition(condition, this.getOrOperator(), this.getOpeningBracketType(), this.getClosingBracketType());
        if (split.isEmpty() || split.get(0).equals(condition)) {
            split = SubConditionParserBase.splitCondition(condition, this.getAndOperator(), this.getOpeningBracketType(), this.getClosingBracketType());
        }
        if (!split.isEmpty() && !split.get(0).equals(condition)) {
            return split;
        }
        return List.of(condition);
    }

    public List<List<Condition>> splitConditionsWithOperatorPrecedence(List<Condition> conditions) {
        return conditions.stream().map(this::splitConditionWithOperatorPrecedence).collect(Collectors.toList());
    }

    public abstract IConditionTreeNode castToBoolean(IConditionTreeNode var1, ExpressionTreeNode var2);

    public abstract boolean supportsImplicitBooleanCast();

    public abstract IOperatorInformation getOperatorInformation();
}

