/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.capability.IAbbreviationStoreCapability;
import org.conqat.engine.persistence.store.util.IStorageAbbreviator;
import org.conqat.engine.persistence.store.util.StorageAbbreviation;
import org.conqat.engine.persistence.store.util.StorageAbbreviationList;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.NonNull;

public abstract sealed class UniformPathSerializer
implements ISerializer<UniformPath, byte[]> {
    private static final MethodHandle OF_SEGMENTS_UNSAFE = UniformPathSerializer.getOfSegmentsUnsafe();

    private static MethodHandle getOfSegmentsUnsafe() {
        try {
            return MethodHandles.privateLookupIn(UniformPath.class, MethodHandles.lookup()).findStatic(UniformPath.class, "ofSegmentsUnsafe", MethodType.methodType(UniformPath.class, UniformPath.EType.class, List.class));
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError("Method does not exist", e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("Cannot access method", e);
        }
    }

    private static UniformPath ofSegmentsUnsafe(UniformPath.EType type, List<String> a) throws StorageException {
        try {
            return OF_SEGMENTS_UNSAFE.invokeExact(type, a);
        }
        catch (Error | RuntimeException | StorageException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new AssertionError("Unexpected exception", e);
        }
    }

    public static UniformPathSerializer select(IStore store, boolean supportPrefixQueries, boolean supportRangeQueries) {
        Optional<IAbbreviationStoreCapability> abbreviationCapability = store.getCapability(IAbbreviationStoreCapability.class);
        if (supportRangeQueries || abbreviationCapability.isEmpty()) {
            return UniformPathSerializer.defaultSerializer(false);
        }
        IStorageAbbreviator abbreviator = abbreviationCapability.get().abbreviator();
        if (supportPrefixQueries) {
            return UniformPathSerializer.segmentAbbreviatingSerializer(abbreviator);
        }
        return UniformPathSerializer.fullAbbreviatingSerializer(abbreviator);
    }

    public static UniformPathSerializer defaultSerializer(boolean supportIncompletePaths) {
        return new DefaultUniformPathSerializer(supportIncompletePaths);
    }

    public static UniformPathSerializer segmentAbbreviatingSerializer(IStorageAbbreviator abbreviator) {
        return new SegmentAbbreviatingUniformPathSerializer(abbreviator);
    }

    public static UniformPathSerializer fullAbbreviatingSerializer(IStorageAbbreviator abbreviator) {
        return new FullAbbreviatingUniformPathSerializer(abbreviator);
    }

    public static UniformPathSerializer stringLikeSerializer() {
        return new StringLikeUniformPathSerializer();
    }

    public abstract boolean supportsRangeQueries();

    public abstract boolean supportsPrefixQueries();

    public abstract boolean matchesIncompletePaths();

    public boolean distinguishesCodePaths() {
        return true;
    }

    public abstract String toString();

    private static byte[] serializeType(UniformPath.EType type) {
        return new byte[]{(byte)type.ordinal()};
    }

    private static UniformPath.EType deserializeType(byte[] value) {
        return UniformPath.EType.valueOf((int)value[0]);
    }

    private static final class DefaultUniformPathSerializer
    extends UniformPathSerializer {
        private static final byte[] SEPARATOR = new byte[]{0};
        private final boolean supportIncompletePaths;

        public DefaultUniformPathSerializer(boolean supportIncompletePaths) {
            this.supportIncompletePaths = supportIncompletePaths;
        }

        @Override
        public byte @NonNull [] serialize(@NonNull UniformPath value) {
            ArrayList<byte[]> parts = new ArrayList<byte[]>();
            parts.add(UniformPathSerializer.serializeType(value.getType()));
            for (String segment : value.getPathSegments()) {
                parts.add(SEPARATOR);
                parts.add(StringUtils.stringToBytes((String)segment));
            }
            if (!this.supportIncompletePaths) {
                parts.add(SEPARATOR);
            }
            return ByteArrayUtils.concat(parts);
        }

        @Override
        public @NonNull UniformPath deserialize(byte @NonNull [] value) {
            UniformPath.EType type = UniformPathSerializer.deserializeType(value);
            ArrayList<String> segments = new ArrayList<String>();
            int offset = 2;
            while (offset < value.length) {
                int endIndex = ByteArrayUtils.indexOf((byte[])SEPARATOR, (byte[])value, (int)offset);
                if (endIndex < 0) {
                    CCSMAssert.isTrue((boolean)this.supportIncompletePaths, (String)"Did not find separator");
                    endIndex = value.length;
                }
                segments.add(StringUtils.bytesToString((byte[])value, (int)offset, (int)(endIndex - offset)));
                offset = endIndex + 1;
            }
            return UniformPath.ofSegments((UniformPath.EType)type, segments);
        }

        @Override
        public boolean supportsRangeQueries() {
            return true;
        }

        @Override
        public boolean supportsPrefixQueries() {
            return true;
        }

        @Override
        public boolean matchesIncompletePaths() {
            return this.supportIncompletePaths;
        }

        @Override
        public String toString() {
            return "DefaultUniformPathSerializer(" + this.supportIncompletePaths + ")";
        }
    }

    private static final class SegmentAbbreviatingUniformPathSerializer
    extends UniformPathSerializer {
        private final IStorageAbbreviator abbreviator;

        private SegmentAbbreviatingUniformPathSerializer(IStorageAbbreviator abbreviator) {
            this.abbreviator = Objects.requireNonNull(abbreviator, "abbreviator");
        }

        @Override
        public byte @NonNull [] serialize(@NonNull UniformPath uniformPath) throws StorageException {
            ArrayList<byte[]> parts = new ArrayList<byte[]>(2);
            parts.add(UniformPathSerializer.serializeType(uniformPath.getType()));
            parts.add(this.abbreviator.abbreviateAll((Collection<String>)uniformPath.getPathSegments()).toByteArray());
            return ByteArrayUtils.concat(parts);
        }

        @Override
        public @NonNull UniformPath deserialize(byte @NonNull [] value) throws StorageException {
            UniformPath.EType type = UniformPathSerializer.deserializeType(value);
            StorageAbbreviationList segments = StorageAbbreviationList.readFrom(value, 1);
            return UniformPathSerializer.ofSegmentsUnsafe(type, this.abbreviator.unabbreviateAll(segments));
        }

        @Override
        public boolean supportsRangeQueries() {
            return false;
        }

        @Override
        public boolean supportsPrefixQueries() {
            return true;
        }

        @Override
        public boolean matchesIncompletePaths() {
            return false;
        }

        @Override
        public String toString() {
            return "SegmentAbbreviatingUniformPathSerializer";
        }
    }

    private static final class FullAbbreviatingUniformPathSerializer
    extends UniformPathSerializer {
        private final IStorageAbbreviator abbreviator;

        public FullAbbreviatingUniformPathSerializer(IStorageAbbreviator abbreviator) {
            this.abbreviator = Objects.requireNonNull(abbreviator, "abbreviator");
        }

        @Override
        public byte @NonNull [] serialize(@NonNull UniformPath value) throws StorageException {
            return ByteArrayUtils.concat((byte[][])new byte[][]{UniformPathSerializer.serializeType(value.getType()), this.abbreviator.abbreviate(value.getPathSegmentsString()).toByteArray()});
        }

        @Override
        public @NonNull List<byte[]> serialize(Collection<@NonNull UniformPath> values) throws StorageException {
            StorageAbbreviationList pathSegmentsAbbreviated = this.abbreviator.abbreviateAll(CollectionUtils.map(values, UniformPath::getPathSegmentsString));
            int index = 0;
            ArrayList<byte[]> result = new ArrayList<byte[]>(values.size());
            for (UniformPath value : values) {
                StorageAbbreviation pathAbbreviated = (StorageAbbreviation)pathSegmentsAbbreviated.get(index);
                result.add(ByteArrayUtils.concat((byte[][])new byte[][]{UniformPathSerializer.serializeType(value.getType()), pathAbbreviated.toByteArray()}));
                ++index;
            }
            return result;
        }

        @Override
        public @NonNull UniformPath deserialize(byte @NonNull [] value) throws StorageException {
            UniformPath.EType type = UniformPathSerializer.deserializeType(value);
            String pathString = this.abbreviator.unabbreviate(StorageAbbreviation.readFrom(value, 1));
            return FullAbbreviatingUniformPathSerializer.parse(type, pathString);
        }

        @Override
        public @NonNull List<@NonNull UniformPath> deserialize(List<byte @NonNull []> values) throws StorageException {
            List types = CollectionUtils.map(values, UniformPathSerializer::deserializeType);
            List abbreviatedPathStrings = CollectionUtils.map(values, value -> StorageAbbreviation.readFrom(value, 1));
            List<String> unnabbreviatedPathStrings = this.abbreviator.unabbreviateAll(abbreviatedPathStrings);
            ArrayList<@NonNull UniformPath> result = new ArrayList<UniformPath>();
            for (Pair entry : CollectionUtils.zip((Iterable)types, unnabbreviatedPathStrings)) {
                result.add(FullAbbreviatingUniformPathSerializer.parse((UniformPath.EType)entry.getFirst(), (String)entry.getSecond()));
            }
            return result;
        }

        private static UniformPath parse(UniformPath.EType type, String pathString) throws StorageException {
            if (pathString.isEmpty()) {
                return UniformPath.root((UniformPath.EType)type);
            }
            return UniformPathSerializer.ofSegmentsUnsafe(type, Arrays.asList(UniformPathUtils.splitPath((String)pathString)));
        }

        @Override
        public boolean supportsRangeQueries() {
            return false;
        }

        @Override
        public boolean supportsPrefixQueries() {
            return false;
        }

        @Override
        public boolean matchesIncompletePaths() {
            return false;
        }

        @Override
        public String toString() {
            return "FullAbbreviatingUniformPathSerializer";
        }
    }

    private static final class StringLikeUniformPathSerializer
    extends UniformPathSerializer {
        private static final ISerializer<String, byte[]> DELEGATE = ISerializer.forString();

        private StringLikeUniformPathSerializer() {
        }

        @Override
        public byte @NonNull [] serialize(@NonNull UniformPath value) throws StorageException {
            return DELEGATE.serialize(value.toString());
        }

        @Override
        public @NonNull UniformPath deserialize(byte @NonNull [] value) throws StorageException {
            return UniformPath.parse((String)DELEGATE.deserialize(value));
        }

        @Override
        public boolean supportsRangeQueries() {
            return true;
        }

        @Override
        public boolean supportsPrefixQueries() {
            return true;
        }

        @Override
        public boolean matchesIncompletePaths() {
            return true;
        }

        @Override
        public boolean distinguishesCodePaths() {
            return false;
        }

        @Override
        public String toString() {
            return "StringLikeUniformPathSerializer";
        }
    }
}

