/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed.query.tree;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.tree.ICompilationContext;
import org.conqat.engine.persistence.index.keyed.query.tree.IQuery;
import org.conqat.engine.persistence.index.keyed.query.tree.ISubQueryComputer;

public class InStateQuery
implements IQuery {
    private final IQuery subQuery;
    private final long inStateMillis;

    public InStateQuery(IQuery query, long inStateMillis) {
        this.subQuery = query;
        this.inStateMillis = inStateMillis;
    }

    public String toString() {
        return "inState(" + String.valueOf(this.subQuery) + ") >= " + this.inStateMillis + "ms";
    }

    @Override
    public <T> Predicate<T> compile(ICompilationContext<T> context) throws QueryCompilationException {
        Predicate<T> subPredicate = this.subQuery.compile(context);
        InStateSubQueryComputer<T> subQueryComputer = new InStateSubQueryComputer<T>(subPredicate, this.inStateMillis);
        context.addPostChangeEvaluationOffset(this.inStateMillis);
        context.addSubQueryComputer(subQueryComputer);
        return subQueryComputer::evaluate;
    }

    private static class InStateSubQueryComputer<T>
    implements ISubQueryComputer<T> {
        private final Predicate<T> subQuery;
        private final Map<T, InStateData> data = new IdentityHashMap<T, InStateData>();
        private final long timestampThreshold;

        public InStateSubQueryComputer(Predicate<T> subQuery, long timestampThreshold) {
            this.subQuery = subQuery;
            this.timestampThreshold = timestampThreshold;
        }

        @Override
        public void updateState(T object, long timestamp) {
            this.data.computeIfAbsent(object, x -> new InStateData()).updateState(this.subQuery.test(object), timestamp, this.timestampThreshold);
        }

        public boolean evaluate(T object) {
            return this.data.computeIfAbsent(object, x -> new InStateData()).getEvaluationResult();
        }
    }

    private static class InStateData {
        private boolean lastValue;
        private long lastTimestamp = -1L;
        private boolean evaluationResult = false;

        private InStateData() {
        }

        public boolean getEvaluationResult() {
            return this.evaluationResult;
        }

        public void updateState(boolean currentValue, long timestamp, long timestampThreshold) {
            if (this.lastTimestamp < 0L || this.lastValue != currentValue) {
                this.lastTimestamp = timestamp;
                this.lastValue = currentValue;
            }
            this.evaluationResult = this.lastValue && timestamp - this.lastTimestamp >= timestampThreshold;
        }
    }
}

