/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.schema;

import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.conqat.engine.persistence.cache.StorageCacheConfiguration;
import org.conqat.engine.persistence.cache.StorageCacheProvider;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.IProjectIndexWithDynamicName;
import org.conqat.engine.persistence.index.IStorageIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexCreator;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.index.schema.IStoreDecorator;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.index.schema.IndexSchemaCache;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.DelegatingStorageSystemBase;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.function.FunctionWithException;
import org.jspecify.annotations.Nullable;

public class SchemaAwareStorageSystem
extends DelegatingStorageSystemBase {
    private final IndexSchema schema;
    protected final StorageCacheConfiguration cacheConfiguration;
    private final ConcurrentHashMap<ImmutablePair<String, HistoryAccessOption>, IStorageIndex> indexCache = new ConcurrentHashMap();
    private final IndexCreator indexCreator;

    public SchemaAwareStorageSystem(IStorageSystem storageSystem, StorageCacheProvider.StorageSystemCacheProvider storageSystemCacheProvider) throws StorageException {
        this(storageSystem, IndexSchema.load(storageSystem, storageSystemCacheProvider.getCacheAccess(IndexSchemaCache.class)), storageSystemCacheProvider);
    }

    public SchemaAwareStorageSystem(IStorageSystem storageSystem, StorageCacheProvider.StorageSystemCacheProvider storageSystemCacheProvider, StorageCacheConfiguration cacheConfiguration) throws StorageException {
        this(storageSystem, IndexSchema.load(storageSystem, storageSystemCacheProvider.getCacheAccess(IndexSchemaCache.class)), storageSystemCacheProvider, cacheConfiguration);
    }

    public SchemaAwareStorageSystem(IStorageSystem storageSystem, IndexSchema schema, StorageCacheProvider.StorageSystemCacheProvider storageSystemCacheProvider) {
        this(storageSystem, schema, storageSystemCacheProvider, StorageCacheConfiguration.NO_CACHING);
    }

    public SchemaAwareStorageSystem(IStorageSystem storageSystem, IndexSchema schema, StorageCacheProvider.StorageSystemCacheProvider storageSystemCacheProvider, StorageCacheConfiguration cacheConfiguration) {
        super(storageSystem);
        this.schema = schema;
        this.cacheConfiguration = cacheConfiguration;
        this.indexCreator = new IndexCreator(storageSystemCacheProvider);
    }

    public IndexSchema getSchema() {
        return this.schema;
    }

    public <T extends IProjectIndex> boolean hasIndex(Class<T> indexClass) {
        return this.hasIndex(IStorageIndex.getIndexAnnotation(indexClass).name());
    }

    public boolean hasIndex(String name) {
        return this.schema.getEntry(name) != null;
    }

    public <T extends IStorageIndex> T openIndex(Class<T> indexClass, @Nullable String indexName, @Nullable HistoryAccessOption historyAccessOption, @Nullable FunctionWithException<String, IStore, StorageException> virtualStoreResolver, @Nullable IStoreDecorator decorator) throws StorageException {
        Index indexAnnotation = IStorageIndex.getIndexAnnotation(indexClass);
        boolean virtual = Arrays.stream(indexAnnotation.options()).anyMatch(option -> option == EStorageOption.VIRTUAL);
        String resolvedIndexName = Optional.ofNullable(indexName).orElse(indexAnnotation.name());
        boolean shouldCacheIndexes = this.cacheConfiguration.cacheIndices();
        Object index = shouldCacheIndexes && !virtual ? (IStorageIndex)indexClass.cast(CollectionUtils.computeIfAbsentWithException(this.indexCache, (Object)new ImmutablePair((Object)resolvedIndexName, (Object)historyAccessOption), p -> this.openIndexUnsynchronized(indexClass, indexName, (HistoryAccessOption)p.getSecond(), virtualStoreResolver, decorator, (String)p.getFirst()))) : this.openIndexUnsynchronized(indexClass, indexName, historyAccessOption, virtualStoreResolver, decorator, resolvedIndexName);
        return index;
    }

    private <T extends IStorageIndex> T openIndexUnsynchronized(Class<T> indexClass, @Nullable String indexName, @Nullable HistoryAccessOption historyAccessOption, @Nullable FunctionWithException<String, IStore, StorageException> virtualStoreResolver, @Nullable IStoreDecorator decorator, String resolvedIndexName) throws StorageException {
        T index = this.schema.openIndex(indexClass, resolvedIndexName, this.delegateStorageSystem, this.indexCreator, historyAccessOption, virtualStoreResolver, decorator);
        if (index instanceof IProjectIndexWithDynamicName && indexName != null) {
            ((IProjectIndexWithDynamicName)index).setName(indexName);
        }
        return index;
    }

    public <T extends IStorageIndex> T openIndex(Class<T> indexClass, @Nullable String indexName, @Nullable HistoryAccessOption historyAccessOption, @Nullable IStoreDecorator decorator) throws StorageException {
        return this.openIndex(indexClass, indexName, historyAccessOption, null, decorator);
    }

    public <T extends IStorageIndex> T openIndex(Class<T> indexClass, String indexName) throws StorageException {
        return this.openIndex(indexClass, indexName, null, null, null);
    }

    public <T extends IStorageIndex> T openIndex(Class<T> indexClass) throws StorageException {
        return this.openIndex(indexClass, null, null, null, null);
    }

    public IStore openStoreChecked(String name, Class<? extends IStorageIndex> indexClass, IStorageSystem storageSystem, boolean rawAccess, @Nullable HistoryAccessOption historyAccessOption) throws StorageException {
        return this.schema.openStoreChecked(indexClass, name, storageSystem, rawAccess, historyAccessOption, null, null);
    }

    public IBranchingLayer openBranchingLayer(String storeName, Class<? extends IStorageIndex> indexClass) throws StorageException {
        return this.schema.openBranchingLayer(indexClass, storeName, this);
    }

    public IBranchingLayer openBranchingLayer(Class<? extends IStorageIndex> indexClass) throws StorageException {
        Index indexAnnotation = IStorageIndex.getIndexAnnotation(indexClass);
        return this.openBranchingLayer(indexAnnotation.name(), indexClass);
    }
}

