/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.branched;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.function.BiConsumer;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.StoreBase;
import org.conqat.engine.persistence.store.branched.CommitLayerMerger;
import org.conqat.engine.persistence.store.branched.CommitLayeringBranchingLayer;
import org.conqat.engine.persistence.store.branched.IBranchCommitInfo;
import org.conqat.engine.persistence.store.branched.ICommitLayeringDataLayout;
import org.conqat.engine.persistence.store.branched.IHashingStore;
import org.conqat.engine.persistence.store.capability.IStoreCapability;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class BranchCommitReadingStore
extends StoreBase
implements IHashingStore {
    private static final HashFunction HASHER = Hashing.goodFastHash((int)128);
    protected static final int DATA_REFERENCE_HASH_LENGTH = 20;
    static final byte[] TOMB_STONE_MARKER = new byte[]{-1};
    protected final IStore store;
    protected final ICommitLayeringDataLayout dataLayout;
    protected List<byte[]> commitNamesForDataKeys;

    protected BranchCommitReadingStore(IStore delegate, ICommitLayeringDataLayout dataLayout) {
        this.store = delegate;
        this.dataLayout = dataLayout;
    }

    public BranchCommitReadingStore(IStore delegate, ICommitLayeringDataLayout dataLayout, byte[] commitName) throws StorageException {
        this(delegate, dataLayout);
        this.commitNamesForDataKeys = this.determineDeltaHierarchyCommitNames(commitName);
    }

    protected List<byte[]> determineDeltaHierarchyCommitNames(byte[] commitName) throws StorageException {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        while (commitName != null) {
            IBranchCommitInfo commit = this.readCommit(commitName);
            if (commit == null) {
                throw new StorageException("Inconsistent store: commit with name " + BranchCommitReadingStore.formatCommitName(commitName) + " could not be read!");
            }
            result.add(commit.getCommitNameForDataKeys());
            if (commit.getAllDeltaPredecessorCommitNamesForDataKeys() != null) {
                result.addAll(Arrays.asList(commit.getAllDeltaPredecessorCommitNamesForDataKeys()));
                break;
            }
            commitName = commit.getDeltaPredecessorCommitName();
        }
        return result;
    }

    protected IBranchCommitInfo readCommit(byte[] commitName) throws StorageException {
        if (commitName == null) {
            return null;
        }
        byte[] commitInfoKey = this.dataLayout.createCommitInfoKey(commitName);
        return this.dataLayout.deserializeCommitInfo(this.store.get(commitInfoKey));
    }

    protected static String formatCommitName(byte[] commitName) {
        return StringUtils.bytesToString((byte[])commitName) + " (" + StringUtils.encodeAsHex((byte[])commitName) + ")";
    }

    @Override
    public byte @Nullable [] get(byte @NonNull [] key) throws StorageException {
        for (byte[] commitName : this.commitNamesForDataKeys) {
            BranchCommitReadingStore.throwIfKeyIsNull(key);
            byte[] value = this.store.get(this.dataLayout.createCommitEntryKey(commitName, key));
            if (BranchCommitReadingStore.isTombStone(value)) {
                return null;
            }
            if (value == null) continue;
            return BranchCommitReadingStore.resolveDataReference(value, this.store, this.dataLayout);
        }
        return null;
    }

    @Override
    public HashCode getHash(byte[] key) throws StorageException {
        for (byte[] commitName : this.commitNamesForDataKeys) {
            byte[] value = this.store.get(this.dataLayout.createCommitEntryKey(commitName, key));
            if (BranchCommitReadingStore.isTombStone(value)) {
                return IHashingStore.NULL;
            }
            if (value == null) continue;
            if (BranchCommitReadingStore.isActualValueOrTombStone(value)) {
                return HASHER.hashBytes(value);
            }
            return HashCode.fromBytes((byte[])value);
        }
        return IHashingStore.NULL;
    }

    public static byte[] resolveDataReference(byte[] value, IStore store, ICommitLayeringDataLayout dataLayout) throws StorageException {
        if (BranchCommitReadingStore.isActualValueOrTombStone(value)) {
            return value;
        }
        byte[] referencedValue = store.get(dataLayout.createDataKey(value));
        if (referencedValue == null) {
            BranchCommitReadingStore.throwMissingDeduplicationException(value);
        }
        return referencedValue;
    }

    private static void throwMissingDeduplicationException(byte[] value) throws StorageException {
        throw new StorageException("Corrupt branching store, data for reference " + StringUtils.encodeAsHex((byte[])value) + " not found!");
    }

    @Override
    public List<byte[]> get(List<byte @NonNull []> keys) throws StorageException {
        ArrayList<Object> result = new ArrayList<Object>(Collections.nCopies(keys.size(), null));
        ArrayList<Integer> deduplicationIndexes = new ArrayList<Integer>();
        this.getMultipleEntries(keys, (keyIndex, value) -> {
            if (((byte[])value).length == 20) {
                deduplicationIndexes.add((Integer)keyIndex);
            }
            result.set((int)keyIndex, value);
        });
        this.batchDeduplicate(result, deduplicationIndexes);
        return result;
    }

    @Override
    public List<HashCode> getHash(List<byte[]> keys) throws StorageException {
        ArrayList<HashCode> result = new ArrayList<HashCode>(Collections.nCopies(keys.size(), IHashingStore.NULL));
        this.getMultipleEntries(keys, (keyIndex, value) -> {
            if (BranchCommitReadingStore.isActualValueOrTombStone(value)) {
                result.set((int)keyIndex, HASHER.hashBytes(value));
            } else {
                result.set((int)keyIndex, HashCode.fromBytes((byte[])value));
            }
        });
        return result;
    }

    private void getMultipleEntries(List<byte @NonNull []> keys, BiConsumer<Integer, byte[]> valueCallback) throws StorageException {
        ArrayList<Integer> keyIndexes = new ArrayList<Integer>(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            keyIndexes.add(i);
        }
        List<byte[]> remainingKeys = keys;
        for (byte[] commitName : this.commitNamesForDataKeys) {
            if (remainingKeys.isEmpty()) break;
            List<byte[]> values = this.store.get(CollectionUtils.mapWithException(remainingKeys, key -> {
                BranchCommitReadingStore.throwIfKeyIsNull(key);
                return this.dataLayout.createCommitEntryKey(commitName, (byte[])key);
            }));
            ArrayList<byte[]> newRemainingKeys = new ArrayList<byte[]>();
            ArrayList<Integer> newKeyIndexes = new ArrayList<Integer>();
            for (int i = 0; i < remainingKeys.size(); ++i) {
                byte[] value = values.get(i);
                if (BranchCommitReadingStore.isTombStone(value)) continue;
                if (value != null) {
                    valueCallback.accept((Integer)keyIndexes.get(i), value);
                    continue;
                }
                newRemainingKeys.add(remainingKeys.get(i));
                newKeyIndexes.add((Integer)keyIndexes.get(i));
            }
            remainingKeys = newRemainingKeys;
            keyIndexes = newKeyIndexes;
        }
    }

    @Override
    public @NonNull HashCode calculateHash(byte[] value) {
        if (value == null) {
            return IHashingStore.NULL;
        }
        if (BranchCommitReadingStore.isActualValueOrTombStone(value)) {
            return HASHER.hashBytes(value);
        }
        byte[] referenceKey = CommitLayeringBranchingLayer.createReferenceKey(value);
        return HashCode.fromBytes((byte[])referenceKey);
    }

    private void batchDeduplicate(List<byte[]> data, List<Integer> deduplicationIndexes) throws StorageException {
        if (deduplicationIndexes.isEmpty()) {
            return;
        }
        List<byte[]> deduplicatedValues = this.store.get(CollectionUtils.map(deduplicationIndexes, index -> this.dataLayout.createDataKey((byte[])data.get((int)index))));
        for (int i = 0; i < deduplicationIndexes.size(); ++i) {
            if (deduplicatedValues.get(i) == null) {
                BranchCommitReadingStore.throwMissingDeduplicationException(data.get(deduplicationIndexes.get(i)));
            }
            data.set(deduplicationIndexes.get(i), deduplicatedValues.get(i));
        }
    }

    private void batchDeduplicateForCommitLayerMergers(List<CommitLayerMerger> commitLayerMergers) throws StorageException {
        ArrayList<byte[]> dataKeys = new ArrayList<byte[]>();
        for (CommitLayerMerger commitLayerMerger : commitLayerMergers) {
            for (Integer valueIndex : commitLayerMerger.getValueIndexesThatNeedDeduplication()) {
                dataKeys.add(this.dataLayout.createDataKey(commitLayerMerger.getValue(valueIndex)));
            }
        }
        if (dataKeys.isEmpty()) {
            return;
        }
        List<byte[]> deduplicatedValues = this.store.get(dataKeys);
        int i = 0;
        for (CommitLayerMerger commitLayerMerger : commitLayerMergers) {
            for (Integer valueIndex : commitLayerMerger.getValueIndexesThatNeedDeduplication()) {
                if (deduplicatedValues.get(i) == null) {
                    BranchCommitReadingStore.throwMissingDeduplicationException(commitLayerMerger.getValue(valueIndex));
                }
                commitLayerMerger.setValue(valueIndex, deduplicatedValues.get(i));
                ++i;
            }
        }
    }

    @Override
    public void put(byte @NonNull [] key, byte @NonNull [] value) throws StorageException {
        throw new StorageException("This is a read-only store!");
    }

    @Override
    public void put(PairList<byte @NonNull [], byte @NonNull []> keysValues) throws StorageException {
        throw new StorageException("This is a read-only store!");
    }

    @Override
    public void remove(byte @NonNull [] key) throws StorageException {
        throw new StorageException("This is a read-only store!");
    }

    @Override
    public void remove(List<byte @NonNull []> keys) throws StorageException {
        throw new StorageException("This is a read-only store!");
    }

    @Override
    public void scan(byte @NonNull [] beginKey, byte @Nullable [] endKey, IKeyValueCallback callback) throws StorageException {
        this.scanKeysValues(beginKey, endKey, callback, true);
    }

    @Override
    public void scanKeys(byte @Nullable [] beginKey, byte @Nullable [] endKey, IKeyValueCallback callback) throws StorageException {
        this.scanKeysValues(beginKey, endKey, callback, false);
    }

    private void scanKeysValues(byte[] beginKey, byte[] endKey, IKeyValueCallback callback, boolean includeValue) throws StorageException {
        CommitLayerMerger commitLayerMerger = new CommitLayerMerger(this.commitNamesForDataKeys.size(), includeValue);
        for (int i = 0; i < this.commitNamesForDataKeys.size(); ++i) {
            int commitIndex = i;
            byte[] commitName = this.commitNamesForDataKeys.get(i);
            int offset = this.dataLayout.determineKeyOffset(commitName);
            this.store.scan(this.determineExtendedBeginKey(beginKey, commitName), this.determineExtendedEndKey(endKey, commitName), (key, value) -> {
                key = Arrays.copyOfRange(key, offset, key.length);
                commitLayerMerger.appendEntry(commitIndex, key, value);
            });
        }
        commitLayerMerger.flush();
        this.batchDeduplicateForCommitLayerMergers(List.of(commitLayerMerger));
        commitLayerMerger.invokeCallback(callback);
    }

    @Override
    public void scan(List<byte @NonNull []> prefixes, List<? extends IKeyValueCallback> callbacks) throws StorageException {
        this.scanKeysValues(prefixes, callbacks, true);
    }

    @Override
    public void scanKeys(List<byte @NonNull []> prefixes, List<? extends IKeyValueCallback> callbacks) throws StorageException {
        this.scanKeysValues(prefixes, callbacks, false);
    }

    private void scanKeysValues(List<byte[]> prefixes, List<? extends IKeyValueCallback> callbacks, boolean includeValue) throws StorageException {
        ArrayList<byte[]> extendedPrefixes = new ArrayList<byte[]>();
        ArrayList<IKeyValueCallback> extendedCallbacks = new ArrayList<IKeyValueCallback>();
        ArrayList<CommitLayerMerger> commitLayerMergers = new ArrayList<CommitLayerMerger>();
        for (byte[] prefix : prefixes) {
            CommitLayerMerger commitLayerMerger = new CommitLayerMerger(this.commitNamesForDataKeys.size(), includeValue);
            commitLayerMergers.add(commitLayerMerger);
            int i = 0;
            while (i < this.commitNamesForDataKeys.size()) {
                byte[] commitName = this.commitNamesForDataKeys.get(i);
                extendedPrefixes.add(this.determineExtendedBeginKey(prefix, commitName));
                int offset = this.dataLayout.determineKeyOffset(commitName);
                int commitIndex = i++;
                extendedCallbacks.add((key, value) -> {
                    key = Arrays.copyOfRange(key, offset, key.length);
                    commitLayerMerger.appendEntry(commitIndex, key, value);
                });
            }
        }
        this.store.scan(extendedPrefixes, extendedCallbacks);
        for (CommitLayerMerger commitLayerMerger : commitLayerMergers) {
            commitLayerMerger.flush();
        }
        this.batchDeduplicateForCommitLayerMergers(commitLayerMergers);
        for (int i = 0; i < commitLayerMergers.size(); ++i) {
            ((CommitLayerMerger)commitLayerMergers.get(i)).invokeCallback(callbacks.get(i));
        }
    }

    private byte[] determineExtendedBeginKey(byte[] beginKey, byte[] commitName) {
        byte[] extendedBeginKey = beginKey == null ? this.dataLayout.createCommitEntryKey(commitName, null) : this.dataLayout.createCommitEntryKey(commitName, beginKey);
        return extendedBeginKey;
    }

    private byte[] determineExtendedEndKey(byte[] endKey, byte[] commitName) {
        byte[] extendedEndKey = endKey == null ? BranchCommitReadingStore.generateEndKey(this.dataLayout.createCommitEntryKey(commitName, null)) : this.dataLayout.createCommitEntryKey(commitName, endKey);
        return extendedEndKey;
    }

    @Override
    public Lock obtainLock(String suffix) {
        return this.store.obtainLock(suffix);
    }

    @Override
    public <T extends IStoreCapability> Optional<T> getCapability(Class<T> capability) {
        return this.store.getCapability(capability);
    }

    public static boolean isTombStone(byte[] value) {
        return value != null && value.length == 1 && value[0] == TOMB_STONE_MARKER[0];
    }

    public static boolean isActualValueOrTombStone(byte[] value) {
        return value == null || value.length < 20;
    }
}

