/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.sharded;

import java.io.File;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.sharded.PatternBasedShardingStrategy;
import org.conqat.engine.persistence.store.sharded.RandomizedShardingStrategy;
import org.conqat.lib.commons.function.FunctionWithException;

public interface IShardingStrategy {
    public int getShardCount();

    public File getShardDirectory(int var1);

    public int getShardIndexForStorageSystemName(String var1) throws StorageException;

    public static IShardingStrategy parse(String descriptor, File baseDirectory, FunctionWithException<String, List<String>, StorageException> storageSystemNamePreAdjuster) throws StorageException {
        String[] parts = descriptor.split(":", 2);
        if (parts[0].equalsIgnoreCase("randomized")) {
            return new RandomizedShardingStrategy(Integer.parseInt(parts[1]), baseDirectory);
        }
        if (parts[0].equalsIgnoreCase("pattern")) {
            return PatternBasedShardingStrategy.parse(parts[1], baseDirectory, storageSystemNamePreAdjuster);
        }
        throw new StorageException("Unknown sharding strategy: " + parts[0]);
    }
}

