/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.swift.platformconditions;

import eu.cqse.check.framework.preprocessor.swift.platformconditions.IEvaluableConditionValue;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.ParseException;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.PlatformConditionBase;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.PlatformConditionParseResult;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.Version;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.framework.util.tokens.TokenStream;
import java.util.Optional;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

class VersionPlatformCondition
extends PlatformConditionBase {
    private static final TokenPattern VALUE_PARSE_PATTERN = new TokenPattern().sequence(ETokenType.LPAREN).alternative(ETokenType.GTEQ, ETokenType.LT).group(0).skipUntil(ETokenType.RPAREN).group(1).sequence(ETokenType.RPAREN);

    public VersionPlatformCondition(@NonNull String name) {
        super(name);
    }

    @Override
    public @NonNull VersionPlatformCondition copyWithName(@NonNull String newName) {
        return new VersionPlatformCondition(newName);
    }

    @Override
    public @NonNull PlatformConditionParseResult parse(@NonNull TokenStream tokenStream) throws ParseException {
        PlatformConditionBase.GenericParseResult genericParseResult = this.parseGeneric(tokenStream);
        TokenPatternMatch valueMatch = VALUE_PARSE_PATTERN.matchFully(genericParseResult.valueTokens());
        VersionPlatformCondition.verifyMatch(tokenStream, valueMatch, 0, 1);
        ETokenType qualifierType = valueMatch.groupTokens(0).get(0).getType();
        boolean isLargerEqual = switch (qualifierType) {
            case ETokenType.GTEQ -> true;
            case ETokenType.LT -> false;
            default -> throw new ParseException("Version parse failed due to invalid comparison operator '%s' at: %s".formatted(qualifierType, tokenStream.peekCurrent()));
        };
        String versionString = TokenStreamTextUtils.concatTokenTexts(valueMatch.groupTokens(1));
        Version version = Version.parse(versionString).orElseThrow(() -> new ParseException("Version parse of '%s' failed at: %s".formatted(versionString, tokenStream.peekCurrent())));
        tokenStream.advancePosition(genericParseResult.tokenCount());
        return new PlatformConditionParseResult(this, new Value(isLargerEqual, version));
    }

    @Override
    public @NonNull Object parseConfig(@NonNull String configValue) throws ParseException {
        if (StringUtils.isEmpty((String)configValue)) {
            throw new ParseException("Empty configuration value");
        }
        return Version.parse(configValue).orElseThrow(() -> new ParseException("Cannot parse version '%s' from configuration".formatted(configValue)));
    }

    @Override
    public String toString() {
        return "VersionPlatformCondition{name='" + this.name + "'}";
    }

    static class Value
    implements IEvaluableConditionValue {
        private final boolean isLargerEqual;
        private final Version version;

        private Value(boolean isLargerEqual, @NonNull Version version) {
            this.isLargerEqual = isLargerEqual;
            this.version = version;
        }

        @Override
        public Optional<Boolean> evaluate(@NonNull Object configValue) {
            if (!(configValue instanceof Version)) {
                return Optional.empty();
            }
            Version otherVersion = (Version)configValue;
            if (this.isLargerEqual) {
                return Optional.of(otherVersion.isGreaterOrEqual(this.version));
            }
            return Optional.of(otherVersion.isLess(this.version));
        }

        public String toString() {
            return (this.isLargerEqual ? ">=" : "<") + String.valueOf(this.version);
        }
    }
}

