/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.framework;

import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ConcatenatingNameResolver;
import eu.cqse.check.framework.shallowparser.framework.IndexNameResolver;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import eu.cqse.check.framework.shallowparser.framework.RegionNameResolver;
import eu.cqse.check.framework.shallowparser.framework.StringNameResolver;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.region.Region;

public interface INameResolver {
    public String resolveName(ParserState<?> var1, List<IToken> var2, int var3, boolean var4);

    public static INameResolver concat(INameResolver ... further) {
        return INameResolver.concat(Arrays.asList(further));
    }

    public static INameResolver noName() {
        return (state, tokens, startOffset, extractStringContent) -> null;
    }

    public static INameResolver ofString(String name) {
        return new StringNameResolver(name);
    }

    public static INameResolver firstMatchedTokenText() {
        return INameResolver.ofIndex(0);
    }

    public static INameResolver secondMatchedTokenText() {
        return INameResolver.ofIndex(1);
    }

    public static INameResolver previousTokenText() {
        return INameResolver.ofIndex(-1);
    }

    public static INameResolver ofIndices(int ... indices) {
        return INameResolver.concat(Arrays.stream(indices).mapToObj(INameResolver::ofIndex).toList());
    }

    public static INameResolver ofIndex(int index) {
        return IndexNameResolver.of(index);
    }

    public static INameResolver ofRange(int start, int end) {
        return INameResolver.ofRegion(new Region(start, end));
    }

    public static INameResolver ofRange(int start, int end, String origin) {
        return INameResolver.ofRegion(new Region(start, end, origin));
    }

    public static INameResolver ofRegion(Region region) {
        return new RegionNameResolver(region);
    }

    public static INameResolver concat(Collection<? extends INameResolver> resolvers) {
        if (resolvers.size() == 1) {
            return resolvers.iterator().next();
        }
        return new ConcatenatingNameResolver(resolvers);
    }

    public static INameResolver matchStartTokenTypeName() {
        return (state, tokens, startOffset, extractStringContent) -> ((IToken)tokens.get(state.getCurrentMatchStart())).getType().name().toLowerCase();
    }
}

