/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.abap;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.languages.abap.AbapShallowParser;
import java.util.List;

class SingleSelectRecognizer
extends RecognizerBase<AbapShallowParser.EAbapParserStates> {
    private static final ITokenMatcher SELECT_TO_RESULTS_SKIP_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SINGLE, ETokenType.FOR, ETokenType.UPDATE, ETokenType.DISTINCT});
    private static final ITokenMatcher AGGREGATE_FUNCTIONS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.AUTO_CORR, ETokenType.AVG, ETokenType.CORR, ETokenType.CORR_SPEARMAN, ETokenType.COUNT, ETokenType.CROSS_CORR, ETokenType.DFT, ETokenType.FIRST_VALUE, ETokenType.LAST_VALUE, ETokenType.MAX, ETokenType.MEDIAN, ETokenType.MIN, ETokenType.NTH_VALUE, ETokenType.STDDEV, ETokenType.STDDEV_POP, ETokenType.STDDEV_SAMP, ETokenType.STRING_AGG, ETokenType.SUM, ETokenType.VAR, ETokenType.VAR_POP, ETokenType.VAR_SAMP});
    private static final ITokenMatcher AGGREGATE_TERMINATOR = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.FROM, ETokenType.INTO});

    SingleSelectRecognizer() {
    }

    @Override
    protected int matchesLocally(ParserState<AbapShallowParser.EAbapParserStates> parserState, List<IToken> tokens, int startOffset) {
        int dotOffset;
        for (dotOffset = startOffset; dotOffset < tokens.size() && tokens.get(dotOffset).getType() != ETokenType.DOT; ++dotOffset) {
        }
        if (dotOffset >= tokens.size()) {
            return -1;
        }
        int matchSingleSelect = dotOffset + 1;
        if (!SingleSelectRecognizer.hasIntoAppendingTable(tokens, startOffset, dotOffset)) {
            if (SingleSelectRecognizer.isSingle(tokens, startOffset) || SingleSelectRecognizer.hasOnlyAggregateFunctions(tokens, startOffset, dotOffset) && !SingleSelectRecognizer.hasGroupBy(tokens, startOffset, dotOffset)) {
                return matchSingleSelect;
            }
            return -1;
        }
        if (SingleSelectRecognizer.hasPackageSize(tokens, startOffset, dotOffset)) {
            return -1;
        }
        return matchSingleSelect;
    }

    private static boolean isSingle(List<IToken> tokens, int startOffset) {
        return tokens.get(startOffset).getType() == ETokenType.SINGLE;
    }

    private static boolean hasIntoAppendingTable(List<IToken> tokens, int startOffset, int endOffset) {
        return TokenStreamUtils.containsAny(tokens, startOffset, endOffset, ETokenType.INTO, ETokenType.APPENDING) && TokenStreamUtils.containsAny(tokens, startOffset, endOffset, ETokenType.TABLE);
    }

    private static boolean hasPackageSize(List<IToken> tokens, int startOffset, int endOffset) {
        return TokenStreamUtils.containsSequence(tokens, startOffset, endOffset, new ITokenMatcher[]{ETokenType.PACKAGE, ETokenType.SIZE});
    }

    private static boolean hasGroupBy(List<IToken> tokens, int startOffset, int endOffset) {
        return TokenStreamUtils.containsSequence(tokens, startOffset, endOffset, new ITokenMatcher[]{ETokenType.GROUP, ETokenType.BY});
    }

    private static boolean hasOnlyAggregateFunctions(List<IToken> tokens, int startOffset, int endOffset) {
        while (startOffset < endOffset && SELECT_TO_RESULTS_SKIP_TOKENS.matches(tokens.get(startOffset))) {
            ++startOffset;
        }
        while (startOffset < endOffset && !AGGREGATE_TERMINATOR.matches(tokens.get(startOffset))) {
            if (!AGGREGATE_FUNCTIONS.or(new ITokenMatcher[]{ETokenType.COMMA}).matches(tokens.get(startOffset))) {
                return false;
            }
            startOffset = SingleSelectRecognizer.skipAggregate(tokens, startOffset + 1, endOffset);
        }
        return true;
    }

    private static int skipAggregate(List<IToken> tokens, int startOffset, int endOffset) {
        if (startOffset >= endOffset || tokens.get(startOffset).getType() != ETokenType.LPAREN) {
            return startOffset;
        }
        int rparenPos = TokenStreamUtils.firstTokenMatching(tokens, startOffset, endOffset, (ITokenMatcher)ETokenType.RPAREN);
        if (rparenPos == -1) {
            return startOffset;
        }
        startOffset = rparenPos + 1;
        if (startOffset < endOffset && tokens.get(startOffset).getType() == ETokenType.AS) {
            startOffset += 2;
        }
        if (startOffset < endOffset && TokenStreamUtils.hasTokenTypeSequence(tokens, startOffset, ETokenType.UP, ETokenType.TO, ETokenType.INTEGER_LITERAL, ETokenType.ROWS)) {
            startOffset += 4;
        }
        return startOffset;
    }
}

