/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.cpp;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.regex.Pattern;

class UnexpandedMacroNameHeuristicMatcher
implements ITokenMatcher {
    private static final Pattern UPPERCASE_PATTERN = Pattern.compile("[_A-Z0-9]+");

    UnexpandedMacroNameHeuristicMatcher() {
    }

    public boolean matches(IToken token) {
        return token.getType() == ETokenType.IDENTIFIER && token.getText().length() > 3 && UPPERCASE_PATTERN.matcher(token.getText()).matches();
    }

    public static ITokenMatcher createUnexpandedMacroNameHeuristic() {
        return new UnexpandedMacroNameHeuristicMatcher();
    }

    public String humanReadable() {
        return "<uppercase identifier with at least 4 characters>";
    }
}

