/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.delphi;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowParserBase;

public class DelphiShallowParser
extends ShallowParserBase<EDelphiParserStates> {
    private static final ITokenMatcher TOP_LEVEL_KEYWORDS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IMPLEMENTATION, ETokenType.INTERFACE, ETokenType.BEGIN, ETokenType.FINALIZATION, ETokenType.INITIALIZATION});
    private static final EDelphiParserStates[] SECTION_STATES = new EDelphiParserStates[]{EDelphiParserStates.IN_INTERFACE, EDelphiParserStates.IN_IMPLEMENTATION};
    private static final ITokenMatcher TOP_LEVEL_OR_SECTION_KEYWORDS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PROGRAM, ETokenType.UNIT, ETokenType.INTERFACE, ETokenType.IMPLEMENTATION, ETokenType.TYPE, ETokenType.VAR, ETokenType.CONST, ETokenType.PROCEDURE, ETokenType.FUNCTION, ETokenType.BEGIN, ETokenType.END, ETokenType.INITIALIZATION, ETokenType.FINALIZATION});
    private static final ITokenMatcher METHOD_KEYWORDS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.FUNCTION, ETokenType.PROCEDURE, ETokenType.CONSTRUCTOR, ETokenType.DESTRUCTOR, ETokenType.OPERATOR});
    private static final ITokenMatcher SIMPLE_STATEMENT_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.INHERITED, ETokenType.INDEX, ETokenType.RAISE, ETokenType.EXIT, ETokenType.CONTINUE, ETokenType.BREAK, ETokenType.AT, ETokenType.WRITE, ETokenType.LPAREN, ETokenType.SELF, ETokenType.READ, ETokenType.DISPOSE, ETokenType.REFERENCE, ETokenType.NAME, ETokenType.NEW, ETokenType.ASM, ETokenType.OPERATOR, ETokenType.GOTO});
    private static final ITokenMatcher METHOD_MODIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ABSTRACT, ETokenType.CDECL, ETokenType.DYNAMIC, ETokenType.FORWARD, ETokenType.OVERLOAD, ETokenType.OVERRIDE, ETokenType.PASCAL, ETokenType.REGISTER, ETokenType.SAFECALL, ETokenType.STATIC, ETokenType.STDCALL, ETokenType.VARARGS, ETokenType.VIRTUAL});
    private static final ITokenMatcher ACCESS_MODIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PUBLIC, ETokenType.PROTECTED, ETokenType.PRIVATE, ETokenType.PUBLISHED});
    private static final ITokenMatcher CASE_LITERALS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.INTEGER_LITERAL, ETokenType.FLOATING_POINT_LITERAL, ETokenType.BOOLEAN_LITERAL, ETokenType.STRING_LITERAL, ETokenType.MINUS, ETokenType.PLUS});
    private static final ITokenMatcher TYPE_MEMBER_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.STRICT, ETokenType.CASE, ETokenType.CLASS, ETokenType.PROPERTY, ETokenType.IDENTIFIER, ETokenType.END}).or(new ITokenMatcher[]{ACCESS_MODIFIERS, METHOD_KEYWORDS});
    private static final ITokenMatcher METHOD_SECTION_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BEGIN, ETokenType.VAR, ETokenType.CONST, ETokenType.TYPE}).or(new ITokenMatcher[]{METHOD_KEYWORDS});

    public DelphiShallowParser() {
        super(EDelphiParserStates.class, EDelphiParserStates.TOP_LEVEL);
        this.createTopLevelRules();
        this.createTypeRules();
        this.createEnumRules();
        this.createTypeDeclRules();
        this.createMethodSectionRules();
        this.createVarRules();
        this.createConstRules();
        this.createMethodRules();
        this.createClassAttributeRules();
    }

    private void createTopLevelRules() {
        this.inState(new EDelphiParserStates[]{EDelphiParserStates.TOP_LEVEL}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PROGRAM, ETokenType.UNIT})).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.USES}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).endNode();
        this.inState(new EDelphiParserStates[]{EDelphiParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.INTERFACE}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).parseUntilOrEof(EDelphiParserStates.IN_INTERFACE).sequenceBefore(TOP_LEVEL_KEYWORDS).endNode();
        this.inState(new EDelphiParserStates[]{EDelphiParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.IMPLEMENTATION}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).parseUntilOrEof(EDelphiParserStates.IN_IMPLEMENTATION).sequenceBefore(TOP_LEVEL_KEYWORDS).endNode();
        this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_INTERFACE}).sequence(new ITokenMatcher[]{ETokenType.TYPE}).parseUntilOrEof(EDelphiParserStates.IN_TYPE).sequenceBefore(TOP_LEVEL_OR_SECTION_KEYWORDS);
        this.inState(SECTION_STATES).sequence(new ITokenMatcher[]{ETokenType.VAR}).parseUntilOrEof(EDelphiParserStates.IN_VAR).sequenceBefore(TOP_LEVEL_OR_SECTION_KEYWORDS);
        this.inState(SECTION_STATES).sequence(new ITokenMatcher[]{ETokenType.CONST}).parseUntilOrEof(EDelphiParserStates.IN_CONST).sequenceBefore(TOP_LEVEL_OR_SECTION_KEYWORDS);
        this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_INTERFACE}).sequence(new ITokenMatcher[]{METHOD_KEYWORDS, ETokenType.IDENTIFIER}).repeated(new ITokenMatcher[]{ETokenType.DOT, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.METHOD, INameResolver.firstMatchedTokenText(), INameResolver.ofRange(1, -1)).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        RecognizerBase<EDelphiParserStates> methodRecognizer = this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_IMPLEMENTATION, EDelphiParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{METHOD_KEYWORDS, ETokenType.IDENTIFIER}).repeated(new ITokenMatcher[]{ETokenType.DOT, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.METHOD, INameResolver.firstMatchedTokenText(), INameResolver.ofRange(1, -1)).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).parseUntilOrEof(EDelphiParserStates.IN_METHOD);
        methodRecognizer.sequence(new ITokenMatcher[]{ETokenType.END}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EDelphiParserStates[]{EDelphiParserStates.TOP_LEVEL, EDelphiParserStates.IN_IMPLEMENTATION}).sequence(new ITokenMatcher[]{ETokenType.BEGIN}).createNode(EShallowEntityType.METHOD, "global begin").parseUntil(EDelphiParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.END}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EDelphiParserStates[]{EDelphiParserStates.TOP_LEVEL}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.INITIALIZATION, ETokenType.FINALIZATION})).createNode(EShallowEntityType.METHOD, INameResolver.firstMatchedTokenText()).parseUntil(EDelphiParserStates.IN_METHOD).sequenceBefore(TOP_LEVEL_OR_SECTION_KEYWORDS).endNode();
    }

    private void createTypeRules() {
        RecognizerBase typeAlternative = this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).skipAfter(new ITokenMatcher[]{ETokenType.EQ});
        typeAlternative.optional(new ITokenMatcher[]{ETokenType.TYPE}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.SEMICOLON}).createNode(EShallowEntityType.TYPE, "alias", INameResolver.firstMatchedTokenText()).endNode();
        typeAlternative.sequence(new ITokenMatcher[]{ETokenType.XOR, ETokenType.IDENTIFIER, ETokenType.SEMICOLON}).createNode(EShallowEntityType.TYPE, "type pointer", INameResolver.firstMatchedTokenText()).endNode();
        typeAlternative.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ARRAY, ETokenType.FILE})).skipAfterWithNesting((ITokenMatcher)ETokenType.SEMICOLON, ETokenType.LPAREN, ETokenType.RPAREN).createNode(EShallowEntityType.TYPE, INameResolver.ofIndex(2), INameResolver.firstMatchedTokenText()).endNode();
        typeAlternative.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PROCEDURE, ETokenType.FUNCTION})).createNode(EShallowEntityType.TYPE, "function pointer", INameResolver.firstMatchedTokenText()).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        typeAlternative.sequence(new ITokenMatcher[]{ETokenType.REFERENCE, ETokenType.TO, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PROCEDURE, ETokenType.FUNCTION})}).createNode(EShallowEntityType.TYPE, "anonymous method", INameResolver.firstMatchedTokenText()).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        typeAlternative.sequence(new ITokenMatcher[]{ETokenType.LPAREN}).createNode(EShallowEntityType.TYPE, "enum", INameResolver.firstMatchedTokenText()).parseUntil(EDelphiParserStates.IN_ENUM).sequence(new ITokenMatcher[]{ETokenType.RPAREN, ETokenType.SEMICOLON}).endNode();
        ITokenMatcher rangeTypes = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.INTEGER_LITERAL, ETokenType.STRING_LITERAL});
        typeAlternative.sequence(new ITokenMatcher[]{rangeTypes, ETokenType.DOUBLE_DOT, rangeTypes, ETokenType.SEMICOLON}).createNode(EShallowEntityType.TYPE, "range", INameResolver.firstMatchedTokenText()).endNode();
        typeAlternative.sequence(new ITokenMatcher[]{ETokenType.SET, ETokenType.OF}).createNode(EShallowEntityType.TYPE, "set", INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        typeAlternative.sequence(new ITokenMatcher[]{ETokenType.CLASS, ETokenType.OF, ETokenType.CLASS, ETokenType.TYPE, ETokenType.SEMICOLON}).createNode(EShallowEntityType.TYPE, "meta class", INameResolver.firstMatchedTokenText()).endNode();
        RecognizerBase<EDelphiParserStates> declAlternative = typeAlternative.optional(new ITokenMatcher[]{ETokenType.PACKED}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CLASS, ETokenType.INTERFACE, ETokenType.RECORD, ETokenType.DISPINTERFACE})).createNode(EShallowEntityType.TYPE, INameResolver.previousTokenText(), INameResolver.firstMatchedTokenText()).skipNested(ETokenType.LPAREN, ETokenType.RPAREN);
        DelphiShallowParser.endTypeDeclaration(declAlternative.sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).sequence(new ITokenMatcher[]{ETokenType.FOR, ETokenType.IDENTIFIER}));
        DelphiShallowParser.endTypeDeclaration(declAlternative);
    }

    private static void endTypeDeclaration(RecognizerBase<EDelphiParserStates> recognizer) {
        recognizer.sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        recognizer.parseUntil(EDelphiParserStates.IN_TYPE_DECL).sequence(new ITokenMatcher[]{ETokenType.END}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createEnumRules() {
        this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_ENUM}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).optional(new ITokenMatcher[]{ETokenType.EQ, ETokenType.INTEGER_LITERAL}).createNode(EShallowEntityType.ATTRIBUTE, "enum literal", INameResolver.firstMatchedTokenText()).endNode();
        this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_ENUM}).sequence(new ITokenMatcher[]{ETokenType.COMMA, ETokenType.IDENTIFIER}).optional(new ITokenMatcher[]{ETokenType.EQ, ETokenType.INTEGER_LITERAL}).createNode(EShallowEntityType.ATTRIBUTE, "enum literal", INameResolver.secondMatchedTokenText()).endNode();
    }

    private void createTypeDeclRules() {
        this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_TYPE_DECL}).optional(new ITokenMatcher[]{ETokenType.STRICT}).sequence(ACCESS_MODIFIERS).createNode(EShallowEntityType.META, INameResolver.ofRange(0, -1)).endNode();
        RecognizerBase<EDelphiParserStates> methodBase = this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_TYPE_DECL}).optional(new ITokenMatcher[]{ETokenType.CLASS}).sequence(new ITokenMatcher[]{METHOD_KEYWORDS, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.METHOD, INameResolver.ofIndex(-2), INameResolver.previousTokenText()).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON});
        DelphiShallowParser.appendMethodModifierRules(methodBase);
        this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_TYPE_DECL}).sequence(new ITokenMatcher[]{ETokenType.PROPERTY}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.ATTRIBUTE, "property", INameResolver.secondMatchedTokenText()).endNode();
        this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_TYPE_DECL}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.ATTRIBUTE, "attribute", INameResolver.firstMatchedTokenText()).endNode();
        this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_TYPE_DECL}).sequence(new ITokenMatcher[]{ETokenType.CASE}).skipAfter(new ITokenMatcher[]{ETokenType.OF}).createNode(EShallowEntityType.META, "case").parseUntil(EDelphiParserStates.IN_TYPE_CASE).sequenceBefore(TYPE_MEMBER_TOKENS).endNode();
        this.createTypeCaseRules();
    }

    private void createTypeCaseRules() {
        this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_TYPE_CASE}).sequence(CASE_LITERALS).skipAfter(new ITokenMatcher[]{ETokenType.COLON}).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).createNode(EShallowEntityType.META, "case label", INameResolver.firstMatchedTokenText()).parseUntil(EDelphiParserStates.IN_TYPE_CASE_LABEL).sequence(new ITokenMatcher[]{ETokenType.RPAREN, ETokenType.SEMICOLON}).endNode();
        this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_TYPE_CASE_LABEL}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.COLON}).createNode(EShallowEntityType.ATTRIBUTE, "attribute", INameResolver.firstMatchedTokenText()).skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RPAREN})).endNode();
    }

    private void createMethodSectionRules() {
        this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.VAR}).parseUntil(EDelphiParserStates.IN_VAR).sequenceBefore(METHOD_SECTION_TOKENS);
        this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.CONST}).parseUntil(EDelphiParserStates.IN_CONST).sequenceBefore(METHOD_SECTION_TOKENS);
        this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.TYPE}).parseUntil(EDelphiParserStates.IN_TYPE).sequenceBefore(METHOD_SECTION_TOKENS);
        this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.BEGIN}).parseUntil(EDelphiParserStates.IN_METHOD).sequenceBefore(new ITokenMatcher[]{ETokenType.END}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON});
    }

    private void createVarRules() {
        this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_VAR}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.COLON}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.STATEMENT, "local variable", INameResolver.firstMatchedTokenText()).endNode();
    }

    private void createConstRules() {
        this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_CONST}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).optional(new ITokenMatcher[]{ETokenType.COLON}).skipAfter(new ITokenMatcher[]{ETokenType.EQ}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.STATEMENT, "constant", INameResolver.firstMatchedTokenText()).endNode();
    }

    private void createMethodRules() {
        this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.BEGIN}).createNode(EShallowEntityType.STATEMENT, "anonymous block").parseUntil(EDelphiParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.END}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.createIfElseRules();
        this.createTryExceptFinallyRules();
        this.createLoopRules();
        this.createCaseRules();
        this.createWithRules();
        this.createSimpleStatementRules();
    }

    private static void appendMethodModifierRules(RecognizerBase<EDelphiParserStates> recognizer) {
        RecognizerBase<EDelphiParserStates> modifierAlternative = recognizer.repeated(new ITokenMatcher[]{METHOD_MODIFIERS, ETokenType.SEMICOLON});
        modifierAlternative.sequence(new ITokenMatcher[]{ETokenType.EXTERNAL}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        modifierAlternative.endNode();
    }

    private void createIfElseRules() {
        RecognizerBase<EDelphiParserStates> ifAlternative = this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.IF}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.THEN});
        RecognizerBase<EDelphiParserStates> ifAlternativeWithBlock = ifAlternative.sequence(new ITokenMatcher[]{ETokenType.BEGIN}).parseUntil(EDelphiParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.END});
        ifAlternativeWithBlock.sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.endWithPossibleContinuation(ifAlternativeWithBlock, (ITokenMatcher)ETokenType.ELSE);
        this.endWithPossibleContinuation(ifAlternative.parseOnce(EDelphiParserStates.IN_METHOD), (ITokenMatcher)ETokenType.ELSE);
        ifAlternative.sequenceBefore(new ITokenMatcher[]{ETokenType.END}).endNode();
        RecognizerBase<EDelphiParserStates> elseIfAlternative = this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.ELSE, ETokenType.IF}).createNode(EShallowEntityType.STATEMENT, INameResolver.ofIndices(0, 1)).skipAfter(new ITokenMatcher[]{ETokenType.THEN});
        RecognizerBase<EDelphiParserStates> elseIfAlternativeWithBlock = elseIfAlternative.sequence(new ITokenMatcher[]{ETokenType.BEGIN}).parseUntil(EDelphiParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.END});
        elseIfAlternativeWithBlock.sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.endWithPossibleContinuation(elseIfAlternativeWithBlock, (ITokenMatcher)ETokenType.ELSE);
        this.endWithPossibleContinuation(elseIfAlternative.parseOnce(EDelphiParserStates.IN_METHOD), (ITokenMatcher)ETokenType.ELSE);
        elseIfAlternative.sequenceBefore(new ITokenMatcher[]{ETokenType.END}).endNode();
        RecognizerBase<EDelphiParserStates> elseAlternative = this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.ELSE}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText());
        elseAlternative.sequence(new ITokenMatcher[]{ETokenType.BEGIN}).parseUntil(EDelphiParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.END}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        elseAlternative.parseOnce(EDelphiParserStates.IN_METHOD).endNode();
        elseAlternative.sequenceBefore(new ITokenMatcher[]{ETokenType.END}).endNode();
    }

    private void createTryExceptFinallyRules() {
        RecognizerBase<EDelphiParserStates> tryAlternative = this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.TRY}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).parseUntil(EDelphiParserStates.IN_METHOD);
        DelphiShallowParser.endWithContinuationOrEnd(tryAlternative, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EXCEPT, ETokenType.FINALLY}));
        RecognizerBase<EDelphiParserStates> exceptAlternative = this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.EXCEPT}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).parseUntil(EDelphiParserStates.IN_METHOD);
        DelphiShallowParser.endWithContinuationOrEnd(exceptAlternative, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EXCEPT, ETokenType.FINALLY}));
        this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.FINALLY}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).parseUntil(EDelphiParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.END}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        RecognizerBase<EDelphiParserStates> onAlternative = this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.ON, ETokenType.IDENTIFIER, ETokenType.COLON, ETokenType.IDENTIFIER, ETokenType.DO}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText());
        this.endWithPossibleContinuation(onAlternative.sequence(new ITokenMatcher[]{ETokenType.BEGIN}).parseUntil(EDelphiParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.END}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}), ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ON, ETokenType.ELSE}));
        this.endWithPossibleContinuation(onAlternative.parseOnce(EDelphiParserStates.IN_METHOD), ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ON, ETokenType.ELSE}));
    }

    private static void endWithContinuationOrEnd(RecognizerBase<EDelphiParserStates> recognizer, ITokenMatcher continuationTokens) {
        recognizer.sequenceBefore(continuationTokens).endNodeWithContinuation();
        recognizer.sequence(new ITokenMatcher[]{ETokenType.END}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createLoopRules() {
        this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.REPEAT}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).parseUntil(EDelphiParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.UNTIL}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        RecognizerBase<EDelphiParserStates> whileForAlternative = this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_METHOD}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.WHILE, ETokenType.FOR})).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DO});
        whileForAlternative.sequence(new ITokenMatcher[]{ETokenType.BEGIN}).parseUntil(EDelphiParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.END}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        whileForAlternative.parseOnce(EDelphiParserStates.IN_METHOD).endNode();
    }

    private void createCaseRules() {
        this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.CASE}).skipAfter(new ITokenMatcher[]{ETokenType.OF}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).parseUntil(EDelphiParserStates.IN_CASE).sequence(new ITokenMatcher[]{ETokenType.END}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        DelphiShallowParser.appendCaseLabelBody(this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_CASE}).sequence(CASE_LITERALS).skipAfter(new ITokenMatcher[]{ETokenType.COLON}).createNode(EShallowEntityType.META, "case", INameResolver.firstMatchedTokenText()));
        RecognizerBase<EDelphiParserStates> elseAlternative = this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_CASE}).sequence(new ITokenMatcher[]{ETokenType.ELSE}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText());
        elseAlternative.sequence(new ITokenMatcher[]{ETokenType.BEGIN}).parseUntil(EDelphiParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.END}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        elseAlternative.parseUntil(EDelphiParserStates.IN_METHOD).sequenceBefore(new ITokenMatcher[]{ETokenType.END}).endNode();
    }

    private static void appendCaseLabelBody(RecognizerBase<EDelphiParserStates> recognizer) {
        recognizer.sequenceBefore(new ITokenMatcher[]{ETokenType.END}).endNode();
        DelphiShallowParser.endCaseLabelRecognizer(recognizer.sequence(new ITokenMatcher[]{ETokenType.BEGIN}).parseUntil(EDelphiParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.END}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}));
        DelphiShallowParser.endCaseLabelRecognizer(recognizer.parseOnce(EDelphiParserStates.IN_METHOD));
    }

    private static void endCaseLabelRecognizer(RecognizerBase<EDelphiParserStates> recognizer) {
        recognizer.sequenceBefore(CASE_LITERALS.or(new ITokenMatcher[]{ETokenType.ELSE, ETokenType.END})).endNode();
    }

    private void createWithRules() {
        RecognizerBase<EDelphiParserStates> withRecognizer = this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.WITH}).skipAfter(new ITokenMatcher[]{ETokenType.DO}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText());
        withRecognizer.sequence(new ITokenMatcher[]{ETokenType.BEGIN}).parseUntil(EDelphiParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.END}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        withRecognizer.parseOnce(EDelphiParserStates.IN_METHOD).endNode();
        withRecognizer.sequenceBefore(new ITokenMatcher[]{ETokenType.END}).endNode();
    }

    private void createSimpleStatementRules() {
        this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_METHOD}).sequence(SIMPLE_STATEMENT_TOKENS).skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.UNTIL, ETokenType.ELSE, ETokenType.END})).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.STATEMENT, "simple statement", INameResolver.firstMatchedTokenText()).endNode();
        this.inState(new EDelphiParserStates[]{EDelphiParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.STATEMENT, "empty statement").endNode();
    }

    private void createClassAttributeRules() {
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.LBRACK}).skipAfterWithNesting((ITokenMatcher)ETokenType.RBRACK, ETokenType.LBRACK, ETokenType.RBRACK).createNode(EShallowEntityType.META, "attribute", INameResolver.secondMatchedTokenText()).endNode();
    }

    public static enum EDelphiParserStates {
        TOP_LEVEL,
        IN_INTERFACE,
        IN_IMPLEMENTATION,
        IN_TYPE,
        IN_TYPE_DECL,
        IN_TYPE_CASE,
        IN_TYPE_CASE_LABEL,
        IN_ENUM,
        IN_VAR,
        IN_CONST,
        IN_CASE,
        IN_METHOD_HEAD,
        IN_METHOD;

    }
}

