/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.jsbuild.export;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.atteo.classindex.IndexSubclasses;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

@IndexSubclasses
public abstract class TsClassGeneratorBase {
    private final File typedefsFolder;
    private final List<File> writtenFiles = new ArrayList<File>();

    protected TsClassGeneratorBase(File typedefsFolder) {
        this.typedefsFolder = typedefsFolder;
    }

    protected void addGeneratedJavaScript(String classFileName, String typescriptCode) throws IOException {
        String tsFileName = classFileName + ".ts";
        File file = new File(this.typedefsFolder, tsFileName);
        this.writtenFiles.add(file);
        FileSystemUtils.writeFileUTF8((File)file, (String)typescriptCode);
    }

    public abstract void generateFiles() throws IOException;

    public List<File> getWrittenFiles() {
        return this.writtenFiles;
    }
}

