/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.rest.client;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.Retrofit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Headers;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jetbrains.annotations.VisibleForTesting;
import retrofit2.Call;

public final class HttpPaginationUtils {
    private static final Pattern LINK_HEADER_PARSE_PATTERN = Pattern.compile("<(.*?)>;\\s*rel=\"(.*?)\"");

    public static Optional<String> extractNextLinkFromHeaders(Headers headers) {
        return Optional.ofNullable(headers.get("Link")).map(HttpPaginationUtils::extractNextLinkFromHeaders);
    }

    @VisibleForTesting
    static String extractNextLinkFromHeaders(String linkHeaderValue) {
        for (String link : linkHeaderValue.split(",")) {
            Matcher matcher = LINK_HEADER_PARSE_PATTERN.matcher(link);
            if (!matcher.find() || !"next".equals(matcher.group(2))) continue;
            return matcher.group(1);
        }
        return null;
    }

    public static <T> List<T> executeGetWithLinkHeaderPagination(Supplier<Call<T[]>> initialRequest, Function<String, Call<T[]>> followupRequest) throws ServiceCallException {
        return HttpPaginationUtils.executeGetWithLinkHeaderPagination(initialRequest, followupRequest, Arrays::asList);
    }

    public static <T, R> List<R> executeGetWithLinkHeaderPagination(Supplier<Call<T>> initialRequest, Function<String, Call<T>> followupRequest, Function<T, List<R>> unpackFunction) throws ServiceCallException {
        Pair<Headers, Optional<T>> currentResponse = Retrofit.executeServiceCallAndGetHeaders(initialRequest.get());
        Object value = ((Optional)currentResponse.getSecond()).orElseThrow();
        ArrayList result = new ArrayList(unpackFunction.apply(value));
        Optional<String> nextLink = HttpPaginationUtils.extractNextLinkFromHeaders((Headers)currentResponse.getFirst());
        while (nextLink.isPresent()) {
            String url = nextLink.get();
            currentResponse = Retrofit.executeServiceCallAndGetHeaders(followupRequest.apply(url));
            value = ((Optional)currentResponse.getSecond()).orElseThrow();
            result.addAll(unpackFunction.apply(value));
            nextLink = HttpPaginationUtils.extractNextLinkFromHeaders((Headers)currentResponse.getFirst());
        }
        return result;
    }

    public static <T, R> List<R> executeGetWithNextParameterPagination(Supplier<Call<T>> initialCallSupplier, Function<String, Call<T>> followupCallFunction, Function<T, Optional<String>> nextParameterFunction, Function<T, List<R>> responseDataExtractor) throws ServiceCallException {
        Optional<T> currentResponse = Retrofit.executeServiceCall(initialCallSupplier.get());
        T value = currentResponse.orElseThrow();
        ArrayList result = new ArrayList(responseDataExtractor.apply(value));
        Optional<String> nextLink = nextParameterFunction.apply(value);
        while (nextLink.isPresent()) {
            String url = nextLink.get();
            currentResponse = Retrofit.executeServiceCall(followupCallFunction.apply(url));
            value = currentResponse.orElseThrow();
            result.addAll(responseDataExtractor.apply(value));
            nextLink = nextParameterFunction.apply(value);
        }
        return result;
    }

    private HttpPaginationUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

