/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.builder.ISimulinkDataDictionaryEntry;
import org.conqat.lib.simulink.builder.MatlabVariable;
import org.conqat.lib.simulink.builder.SimulinkBreakpoint;
import org.conqat.lib.simulink.builder.SimulinkLookupTable;
import org.conqat.lib.simulink.builder.SimulinkModelWorkspace;
import org.conqat.lib.simulink.builder.SimulinkNumericType;
import org.conqat.lib.simulink.builder.SimulinkParameter;
import org.conqat.lib.simulink.builder.SimulinkSignal;
import org.conqat.lib.simulink.builder.file.ISimulinkFileContentProvider;
import org.jspecify.annotations.NonNull;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.format.Mat5File;
import us.hebi.matlab.mat.types.AbstractStruct;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Cell;
import us.hebi.matlab.mat.types.MatFile;
import us.hebi.matlab.mat.types.Matrix;
import us.hebi.matlab.mat.types.ObjectStruct;
import us.hebi.matlab.mat.types.Opaque;
import us.hebi.matlab.mat.types.Source;
import us.hebi.matlab.mat.types.Sources;

public class SimulinkModelWorkspaceParser {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String MODEL_WORKSPACE_MXARRAY_FILENAME = "simulink/modelWorkspace.mxarray";

    public static SimulinkModelWorkspace parseModelWorkspace(ISimulinkFileContentProvider contentProvider, String uniformPath) {
        Mat5File parsedModelWorkspace;
        Optional<byte[]> content = contentProvider.getNamedBinaryContent(MODEL_WORKSPACE_MXARRAY_FILENAME);
        if (!content.isPresent()) {
            return SimulinkModelWorkspace.EMPTY_MODEL_WORKSPACE;
        }
        try (Source source = Sources.wrap((byte[])content.get());){
            parsedModelWorkspace = Mat5.newReader((Source)source).setReducedHeader(true).readMat();
        }
        catch (IOException e) {
            LOGGER.warn("Could not parse Model Workspace from " + uniformPath, (Throwable)e);
            return SimulinkModelWorkspace.EMPTY_MODEL_WORKSPACE;
        }
        return SimulinkModelWorkspaceParser.parseMatFile(parsedModelWorkspace);
    }

    private static @NonNull SimulinkModelWorkspace parseMatFile(Mat5File parsedModelWorkspace) {
        HashSet<ISimulinkDataDictionaryEntry> entries = new HashSet<ISimulinkDataDictionaryEntry>();
        for (MatFile.Entry entry : parsedModelWorkspace.getEntries()) {
            AbstractStruct entryStruct = (AbstractStruct)entry.getValue();
            for (String fieldName : entryStruct.getFieldNames()) {
                Array field = entryStruct.get(fieldName);
                Optional<? extends ISimulinkDataDictionaryEntry> extractedEntry = SimulinkModelWorkspaceParser.extractEntryFromField(field, fieldName);
                extractedEntry.ifPresent(entries::add);
            }
        }
        if (entries.isEmpty()) {
            return SimulinkModelWorkspace.EMPTY_MODEL_WORKSPACE;
        }
        return new SimulinkModelWorkspace(entries);
    }

    private static Optional<? extends ISimulinkDataDictionaryEntry> extractEntryFromField(Array field, String fieldName) {
        if (field instanceof ObjectStruct) {
            String classname;
            ObjectStruct objectField = (ObjectStruct)field;
            switch (classname = objectField.getPackageName() + "." + objectField.getClassName()) {
                case "Simulink.NumericType": {
                    String dataType = StringUtils.removeSingleQuotes((String)objectField.get("DataTypeMode").toString());
                    return Optional.of(new SimulinkNumericType(fieldName, dataType));
                }
                case "Simulink.DualScaledParameter": 
                case "SimulinkDemos.Parameter": 
                case "mpt.Parameter": 
                case "Simulink.Parameter": {
                    String dataType = StringUtils.removeSingleQuotes((String)objectField.get("DataType").toString());
                    String value = SimulinkModelWorkspaceParser.extractValueFromSimulinkParameterObject(objectField);
                    Pair<Integer, Integer> dimensions = SimulinkModelWorkspaceParser.extractDimensionsFromSimulinkParameterObject(objectField);
                    return Optional.of(new SimulinkParameter(fieldName, dataType, value, null, dimensions));
                }
                case "Simulink.Breakpoint": {
                    return Optional.of(new SimulinkBreakpoint(fieldName));
                }
                case "Simulink.LookupTable": {
                    String dataType = StringUtils.removeSingleQuotes((String)((ObjectStruct)objectField.get("Table")).get("DataType").toString());
                    return Optional.of(new SimulinkLookupTable(fieldName, dataType));
                }
                case "SimulinkDemos.Signal": 
                case "mpt.Signal": 
                case "Simulink.Signal": {
                    String dataType = StringUtils.removeSingleQuotes((String)objectField.get("DataType").toString());
                    return Optional.of(new SimulinkSignal(fieldName, dataType));
                }
            }
            return Optional.empty();
        }
        if (field instanceof Opaque) {
            return Optional.empty();
        }
        if (field instanceof Cell) {
            return Optional.of(SimulinkModelWorkspaceParser.extractMatlabVariableForCell((Cell)field, fieldName));
        }
        String type = field.getType().name();
        String value = field.toString();
        int[] dimensions = field.getDimensions();
        return Optional.of(new MatlabVariable(fieldName, type, dimensions, value));
    }

    private static @NonNull MatlabVariable extractMatlabVariableForCell(Cell cell, String fieldName) {
        ArrayList<String> valueParts = new ArrayList<String>();
        for (int i = 0; i < cell.getNumElements(); ++i) {
            Array element = cell.get(i);
            if (element instanceof Matrix) {
                Matrix matrix = (Matrix)element;
                String convertedMatrix = SimulinkModelWorkspaceParser.convertToStringMatrixRepresentation(matrix);
                if (SimulinkModelWorkspaceParser.is1x1Matrix(matrix)) {
                    convertedMatrix = StringUtils.stripSuffix((String)StringUtils.stripPrefix((String)convertedMatrix, (String)"["), (String)"]");
                }
                valueParts.add(convertedMatrix);
                continue;
            }
            valueParts.add(element.toString());
        }
        String value = "{" + StringUtils.concat(valueParts, (String)", ") + "}";
        String type = cell.getType().name();
        int[] dimensions = cell.getDimensions();
        return new MatlabVariable(fieldName, type, dimensions, value);
    }

    private static boolean is1x1Matrix(Matrix matrix) {
        return matrix.getNumDimensions() == 2 && matrix.getDimensions()[0] == 1 && matrix.getDimensions()[1] == 1;
    }

    private static String extractValueFromSimulinkParameterObject(ObjectStruct objectField) {
        Array valueField = objectField.get("Value");
        if (valueField.getNumDimensions() == 2 && (valueField.getDimensions()[0] > 1 || valueField.getDimensions()[1] > 1)) {
            return SimulinkModelWorkspaceParser.convertToStringMatrixRepresentation(objectField.getMatrix("Value"));
        }
        return valueField.toString();
    }

    public static Pair<Integer, Integer> extractDimensionsFromSimulinkParameterObject(ObjectStruct objectField) {
        int[] dimensions = objectField.getDimensions();
        if (objectField.getNumDimensions() == 2) {
            return Pair.createPair((Object)dimensions[0], (Object)dimensions[1]);
        }
        return null;
    }

    private static String convertToStringMatrixRepresentation(Matrix value) {
        int numRows = value.getNumRows();
        int numCols = value.getNumCols();
        if (numRows == 0 && numCols == 0 || value.getNumElements() == 0) {
            return "[ ]";
        }
        if (value.getNumElements() != numRows * numCols) {
            return String.valueOf(value.getDouble(0, 0));
        }
        StringBuilder result = new StringBuilder("[");
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < numCols; ++col) {
                result.append(SimulinkModelWorkspaceParser.readMatrixElement(row, col, value));
                if (col == numCols - 1) continue;
                result.append(" ");
            }
            if (row == numRows - 1) continue;
            result.append(";");
        }
        result.append("]");
        return result.toString();
    }

    private static String readMatrixElement(int row, int col, Matrix matrix) {
        switch (matrix.getType()) {
            case Int8: 
            case Int16: 
            case Int32: 
            case Int64: 
            case UInt8: 
            case UInt16: 
            case UInt32: 
            case UInt64: {
                return String.valueOf(matrix.getLong(row, col));
            }
            case Double: 
            case Single: {
                return String.valueOf(matrix.getDouble(row, col));
            }
            case Sparse: 
            case Object: 
            case Opaque: 
            case Function: 
            case Character: 
            case Structure: 
            case Cell: {
                return "";
            }
        }
        LOGGER.info("unknown type in model workspace matrix: " + String.valueOf(matrix.getType()));
        return "";
    }
}

